/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionSorter;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CheatSheetCategoryBasedSelectionDialog
extends SelectionDialog
implements ISelectionChangedListener {
    private IDialogSettings settings;
    private CheatSheetCollectionElement cheatsheetCategories;
    private CheatSheetElement currentSelection;
    private TreeViewer categoryTreeViewer;
    private TableViewer cheatsheetSelectionViewer;
    private static final int SIZING_CATEGORY_LIST_HEIGHT = 150;
    private static final int SIZING_CATEGORY_LIST_WIDTH = 180;
    private static final int SIZING_CHEATSHEET_LIST_HEIGHT = 150;
    private static final int SIZING_CHEATSHEET_LIST_WIDTH = 350;
    private boolean okButtonState;
    private static final String STORE_SELECTED_CATEGORY_ID = "CheatSheetCategoryBasedSelectionDialog.STORE_SELECTED_CATEGORY_ID";
    private static final String STORE_EXPANDED_CATEGORIES_ID = "CheatSheetCategoryBasedSelectionDialog.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_CHEATSHEET_ID = "CheatSheetCategoryBasedSelectionDialog.STORE_SELECTED_CHEATSHEET_ID";

    public CheatSheetCategoryBasedSelectionDialog(Shell shell, CheatSheetCollectionElement cheatsheetCategories) {
        super(shell);
        this.cheatsheetCategories = cheatsheetCategories;
        this.setTitle(CheatSheetPlugin.getResourceString("%CHEAT_SHEET_SELECTION_DIALOG_TITLE"));
        this.setMessage(CheatSheetPlugin.getResourceString("%CHEAT_SHEET_SELECTION_DIALOG_MSG"));
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableOKButton(this.okButtonState);
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings workbenchSettings = CheatSheetPlugin.getPlugin().getDialogSettings();
        IDialogSettings dialogSettings = workbenchSettings.getSection("CheatSheetCategoryBasedSelectionDialog");
        if (dialogSettings == null) {
            dialogSettings = workbenchSettings.addNewSection("CheatSheetCategoryBasedSelectionDialog");
        }
        this.setDialogSettings(dialogSettings);
        Composite outerContainer = (Composite)super.createDialogArea(parent);
        Layout layout = outerContainer.getLayout();
        if (layout != null && layout instanceof GridLayout) {
            ((GridLayout)layout).numColumns = 2;
        } else {
            GridLayout gridLayout = new GridLayout();
            outerContainer.setLayout((Layout)gridLayout);
            outerContainer.setLayoutData((Object)new GridData(1808));
        }
        this.createMessageArea(outerContainer);
        Tree tree = new Tree(outerContainer, 2820);
        this.categoryTreeViewer = new TreeViewer(tree);
        GridData data = new GridData(1808);
        data.widthHint = 180;
        data.heightHint = 150;
        this.categoryTreeViewer.getTree().setLayoutData((Object)data);
        this.categoryTreeViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.categoryTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.categoryTreeViewer.setSorter((ViewerSorter)CheatSheetCollectionSorter.INSTANCE);
        this.categoryTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.categoryTreeViewer.setInput((Object)this.cheatsheetCategories);
        Table table = new Table(outerContainer, 2820);
        this.cheatsheetSelectionViewer = new TableViewer(table);
        data = new GridData(1808);
        data.widthHint = 350;
        data.heightHint = 150;
        this.cheatsheetSelectionViewer.getTable().setLayoutData((Object)data);
        this.cheatsheetSelectionViewer.setContentProvider(this.getCheatSheetProvider());
        this.cheatsheetSelectionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.cheatsheetSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.cheatsheetSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CheatSheetCategoryBasedSelectionDialog.this.okPressed();
            }
        });
        this.restoreWidgetValues();
        if (!this.categoryTreeViewer.getSelection().isEmpty()) {
            this.categoryTreeViewer.getTree().setFocus();
        }
        Dialog.applyDialogFont((Control)outerContainer);
        return outerContainer;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.getMessage());
        GridData gridData = new GridData(784);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void enableOKButton(boolean value) {
        Button button = this.getButton(0);
        this.okButtonState = value;
        if (button != null) {
            button.setEnabled(value);
        }
    }

    protected void expandPreviouslyExpandedCategories() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        ArrayList<CheatSheetCollectionElement> categoriesToExpand = new ArrayList<CheatSheetCollectionElement>(expandedCategoryPaths.length);
        int i = 0;
        while (i < expandedCategoryPaths.length) {
            CheatSheetCollectionElement category = this.cheatsheetCategories.findChildCollection((IPath)new Path(expandedCategoryPaths[i]));
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            this.categoryTreeViewer.setExpandedElements(categoriesToExpand.toArray());
        }
    }

    protected IContentProvider getCheatSheetProvider() {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof CheatSheetCollectionElement) {
                    return ((CheatSheetCollectionElement)((Object)o)).getCheatSheets();
                }
                return new Object[0];
            }
        };
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        return selection.size() == 1 ? selection.getFirstElement() : null;
    }

    private void handleCategorySelection(SelectionChangedEvent selectionEvent) {
        Object selectedCategory;
        Object selection = this.cheatsheetSelectionViewer.getInput();
        if (selection != (selectedCategory = this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection()))) {
            this.cheatsheetSelectionViewer.setInput(selectedCategory);
            this.enableOKButton(false);
        }
    }

    private void handleCheatSheetSelection(SelectionChangedEvent selectionEvent) {
        this.currentSelection = (CheatSheetElement)((Object)this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection()));
        if (this.currentSelection != null) {
            this.enableOKButton(true);
        }
    }

    protected void okPressed() {
        if (this.currentSelection == null) {
            return;
        }
        ArrayList<CheatSheetElement> result = new ArrayList<CheatSheetElement>(1);
        result.add(this.currentSelection);
        this.setResult(result);
        this.saveWidgetValues();
        super.okPressed();
    }

    protected void restoreWidgetValues() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (expandedCategoryPaths == null) {
            return;
        }
        this.expandPreviouslyExpandedCategories();
        this.selectPreviouslySelectedCategoryAndCheatSheet();
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories();
        this.storeSelectedCategoryAndCheatSheet();
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        if (selectionEvent.getSelectionProvider().equals(this.categoryTreeViewer)) {
            this.handleCategorySelection(selectionEvent);
        } else {
            this.handleCheatSheetSelection(selectionEvent);
        }
    }

    protected void selectPreviouslySelectedCategoryAndCheatSheet() {
        String categoryId = this.settings.get(STORE_SELECTED_CATEGORY_ID);
        if (categoryId == null) {
            return;
        }
        CheatSheetCollectionElement category = this.cheatsheetCategories.findChildCollection((IPath)new Path(categoryId));
        if (category == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)category);
        this.categoryTreeViewer.setSelection((ISelection)selection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.categoryTreeViewer, (ISelection)selection));
        String cheatsheetId = this.settings.get(STORE_SELECTED_CHEATSHEET_ID);
        if (cheatsheetId == null) {
            return;
        }
        CheatSheetElement cheatsheet = category.findCheatSheet(cheatsheetId, false);
        if (cheatsheet == null) {
            return;
        }
        selection = new StructuredSelection((Object)cheatsheet);
        this.cheatsheetSelectionViewer.setSelection((ISelection)selection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.cheatsheetSelectionViewer, (ISelection)selection));
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    protected void storeExpandedCategories() {
        Object[] expandedElements = this.categoryTreeViewer.getExpandedElements();
        String[] expandedElementPaths = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedElementPaths[i] = ((CheatSheetCollectionElement)((Object)expandedElements[i])).getPath().toString();
            ++i;
        }
        this.settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedElementPaths);
    }

    protected void storeSelectedCategoryAndCheatSheet() {
        CheatSheetElement selectedCheatSheet;
        CheatSheetCollectionElement selectedCategory = (CheatSheetCollectionElement)((Object)this.getSingleSelection((IStructuredSelection)this.categoryTreeViewer.getSelection()));
        if (selectedCategory != null) {
            this.settings.put(STORE_SELECTED_CATEGORY_ID, selectedCategory.getPath().toString());
        }
        if ((selectedCheatSheet = (CheatSheetElement)((Object)this.getSingleSelection((IStructuredSelection)this.cheatsheetSelectionViewer.getSelection()))) != null) {
            this.settings.put(STORE_SELECTED_CHEATSHEET_ID, selectedCheatSheet.getID());
        }
    }
}

