/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;

public class BundleDescriptionImpl
implements BundleDescription,
KeyedElement {
    private long bundleId = -1L;
    private String symbolicName;
    private String location;
    private int state;
    private Version version;
    private HostSpecification host;
    private PackageSpecification[] packages;
    private String[] providedPackages;
    private BundleSpecification[] requiredBundles;
    private boolean singleton;
    private State containingState;
    private Object userObject;

    public String getLocation() {
        return this.location;
    }

    public boolean isResolved() {
        return (this.state & 4) != 0;
    }

    public State getContainingState() {
        return this.containingState;
    }

    public int getState() {
        return this.state;
    }

    public Version getVersion() {
        return this.version;
    }

    public BundleDescription[] getFragments() {
        if (this.host != null) {
            return new BundleDescription[0];
        }
        return ((StateImpl)this.containingState).getFragments(this);
    }

    public HostSpecification getHost() {
        return this.host;
    }

    public void setContainingState(State value) {
        this.containingState = value;
    }

    public void setHost(HostSpecification host) {
        this.host = host;
        if (host != null) {
            ((VersionConstraintImpl)host).setBundle(this);
        }
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPackages(PackageSpecification[] packages) {
        this.packages = packages;
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                ((VersionConstraintImpl)packages[i]).setBundle(this);
                ++i;
            }
        }
    }

    public void setProvidedPackages(String[] providedPackages) {
        this.providedPackages = providedPackages;
    }

    public void setRequiredBundles(BundleSpecification[] requiredBundles) {
        this.requiredBundles = requiredBundles;
        if (requiredBundles != null) {
            int i = 0;
            while (i < requiredBundles.length) {
                ((VersionConstraintImpl)requiredBundles[i]).setBundle(this);
                ++i;
            }
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setSymbolicName(String value) {
        this.symbolicName = value;
    }

    public void setVersion(Version value) {
        this.version = value;
    }

    public PackageSpecification[] getPackages() {
        if (this.packages == null) {
            return new PackageSpecification[0];
        }
        return this.packages;
    }

    public String[] getProvidedPackages() {
        if (this.providedPackages == null) {
            return new String[0];
        }
        return this.providedPackages;
    }

    public BundleSpecification[] getRequiredBundles() {
        if (this.requiredBundles == null) {
            return new BundleSpecification[0];
        }
        return this.requiredBundles;
    }

    public BundleSpecification getRequiredBundle(String name) {
        if (this.requiredBundles == null) {
            return null;
        }
        int i = 0;
        while (i < this.requiredBundles.length) {
            if (this.requiredBundles[i].getName().equals(name)) {
                return this.requiredBundles[i];
            }
            ++i;
        }
        return null;
    }

    public String getUniqueId() {
        return this.getSymbolicName();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public PackageSpecification getPackage(String name) {
        if (this.packages == null) {
            return null;
        }
        int i = 0;
        while (i < this.packages.length) {
            if (this.packages[i].getName().equals(name)) {
                return this.packages[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getSymbolicName()) + "_" + this.getVersion();
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    public Object getKey() {
        return new Long(this.bundleId);
    }

    public boolean compare(KeyedElement other) {
        if (!(other instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl otherBundleDescription = (BundleDescriptionImpl)other;
        return this.bundleId == otherBundleDescription.bundleId;
    }

    public int getKeyHashCode() {
        return (int)(this.bundleId % Integer.MAX_VALUE);
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public int hashCode() {
        if (this.symbolicName == null) {
            return (int)(this.bundleId % Integer.MAX_VALUE);
        }
        return (int)(this.bundleId * (long)this.symbolicName.hashCode() % Integer.MAX_VALUE);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BundleDescription)) {
            return false;
        }
        BundleDescription other = (BundleDescription)object;
        return this.bundleId == other.getBundleId() && (this.symbolicName == null & other.getSymbolicName() == null || this.symbolicName != null && this.symbolicName.equals(other.getSymbolicName()));
    }
}

