/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.DocumentCharSequence;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor
implements IResourceProxyVisitor {
    private ISearchScope fScope;
    private ITextSearchResultCollector fCollector;
    private MatchLocator fLocator;
    private Map fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private long fLastUpdateTime;
    private boolean fVisitDerived;
    private final MultiStatus fStatus;
    private boolean fAllowNIOSearch;

    public TextSearchVisitor(MatchLocator locator, ISearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MultiStatus status, int fileCount) {
        this.fScope = scope;
        this.fCollector = collector;
        this.fStatus = status;
        this.fProgressMonitor = collector.getProgressMonitor();
        this.fLocator = locator;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = fileCount;
        this.fVisitDerived = visitDerived;
        this.fAllowNIOSearch = true;
    }

    public void setAllowNIOSearch(boolean allowNIOSearch) {
        this.fAllowNIOSearch = allowNIOSearch;
    }

    public void process(Collection projects) {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            IProject project = (IProject)i.next();
            try {
                project.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                this.fStatus.add(ex.getStatus());
            }
        }
        this.fDocumentsInEditors = null;
    }

    private Map evalNonFileBufferDocuments() {
        HashMap result = new HashMap();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, textFileBuffer.getDocument());
                }
            }
        }
    }

    private boolean shouldVisit(IResourceProxy proxy) {
        if (!this.fScope.encloses(proxy)) {
            return false;
        }
        return this.fVisitDerived || !proxy.isDerived();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResourceProxy proxy) throws CoreException {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        if (proxy.getType() != 1) {
            return true;
        }
        if (!this.shouldVisit(proxy)) {
            return false;
        }
        if (this.fLocator.isEmtpy()) {
            this.fCollector.accept(proxy, -1, 0);
            this.updateProgressMonitor();
            return true;
        }
        IFile file = (IFile)proxy.requestResource();
        IDocument document = (IDocument)this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null) {
            document = textFileBuffer.getDocument();
        }
        try {
            block23: {
                if (document != null) {
                    this.fLocator.locateMatches(this.fProgressMonitor, new DocumentCharSequence(document), this.fCollector, proxy);
                } else {
                    InputStream stream = null;
                    try {
                        block22: {
                            try {
                                Charset charset = Charset.forName(file.getCharset());
                                stream = file.getContents();
                                if (this.fAllowNIOSearch && stream instanceof FileInputStream) {
                                    FileChannel channel = ((FileInputStream)stream).getChannel();
                                    try {
                                        MappedByteBuffer mappedBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                                        CharBuffer searchInput = charset.decode(mappedBuffer);
                                        this.fLocator.locateMatches(this.fProgressMonitor, searchInput, this.fCollector, proxy);
                                        Object var9_17 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_16 = null;
                                        channel.close();
                                        throw throwable;
                                    }
                                    channel.close();
                                    break block22;
                                }
                                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
                                this.fLocator.locateMatches(this.fProgressMonitor, reader, this.fCollector, proxy);
                            }
                            catch (UnsupportedCharsetException e) {
                                Object[] args = new String[]{file.getCharset(), file.getFullPath().makeRelative().toString()};
                                String message = SearchMessages.getFormattedString("TextSearchVisitor.unsupportedcharset", args);
                                this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                            }
                            catch (IOException e) {
                                String message = SearchMessages.getFormattedString("TextSearchVisitor.error", file.getFullPath().makeRelative());
                                this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 2, message, (Throwable)e));
                            }
                        }
                        Object var11_20 = null;
                        if (stream == null) break block23;
                    }
                    catch (Throwable throwable) {
                        Object var11_19 = null;
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    stream.close();
                }
            }
            Object var13_23 = null;
            this.updateProgressMonitor();
            return true;
        }
        catch (Throwable throwable) {
            Object var13_22 = null;
            this.updateProgressMonitor();
            throw throwable;
        }
    }

    private void updateProgressMonitor() {
        ++this.fNumberOfScannedFiles;
        if (this.fNumberOfScannedFiles < this.fNumberOfFilesToScan && System.currentTimeMillis() - this.fLastUpdateTime > 1000L) {
            Object[] args = new String[]{String.valueOf(this.fNumberOfScannedFiles + 1), String.valueOf(this.fNumberOfFilesToScan)};
            this.fProgressMonitor.setTaskName(SearchMessages.getFormattedString("TextSearchVisitor.scanning", args));
            this.fLastUpdateTime = System.currentTimeMillis();
        }
        this.fProgressMonitor.worked(1);
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.getString("TextSearchVisitor.canceled"));
        }
    }
}

