/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.eclipse.pde.internal.core.plugin.AbstractExtensions;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class PluginBase
extends AbstractExtensions
implements IPluginBase {
    private Vector libraries = new Vector();
    private Vector imports = new Vector();
    private String providerName;
    private String id;
    private String version;
    private String schemaVersion;
    private boolean valid;

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.schemaVersion;
        this.schemaVersion = schemaVersion;
        this.firePropertyChanged("schema-version", oldValue, schemaVersion);
    }

    public void add(IPluginLibrary library) throws CoreException {
        this.ensureModelEditable();
        this.libraries.addElement(library);
        ((PluginLibrary)library).setInTheModel(true);
        ((PluginLibrary)library).setParent(this);
        this.fireStructureChanged(library, 1);
    }

    public void add(IPluginImport iimport) throws CoreException {
        this.ensureModelEditable();
        ((PluginImport)iimport).setInTheModel(true);
        ((PluginImport)iimport).setParent(this);
        this.imports.addElement(iimport);
        this.fireStructureChanged(iimport, 1);
    }

    public IPluginLibrary[] getLibraries() {
        Object[] result = new IPluginLibrary[this.libraries.size()];
        this.libraries.copyInto(result);
        return result;
    }

    public IPluginImport[] getImports() {
        Object[] result = new IPluginImport[this.imports.size()];
        this.imports.copyInto(result);
        return result;
    }

    public IPluginBase getPluginBase() {
        return this;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    void load(BundleDescription bundleDesc, PDEState state, boolean ignoreExtensions) {
        this.id = bundleDesc.getSymbolicName();
        this.version = bundleDesc.getVersion().toString();
        this.name = state.getPluginName(bundleDesc.getBundleId());
        this.providerName = state.getProviderName(bundleDesc.getBundleId());
        this.loadRuntime(bundleDesc, state);
        this.loadImports(bundleDesc);
        if (!ignoreExtensions) {
            this.loadExtensionPoints(state.getExtensionPoints(bundleDesc.getBundleId()));
            this.loadExtensions(state.getExtensions(bundleDesc.getBundleId()));
        }
    }

    void loadExtensions(NodeList list) {
        if (list != null) {
            this.extensions = new Vector();
            int i = 0;
            while (i < list.getLength()) {
                PluginExtension extension = new PluginExtension();
                extension.setInTheModel(true);
                extension.setModel(this.getModel());
                extension.setParent(this);
                extension.load(list.item(i));
                this.extensions.add(extension);
                ++i;
            }
        }
    }

    void loadExtensionPoints(NodeList list) {
        if (list != null) {
            this.extensionPoints = new Vector();
            int i = 0;
            while (i < list.getLength()) {
                PluginExtensionPoint extPoint = new PluginExtensionPoint();
                extPoint.setInTheModel(true);
                extPoint.setModel(this.getModel());
                extPoint.setParent(this);
                extPoint.load(list.item(i));
                this.extensionPoints.add(extPoint);
                ++i;
            }
        }
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("id")) {
            this.setId(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("version")) {
            this.setVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("provider-name")) {
            this.setProviderName(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("library_order")) {
            this.swap((IPluginLibrary)oldValue, (IPluginLibrary)newValue);
            return;
        }
        if (name.equals("schema-version")) {
            this.setSchemaVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void load(IPluginBase srcPluginBase) {
        PluginBase base = (PluginBase)srcPluginBase;
        this.range = base.range;
        this.id = base.id;
        this.name = base.name;
        this.providerName = base.providerName;
        this.version = base.version;
        this.schemaVersion = base.schemaVersion;
        super.load(srcPluginBase);
        this.addArrayToVector(this.imports, srcPluginBase.getImports());
        this.addArrayToVector(this.libraries, srcPluginBase.getLibraries());
        this.valid = this.hasRequiredAttributes();
    }

    void load(Node node, String schemaVersion, Hashtable lineTable) {
        this.bindSourceLocation(node, lineTable);
        this.schemaVersion = schemaVersion;
        this.id = this.getNodeAttribute(node, "id");
        this.name = this.getNodeAttribute(node, "name");
        this.providerName = this.getNodeAttribute(node, "provider-name");
        if (this.providerName == null) {
            this.providerName = this.getNodeAttribute(node, "vendor");
        }
        this.version = this.getNodeAttribute(node, "version");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.processChild(child, lineTable);
            }
            ++i;
        }
        this.valid = this.hasRequiredAttributes();
    }

    void loadRuntime(BundleDescription description, PDEState state) {
        String[] libraryNames = state.getLibraryNames(description.getBundleId());
        int i = 0;
        while (i < libraryNames.length) {
            PluginLibrary library = new PluginLibrary();
            library.setModel(this.getModel());
            library.setInTheModel(true);
            library.setParent(this);
            library.load(libraryNames[i]);
            this.libraries.add(library);
            ++i;
        }
    }

    void loadRuntime(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().toLowerCase().equals("library")) {
                PluginLibrary library = new PluginLibrary();
                library.setModel(this.getModel());
                library.setInTheModel(true);
                library.setParent(this);
                this.libraries.add(library);
                library.load(child, lineTable);
            }
            ++i;
        }
    }

    void loadImports(BundleDescription description) {
        BundleSpecification[] required = description.getRequiredBundles();
        int i = 0;
        while (i < required.length) {
            PluginImport importElement = new PluginImport();
            importElement.setModel(this.getModel());
            importElement.setInTheModel(true);
            importElement.setParent(this);
            this.imports.add(importElement);
            importElement.load(required[i]);
            ++i;
        }
        BundleDescription[] imported = PDEStateHelper.getImportedBundles(description);
        int i2 = 0;
        while (i2 < imported.length) {
            PluginImport importElement = new PluginImport();
            importElement.setModel(this.getModel());
            importElement.setInTheModel(true);
            importElement.setParent(this);
            this.imports.add(importElement);
            importElement.load(imported[i2]);
            ++i2;
        }
    }

    void loadImports(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().toLowerCase().equals("import")) {
                PluginImport importElement = new PluginImport();
                importElement.setModel(this.getModel());
                importElement.setInTheModel(true);
                importElement.setParent(this);
                this.imports.add(importElement);
                importElement.load(child, lineTable);
            }
            ++i;
        }
    }

    protected void processChild(Node child, Hashtable lineTable) {
        String name = child.getNodeName().toLowerCase();
        if (name.equals("runtime")) {
            this.loadRuntime(child, lineTable);
        } else if (name.equals("requires")) {
            this.loadImports(child, lineTable);
        } else {
            super.processChild(child, lineTable);
        }
    }

    public void remove(IPluginLibrary library) throws CoreException {
        this.ensureModelEditable();
        this.libraries.removeElement(library);
        ((PluginLibrary)library).setInTheModel(false);
        this.fireStructureChanged(library, 2);
    }

    public void remove(IPluginImport iimport) throws CoreException {
        this.ensureModelEditable();
        this.imports.removeElement(iimport);
        ((PluginImport)iimport).setInTheModel(false);
        this.fireStructureChanged(iimport, 2);
    }

    public void reset() {
        this.libraries = new Vector();
        this.imports = new Vector();
        this.providerName = null;
        this.schemaVersion = null;
        this.version = "";
        this.name = "";
        this.id = "";
        if (this.getModel() != null && this.getModel().getUnderlyingResource() != null) {
            this.name = this.id = this.getModel().getUnderlyingResource().getProject().getName();
            this.version = "0.0.0";
        }
        super.reset();
        this.valid = false;
    }

    public void setProviderName(String providerName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.providerName;
        this.providerName = providerName;
        this.firePropertyChanged("provider-name", oldValue, providerName);
    }

    public void setVersion(String newVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.version;
        this.version = newVersion;
        this.firePropertyChanged("version", oldValue, this.version);
    }

    public void setId(String newId) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.id;
        this.id = newId;
        this.firePropertyChanged("id", oldValue, this.id);
    }

    public void internalSetVersion(String newVersion) {
        this.version = newVersion;
    }

    public void swap(IPluginLibrary l1, IPluginLibrary l2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.libraries.indexOf(l1);
        int index2 = this.libraries.indexOf(l2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException(PDECore.getResourceString("PluginBase.librariesNotFoundException"));
        }
        this.libraries.setElementAt(l1, index2);
        this.libraries.setElementAt(l2, index1);
        this.firePropertyChanged(this, "library_order", l1, l2);
    }

    public void swap(IPluginImport import1, IPluginImport import2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.imports.indexOf(import1);
        int index2 = this.imports.indexOf(import2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException(PDECore.getResourceString("PluginBase.importsNotFoundException"));
        }
        this.imports.setElementAt(import1, index2);
        this.imports.setElementAt(import2, index1);
        this.firePropertyChanged(this, "import_order", import1, import2);
    }

    public boolean isValid() {
        return this.valid;
    }

    protected boolean hasRequiredAttributes() {
        if (this.name == null) {
            return false;
        }
        if (this.id == null) {
            return false;
        }
        if (this.version == null) {
            return false;
        }
        int i = 0;
        while (i < this.libraries.size()) {
            IPluginLibrary library = (IPluginLibrary)this.libraries.get(i);
            if (!library.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.imports.size()) {
            IPluginImport iimport = (IPluginImport)this.imports.get(i);
            if (!iimport.isValid()) {
                return false;
            }
            ++i;
        }
        return super.hasRequiredAttributes();
    }

    protected SAXParser getSaxParser() throws ParserConfigurationException, SAXException, FactoryConfigurationError {
        return SAXParserFactory.newInstance().newSAXParser();
    }

    public static int getMatchRule(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return 0;
        }
        Version minimum = versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? Version.maxVersion : versionRange.getMaximum();
        if (maximum.equals((Object)Version.maxVersion)) {
            return 4;
        }
        if (minimum.equals((Object)maximum)) {
            return 3;
        }
        if (!minimum.isInclusive() || maximum.isInclusive()) {
            return 0;
        }
        if (minimum.getMajorComponent() == maximum.getMajorComponent() - 1) {
            return 2;
        }
        if (minimum.getMajorComponent() != maximum.getMajorComponent()) {
            return 0;
        }
        if (minimum.getMinorComponent() == maximum.getMinorComponent() - 1) {
            return 1;
        }
        if (minimum.getMinorComponent() != maximum.getMinorComponent()) {
            return 0;
        }
        if (minimum.getMicroComponent() == maximum.getMicroComponent() - 1) {
            return 3;
        }
        return 0;
    }
}

