/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelProvider;
import org.eclipse.pde.internal.core.plugin.AbstractExtensionsModel;
import org.eclipse.pde.internal.core.plugin.Extensions;

public class WorkspaceExtensionsModel
extends AbstractExtensionsModel
implements IEditableModel,
IBundlePluginModelProvider {
    private static final long serialVersionUID = 1L;
    private IFile fUnderlyingResource;
    private boolean fDirty;
    private boolean fEditable = true;
    private transient IBundlePluginModelBase fBundleModel;

    protected NLResourceHelper createNLResourceHelper() {
        return new NLResourceHelper("plugin", this.getNLLookupLocations());
    }

    public URL getNLLookupLocation() {
        try {
            return new URL("file:" + this.getInstallLocation() + "/");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public WorkspaceExtensionsModel(IFile file) {
        this.fUnderlyingResource = file;
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.fDirty = true;
        super.fireModelChanged(event);
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {}
        return swriter.toString();
    }

    public String getInstallLocation() {
        return this.fUnderlyingResource.getLocation().removeLastSegments(1).addTrailingSeparator().toOSString();
    }

    public URL getResourceURL(String relativePath) {
        String location = this.getInstallLocation();
        if (location == null) {
            return null;
        }
        File file = new File(location);
        URL url = null;
        try {
            if (file.isFile() && file.getName().endsWith(".jar")) {
                ZipFile zip = new ZipFile(file);
                if (zip.getEntry(relativePath) != null) {
                    url = new URL("jar:file:" + file.getAbsolutePath() + "!/" + relativePath);
                }
            } else if (new File(file, relativePath).exists()) {
                url = new URL("file:" + file.getAbsolutePath() + '/' + relativePath);
            }
        }
        catch (IOException iOException) {}
        return url;
    }

    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    public boolean isInSync() {
        if (this.fUnderlyingResource == null) {
            return true;
        }
        IPath path = this.fUnderlyingResource.getLocation();
        if (path == null) {
            return false;
        }
        return super.isInSync(path.toFile());
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void load() {
        if (this.fUnderlyingResource == null) {
            return;
        }
        if (this.fUnderlyingResource.exists()) {
            try {
                InputStream stream = this.fUnderlyingResource.getContents(true);
                this.load(stream, false);
                stream.close();
            }
            catch (Exception e) {
                PDECore.logException(e);
            }
        } else {
            this.getExtensions(true);
            this.loaded = true;
        }
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.fUnderlyingResource.getLocation().toFile());
    }

    public void save() {
        if (this.fUnderlyingResource == null) {
            return;
        }
        try {
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (this.fUnderlyingResource.exists()) {
                this.fUnderlyingResource.setContents((InputStream)stream, false, false, null);
            } else {
                this.fUnderlyingResource.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {}
    }

    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            this.extensions.write("", writer);
        }
        this.fDirty = false;
    }

    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }

    protected Extensions createExtensions() {
        Extensions extensions = super.createExtensions();
        extensions.setIsFragment(this.fUnderlyingResource.getName().equals("fragment.xml"));
        return extensions;
    }

    public String toString() {
        return this.fUnderlyingResource.getName();
    }

    public void setBundleModel(IBundlePluginModelBase model) {
        this.fBundleModel = model;
    }

    public IBundlePluginModelBase getBundlePluginModel() {
        return this.fBundleModel;
    }
}

