/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.UpdateSiteErrorReporter;
import org.eclipse.pde.internal.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.builders.XMLErrorReporter;

public class UpdateSiteBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDERS_VERIFYING = "Builders.verifying";
    public static final String BUILDERS_UPDATING = "Builders.updating";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            IProject project = this.getProject();
            IFile file = project.getFile("site.xml");
            if (file.exists()) {
                this.checkFile(file, monitor);
            }
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return null;
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        String message = PDE.getFormattedMessage(BUILDERS_VERIFYING, file.getFullPath().toString());
        monitor.subTask(message);
        UpdateSiteErrorReporter reporter = new UpdateSiteErrorReporter(file);
        ValidatingSAXParser.parse(file, (XMLErrorReporter)reporter);
        if (reporter.getErrorCount() == 0) {
            reporter.validateContent(monitor);
        }
        monitor.subTask(PDE.getResourceString(BUILDERS_UPDATING));
        monitor.done();
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                try {
                    return project.hasNature("org.eclipse.pde.UpdateSiteNature");
                }
                catch (CoreException e) {
                    PDE.logException(e);
                    return false;
                }
            }
            if (resource instanceof IFile && (candidate = (IFile)resource).getName().equals("site.xml") && delta.getKind() != 2) {
                UpdateSiteBuilder.this.checkFile(candidate, this.monitor);
                return true;
            }
            return true;
        }
    }
}

