/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ResourceExtender
extends PropertyTester {
    private static final String PROPERTY_MATCHES_PATTERN = "matchesPattern";
    private static final String PROJECT_NATURE = "projectNature";
    private static final String PROPERTY_MATCHES_CONTENT_TYPE = "matchesContentType";
    static /* synthetic */ Class class$0;

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IResource resource;
        IAdaptable iAdaptable = (IAdaptable)receiver;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
            if (PROPERTY_MATCHES_PATTERN.equals(method)) {
                String fileName = resource.getName();
                String expected = (String)expectedValue;
                expected = expected.replaceAll("\\.", "\\\\.");
                expected = expected.replaceAll("\\*", "\\.\\*");
                Pattern pattern = Pattern.compile(expected);
                boolean retVal = pattern.matcher(fileName).find();
                return retVal;
            }
            if (PROJECT_NATURE.equals(method)) {
                try {
                    IProject proj = resource.getProject();
                    return proj.isAccessible() && proj.hasNature((String)expectedValue);
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            if (PROPERTY_MATCHES_CONTENT_TYPE.equals(method)) {
                return this.matchesContentType(resource, (String)expectedValue);
            }
        }
        return false;
    }

    private boolean matchesContentType(IResource resource, String contentType) {
        IContentDescription description;
        if (resource == null || !(resource instanceof IFile) || !resource.exists()) {
            return false;
        }
        IFile file = (IFile)resource;
        try {
            description = file.getContentDescription();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (description != null) {
            IContentType type = description.getContentType();
            return type != null && contentType.equals(type.getId());
        }
        return false;
    }
}

