/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.AbstractBreakpointsViewAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointGroupContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractBreakpointGroupAction
extends AbstractBreakpointsViewAction {
    private List fGroupContainers = new ArrayList();

    public void selectionChanged(IAction action, ISelection sel) {
        IStructuredSelection selection = (IStructuredSelection)sel;
        int selectionSize = selection.size();
        this.fGroupContainers.clear();
        if (selectionSize != 0) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof BreakpointGroupContainer) {
                    this.fGroupContainers.add(element);
                    continue;
                }
                this.fGroupContainers.clear();
                break;
            }
        }
        action.setEnabled(this.fGroupContainers.size() > 0);
    }

    public String[] getSelectedGroups() {
        ArrayList<String> groupNames = new ArrayList<String>();
        Iterator iter = this.fGroupContainers.iterator();
        while (iter.hasNext()) {
            BreakpointGroupContainer container = (BreakpointGroupContainer)iter.next();
            groupNames.add(container.getName());
        }
        return groupNames.toArray(new String[0]);
    }

    public IBreakpoint[] getBreakpoints(String group) {
        HashSet<IBreakpoint> breakpoints = new HashSet<IBreakpoint>();
        Iterator iter = this.fGroupContainers.iterator();
        while (iter.hasNext()) {
            BreakpointGroupContainer container = (BreakpointGroupContainer)iter.next();
            if (!container.getName().equals(group)) continue;
            IBreakpoint[] children = container.getBreakpoints();
            int i = 0;
            while (i < children.length) {
                breakpoints.add(children[i]);
                ++i;
            }
            break block0;
        }
        return breakpoints.toArray(new IBreakpoint[breakpoints.size()]);
    }
}

