/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

class SelectBreakpointGroupDialog
extends InputDialog {
    public SelectBreakpointGroupDialog(BreakpointsView view, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(view.getViewSite().getShell(), dialogTitle, dialogMessage, initialValue, validator);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Button button = SWTUtil.createPushButton(area, BreakpointGroupMessages.getString("SelectBreakpointGroupDialog.0"), null);
        GridData data = (GridData)button.getLayoutData();
        data.horizontalAlignment = 1;
        data.verticalAlignment = 1;
        final String[] groups = this.getGroups();
        if (groups.length > 0) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectBreakpointGroupDialog.this.handleBrowsePressed(groups);
                }
            });
        } else {
            button.setEnabled(false);
        }
        return area;
    }

    protected String[] getGroups() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        HashSet<String> groups = new HashSet<String>();
        int i = 0;
        while (i < breakpoints.length) {
            try {
                String group = breakpoints[i].getGroup();
                if (group != null) {
                    groups.add(group);
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++i;
        }
        return groups.toArray(new String[groups.size()]);
    }

    private void handleBrowsePressed(Object[] groups) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return DebugPluginImages.getImage("IMG_OBJS_BREAKPOINT_GROUP");
            }

            public String getText(Object element) {
                return (String)element;
            }
        });
        dialog.setElements(groups);
        dialog.setMultipleSelection(false);
        dialog.setMessage(BreakpointGroupMessages.getString("SelectBreakpointGroupDialog.1"));
        dialog.setTitle(BreakpointGroupMessages.getString("SelectBreakpointGroupDialog.2"));
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        this.getText().setText((String)result[0]);
    }
}

