/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.UIJob;

public class RemoteTreeViewer
extends TreeViewer {
    private ExpansionJob fExpansionJob = null;
    private SelectionJob fSelectionJob = null;
    static /* synthetic */ Class class$0;

    public RemoteTreeViewer(Composite parent) {
        super(parent);
    }

    protected void runDeferredUpdates() {
        if (this.fExpansionJob != null) {
            this.fExpansionJob.schedule();
        }
        if (this.fSelectionJob != null) {
            this.fSelectionJob.schedule();
        }
    }

    protected void validateDeferredUpdates(Object element) {
        if (element != null) {
            if (this.fExpansionJob != null) {
                this.fExpansionJob.validate(element);
            }
            if (this.fSelectionJob != null) {
                this.fSelectionJob.validate(element);
            }
        }
    }

    public RemoteTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public RemoteTreeViewer(Tree tree) {
        super(tree);
    }

    public synchronized void add(Object parentElement, Object childElement) {
        super.add(parentElement, childElement);
        this.runDeferredUpdates();
    }

    public synchronized void add(Object parentElement, Object[] childElements) {
        super.add(parentElement, childElements);
        this.runDeferredUpdates();
    }

    public synchronized void remove(Object element) {
        this.validateDeferredUpdates(element);
        super.remove(element);
    }

    public synchronized void remove(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.validateDeferredUpdates(elements[i]);
            ++i;
        }
        super.remove(elements);
    }

    public void cancelJobs() {
        this.cancel((Job)this.fSelectionJob);
        this.cancel((Job)this.fExpansionJob);
    }

    public synchronized void deferExpansion(Object element) {
        TreeItem treeItem = (TreeItem)this.findItem(element);
        if (treeItem == null) {
            if (this.fExpansionJob != null) {
                this.fExpansionJob.cancel();
            }
            this.fExpansionJob = new ExpansionJob(element, (Object)this);
            this.fExpansionJob.schedule();
        } else if (!this.getExpanded((Item)treeItem)) {
            this.expandToLevel(element, 1);
        }
    }

    public synchronized void setDeferredSelection(Object element) {
        if (this.findItem(element) == null) {
            if (this.fSelectionJob != null) {
                this.fSelectionJob.cancel();
            }
            this.fSelectionJob = new SelectionJob(element, (Object)this);
            this.fSelectionJob.schedule();
        } else {
            this.setSelection((ISelection)new StructuredSelection(element), true);
        }
    }

    private void cancel(Job job) {
        if (job != null) {
            job.cancel();
        }
    }

    private void addAllParents(List list, Object element) {
        if (element instanceof IAdaptable) {
            Object parent;
            IWorkbenchAdapter adapter;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)adaptable.getAdapter((Class)clazz)) != null && (parent = adapter.getParent(element)) != null) {
                list.add(0, parent);
                if (!(parent instanceof ILaunch)) {
                    this.addAllParents(list, parent);
                }
            }
        }
    }

    public Object[] filter(Object[] elements) {
        return super.filter(elements);
    }

    public Object[] getCurrentChildren(Object parent) {
        Widget widget = this.findItem(parent);
        if (widget != null) {
            Item[] items = this.getChildren(widget);
            Object[] children = new Object[items.length];
            int i = 0;
            while (i < children.length) {
                Object data = items[i].getData();
                if (data == null) {
                    data = new Object();
                }
                children[i] = data;
                ++i;
            }
            return children;
        }
        return null;
    }

    public synchronized void prune(final Object parent, final int offset) {
        this.preservingSelection(new Runnable(){

            public void run() {
                Widget widget = RemoteTreeViewer.this.findItem(parent);
                if (widget != null) {
                    Item[] currentChildren = RemoteTreeViewer.this.getChildren(widget);
                    int i = offset;
                    while (i < currentChildren.length) {
                        RemoteTreeViewer.this.disassociate(currentChildren[i]);
                        currentChildren[i].dispose();
                        ++i;
                    }
                }
            }
        });
    }

    public synchronized void replace(final Object parent, final Object[] children, final int offset) {
        this.preservingSelection(new Runnable(){

            public void run() {
                Widget widget = RemoteTreeViewer.this.findItem(parent);
                if (widget == null) {
                    RemoteTreeViewer.this.add(parent, children);
                    return;
                }
                int pos = offset;
                Item[] currentChildren = RemoteTreeViewer.this.getChildren(widget);
                if (pos >= currentChildren.length) {
                    RemoteTreeViewer.this.add(parent, children);
                } else {
                    int i = 0;
                    while (i < children.length) {
                        Object child = children[i];
                        if (pos < currentChildren.length) {
                            Item item = currentChildren[pos];
                            Object data = item.getData();
                            if (!child.equals(data)) {
                                RemoteTreeViewer.this.validateDeferredUpdates(data);
                                RemoteTreeViewer.this.associate(child, item);
                                RemoteTreeViewer.this.internalRefresh((Widget)item, child, true, true);
                            } else {
                                RemoteTreeViewer.this.internalRefresh((Widget)item, child, false, true);
                            }
                        } else {
                            int numLeft = children.length - i;
                            if (numLeft > 1) {
                                Object[] others = new Object[numLeft];
                                System.arraycopy(children, i, others, 0, numLeft);
                                RemoteTreeViewer.this.add(parent, others);
                            } else {
                                RemoteTreeViewer.this.add(parent, child);
                            }
                            return;
                        }
                        ++pos;
                        ++i;
                    }
                }
                RemoteTreeViewer.this.runDeferredUpdates();
            }
        });
    }

    class ExpansionJob
    extends UIJob {
        private Object element;
        private List parents;
        private Object lock;

        public ExpansionJob(Object target, Object lock) {
            super(DebugUIViewsMessages.getString("LaunchViewer.1"));
            this.element = target;
            this.parents = new ArrayList();
            this.lock = lock;
            RemoteTreeViewer.this.addAllParents(this.parents, this.element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (RemoteTreeViewer.this.getControl().isDisposed()) {
                return Status.OK_STATUS;
            }
            Object object = this.lock;
            synchronized (object) {
                TreeItem item;
                boolean allParentsExpanded = true;
                Iterator iterator = this.parents.iterator();
                while (iterator.hasNext() && !monitor.isCanceled()) {
                    Object parent = iterator.next();
                    TreeItem item2 = (TreeItem)RemoteTreeViewer.this.findItem(parent);
                    if (item2 != null) {
                        RemoteTreeViewer.this.expandToLevel(parent, 1);
                        continue;
                    }
                    allParentsExpanded = false;
                    break;
                }
                if (allParentsExpanded && (item = (TreeItem)RemoteTreeViewer.this.findItem(this.element)) != null) {
                    if (RemoteTreeViewer.this.isExpandable(this.element)) {
                        RemoteTreeViewer.this.expandToLevel(this.element, 1);
                    }
                    RemoteTreeViewer.this.fExpansionJob = null;
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
        }

        public void validate(Object object) {
            if (this.element.equals(object) || this.parents.contains(object)) {
                this.cancel();
                RemoteTreeViewer.this.fExpansionJob = null;
            }
        }
    }

    class SelectionJob
    extends UIJob {
        private Object element;
        private List parents;
        private Object lock;

        public SelectionJob(Object target, Object lock) {
            super(DebugUIViewsMessages.getString("LaunchViewer.0"));
            this.element = target;
            this.parents = new ArrayList();
            this.lock = lock;
            RemoteTreeViewer.this.addAllParents(this.parents, this.element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (RemoteTreeViewer.this.getControl().isDisposed()) {
                return Status.OK_STATUS;
            }
            Object object = this.lock;
            synchronized (object) {
                boolean allParentsExpanded = true;
                Iterator iterator = this.parents.iterator();
                while (iterator.hasNext() && !monitor.isCanceled()) {
                    Object parent = iterator.next();
                    TreeItem item = (TreeItem)RemoteTreeViewer.this.findItem(parent);
                    if (item != null) {
                        RemoteTreeViewer.this.expandToLevel(parent, 1);
                        continue;
                    }
                    allParentsExpanded = false;
                    break;
                }
                if (allParentsExpanded && RemoteTreeViewer.this.findItem(this.element) != null) {
                    RemoteTreeViewer.this.setSelection((ISelection)new StructuredSelection(this.element), true);
                    RemoteTreeViewer.this.fSelectionJob = null;
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
        }

        public void validate(Object object) {
            if (this.element.equals(object) || this.parents.contains(object)) {
                this.cancel();
                RemoteTreeViewer.this.fSelectionJob = null;
            }
        }
    }
}

