/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BreakpointsViewContentProvider
implements ITreeContentProvider {
    private List fBreakpointContainerFactories = new ArrayList();
    private Object[] topLevelElements = new Object[0];
    private HashMap fBreakpointParents = new HashMap();

    public void recomputeContent() {
        this.fBreakpointParents.clear();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        if (!this.fBreakpointContainerFactories.isEmpty()) {
            IBreakpointContainerFactory factory = (IBreakpointContainerFactory)this.fBreakpointContainerFactories.get(0);
            IBreakpointContainer[] containers = factory.getContainers(null);
            this.computeChildContent(containers);
            this.topLevelElements = containers;
        } else {
            this.topLevelElements = breakpoints;
        }
    }

    private void computeChildContent(IBreakpointContainer[] containers) {
        int i = 0;
        while (i < containers.length) {
            IBreakpointContainer container = containers[i];
            IBreakpoint[] breakpoints = container.getBreakpoints();
            IBreakpointContainerFactory parentFactory = container.getCreatingFactory();
            int index = this.fBreakpointContainerFactories.indexOf(parentFactory);
            if (index == this.fBreakpointContainerFactories.size() - 1) {
                int j = 0;
                while (j < breakpoints.length) {
                    this.fBreakpointParents.put(breakpoints[j], container);
                    ++j;
                }
            } else if (index >= 0) {
                IBreakpointContainerFactory nextFactory = (IBreakpointContainerFactory)this.fBreakpointContainerFactories.get(index + 1);
                this.computeChildContent(nextFactory.getContainers(container));
            }
            ++i;
        }
    }

    public Object[] getElements(Object parent) {
        return this.topLevelElements;
    }

    public void setBreakpointContainerFactories(List factories) {
        Iterator iter = this.fBreakpointContainerFactories.iterator();
        while (iter.hasNext()) {
            ((IBreakpointContainerFactory)iter.next()).dispose();
        }
        this.fBreakpointContainerFactories = factories;
    }

    public List getBreakpointContainerFactories() {
        return this.fBreakpointContainerFactories;
    }

    public void dispose() {
        this.fBreakpointParents.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IBreakpointManager) {
            return this.topLevelElements;
        }
        if (parentElement instanceof IBreakpointContainer) {
            IBreakpointContainer container = (IBreakpointContainer)parentElement;
            Object[] containers = container.getContainers();
            if (containers.length > 0) {
                return containers;
            }
            return container.getBreakpoints();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IBreakpointContainer) {
            IBreakpointContainer parent = ((IBreakpointContainer)element).getParentContainer();
            if (parent != null) {
                return parent;
            }
            return DebugPlugin.getDefault().getBreakpointManager();
        }
        return this.fBreakpointParents.get(element);
    }

    public boolean hasChildren(Object element) {
        return element instanceof IBreakpointContainer;
    }
}

