/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class BreakpointsViewEventHandler
implements IBreakpointsListener,
IActivityManagerListener {
    private BreakpointsView fView;

    public BreakpointsViewEventHandler(BreakpointsView view) {
        this.fView = view;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport != null) {
            activitySupport.getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport != null) {
            activitySupport.getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
        }
    }

    public void breakpointsAdded(final IBreakpoint[] breakpoints) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTreeViewer viewer = BreakpointsViewEventHandler.this.fView.getCheckboxViewer();
                        viewer.refresh();
                        viewer.setSelection((ISelection)new StructuredSelection((Object[])breakpoints));
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTreeViewer viewer = (CheckboxTreeViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        viewer.refresh();
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsChanged(final IBreakpoint[] breakpoints, final IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() & this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTreeViewer viewer = (CheckboxTreeViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        List groupChanged = BreakpointsViewEventHandler.this.getGroupChangeBreakpoints(breakpoints, deltas);
                        if (groupChanged.size() > 0) {
                            BreakpointsViewEventHandler.this.fView.getViewer().refresh();
                            BreakpointsViewEventHandler.this.fView.updateObjects();
                            viewer.setSelection(viewer.getSelection());
                            return;
                        }
                        int i = 0;
                        while (i < breakpoints.length) {
                            IBreakpoint breakpoint = breakpoints[i];
                            IMarker marker = breakpoint.getMarker();
                            if (marker != null && marker.exists()) {
                                try {
                                    boolean enabled = breakpoint.isEnabled();
                                    if (viewer.getChecked((Object)breakpoint) != enabled) {
                                        viewer.setChecked((Object)breakpoint, breakpoint.isEnabled());
                                        BreakpointsViewEventHandler.this.fView.updateParents(breakpoint, enabled);
                                    }
                                    viewer.update((Object)breakpoint, null);
                                }
                                catch (CoreException e) {
                                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIViewsMessages.getString("BreakpointsViewEventHandler.1"), DebugUIViewsMessages.getString("BreakpointsViewEventHandler.2"), e);
                                    DebugUIPlugin.log(e);
                                }
                            }
                            ++i;
                        }
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    private List getGroupChangeBreakpoints(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        ArrayList<IBreakpoint> groupChanged = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < breakpoints.length) {
            IMarkerDelta delta;
            IBreakpoint breakpoint = breakpoints[i];
            IMarker marker = breakpoint.getMarker();
            if (marker != null && marker.exists() && (delta = deltas[i]) != null) {
                String oldGroup = (String)delta.getAttribute("org.eclipse.debug.core.group");
                String newGroup = null;
                try {
                    newGroup = breakpoint.getGroup();
                }
                catch (CoreException coreException) {}
                if (!(newGroup == oldGroup || newGroup != null && oldGroup != null && newGroup.equals(oldGroup))) {
                    groupChanged.add(breakpoint);
                }
            }
            ++i;
        }
        return groupChanged;
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (this.fView.isAvailable() & this.fView.isVisible() && activityManagerEvent.haveEnabledActivityIdsChanged()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    BreakpointsViewEventHandler.this.fView.getViewer().refresh();
                }
            });
        }
    }
}

