/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingType;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IRenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryRenderingManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;

public class CreateRenderingTab
implements IMemoryViewTab,
IDebugEventSetListener {
    private IMemoryBlock fMemoryBlock;
    private TabItem fTabItem;
    private ListViewer fViewer;
    private Label fMemoryBlockLabel;
    private CreateRendering fRendering = new CreateRendering();
    private DisposeListener fDisposeListener;
    private IRenderingViewPane fViewPane;
    static /* synthetic */ Class class$0;

    public CreateRenderingTab(IMemoryBlock memBlock, TabItem tabItem, IRenderingViewPane viewPane) {
        this.fMemoryBlock = memBlock;
        this.fTabItem = tabItem;
        this.fViewPane = viewPane;
        Control control = this.createPartControl((Composite)tabItem.getParent());
        this.fTabItem.setControl(control);
        this.fTabItem.setData((Object)this);
        this.fTabItem.setText(this.getLabel());
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CreateRenderingTab.this.fTabItem.removeDisposeListener(CreateRenderingTab.this.fDisposeListener);
                CreateRenderingTab.this.dispose();
            }
        };
        this.fTabItem.addDisposeListener(this.fDisposeListener);
    }

    private Control createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 2;
        compositeLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)compositeLayout);
        GridData comositeSpec = new GridData();
        comositeSpec.grabExcessVerticalSpace = true;
        comositeSpec.grabExcessHorizontalSpace = true;
        comositeSpec.horizontalAlignment = 4;
        comositeSpec.verticalAlignment = 2;
        composite.setLayoutData((Object)comositeSpec);
        this.fMemoryBlockLabel = new Label(composite, 2048);
        String memoryBlockLabel = " ";
        memoryBlockLabel = this.getLabel();
        this.fMemoryBlockLabel.setText("  " + DebugUIMessages.getString("CreateRenderingTab.Memory_monitor") + memoryBlockLabel + "  ");
        GridData textLayout = new GridData();
        textLayout.verticalAlignment = 2;
        textLayout.horizontalAlignment = 1;
        this.fMemoryBlockLabel.setLayoutData((Object)textLayout);
        Label renderingLabel = new Label(composite, 0);
        renderingLabel.setText(DebugUIMessages.getString("CreateRenderingTab.Select_renderings_to_create"));
        GridData renderingLayout = new GridData();
        renderingLayout.horizontalAlignment = 1;
        renderingLayout.verticalAlignment = 2;
        renderingLayout.horizontalSpan = 2;
        renderingLabel.setLayoutData((Object)renderingLayout);
        this.fViewer = new ListViewer(composite);
        this.fViewer.setContentProvider((IContentProvider)new MemoryRenderingContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MemoryRenderingLabelProvider());
        this.fViewer.setInput((Object)this.fMemoryBlock);
        if (this.fViewer.getElementAt(0) != null) {
            this.fViewer.getList().select(0);
        }
        GridData listLayout = new GridData(1808);
        listLayout.horizontalSpan = 1;
        this.fViewer.getControl().setLayoutData((Object)listLayout);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CreateRenderingTab.this.addRenderings();
            }
        });
        Button addButton = new Button(composite, 0);
        addButton.setText(DebugUIMessages.getString("CreateRenderingTab.Add_renderings"));
        GridData buttonLayout = new GridData();
        buttonLayout.horizontalAlignment = 1;
        buttonLayout.verticalAlignment = 1;
        addButton.setLayoutData((Object)buttonLayout);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateRenderingTab.this.addRenderings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CreateRenderingTab.this.addRenderings();
            }
        });
        addButton.setFocus();
        return composite;
    }

    private String getLabel() {
        String memoryBlockLabel = " ";
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            try {
                if (((IMemoryBlockExtension)this.fMemoryBlock).getExpression() != null) {
                    String prefix = "";
                    if (((IMemoryBlockExtension)this.fMemoryBlock).getExpression().startsWith("&")) {
                        prefix = "&";
                        memoryBlockLabel = String.valueOf(memoryBlockLabel) + prefix;
                    }
                    memoryBlockLabel = String.valueOf(memoryBlockLabel) + ((IMemoryBlockExtension)this.fMemoryBlock).getExpression();
                }
                if (((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() != null) {
                    memoryBlockLabel = String.valueOf(memoryBlockLabel) + " <0x" + ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress().toString(16) + ">";
                }
            }
            catch (DebugException debugException) {
                memoryBlockLabel = this.fMemoryBlock.toString();
            }
        } else {
            long address = this.fMemoryBlock.getStartAddress();
            memoryBlockLabel = Long.toHexString(address);
        }
        return memoryBlockLabel;
    }

    private void addRenderings() {
        IMemoryBlockRetrieval standardMemRetrieval;
        ISelection selection = this.fViewer.getSelection();
        Object[] renderings = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            renderings = strucSelection.toArray();
        }
        if (renderings == null) {
            Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5013, DebugUIMessages.getString("CreateRenderingTab.0"), null);
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.getString("CreateRenderingTab.1"), DebugUIMessages.getString("CreateRenderingTab.2"), (IStatus)stat);
            return;
        }
        IDebugTarget debugTarget = this.fMemoryBlock.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((standardMemRetrieval = (IMemoryBlockRetrieval)this.fMemoryBlock.getAdapter((Class)clazz)) == null) {
            standardMemRetrieval = debugTarget;
        }
        if (standardMemRetrieval == null) {
            return;
        }
        int i = 0;
        while (i < renderings.length) {
            if (renderings[i] instanceof IMemoryRenderingType) {
                String id = ((IMemoryRenderingType)renderings[i]).getRenderingId();
                try {
                    IMemoryRendering rendering = MemoryRenderingManager.getMemoryRenderingManager().createRendering(this.fMemoryBlock, id);
                    if (rendering != null) {
                        this.fViewPane.addMemoryRendering(rendering);
                    }
                }
                catch (DebugException e) {
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.getString("CreateRenderingTab.3"), DebugUIMessages.getString("CreateRenderingTab.4"), e);
                }
            }
            ++i;
        }
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fTabItem.dispose();
    }

    public void goToAddress(BigInteger address) throws DebugException {
    }

    public void resetAtBaseAddress() throws DebugException {
    }

    public void refresh() {
        this.updateMemoryBlockLabels();
        this.fViewer.refresh();
    }

    public boolean isDisplayingError() {
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.refresh();
        }
    }

    public void setFont(Font font) {
    }

    public void setTabLabel(String label) {
    }

    public String getTabLabel() {
        return DebugUIMessages.getString("CreateRenderingTab.Create_memory_rendering");
    }

    public String getRenderingId() {
        return this.fRendering.getRenderingId();
    }

    public IMemoryRendering getRendering() {
        return this.fRendering;
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    public BigInteger getSelectedAddress() {
        return null;
    }

    public String getSelectedContent() {
        return null;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (!(event.getSource() instanceof IDebugElement)) {
                return;
            }
            IDebugElement src = (IDebugElement)event.getSource();
            if (event.getKind() == 16 && event.getSource() == this.fMemoryBlock) {
                this.updateMemoryBlockLabels();
            }
            if (event.getKind() == 2 && src.getDebugTarget() == this.fMemoryBlock.getDebugTarget()) {
                this.updateMemoryBlockLabels();
            }
            ++i;
        }
    }

    private void updateMemoryBlockLabels() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!CreateRenderingTab.this.fMemoryBlock.getDebugTarget().isDisconnected() && !CreateRenderingTab.this.fMemoryBlock.getDebugTarget().isTerminated()) {
                    CreateRenderingTab.this.fTabItem.setText(CreateRenderingTab.this.getLabel());
                    CreateRenderingTab.this.fMemoryBlockLabel.setText("  " + DebugUIMessages.getString("CreateRenderingTab.Memory_monitor") + CreateRenderingTab.this.getLabel() + "  ");
                    CreateRenderingTab.this.fMemoryBlockLabel.getParent().layout();
                }
            }
        });
    }

    class MemoryRenderingLabelProvider
    implements ILabelProvider {
        MemoryRenderingLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IMemoryRenderingType) {
                String label = ((IMemoryRenderingType)element).getName();
                return label;
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class MemoryRenderingContentProvider
    implements IStructuredContentProvider {
        MemoryRenderingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] renderings = MemoryRenderingManager.getMemoryRenderingManager().getRenderingTypes(inputElement, IInternalDebugUIConstants.ID_RENDERING_VIEW_PANE);
            return renderings;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class CreateRendering
    implements IMemoryRendering {
        CreateRendering() {
        }

        public IMemoryBlock getBlock() {
            return CreateRenderingTab.this.fMemoryBlock;
        }

        public String getRenderingId() {
            return String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".createrendering";
        }
    }
}

