/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.views.memory.ASCIIRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingFactory;
import org.eclipse.debug.internal.ui.views.memory.SignedIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.UnsignedIntegerRendering;

public class DefaultRenderingsFactory
implements IMemoryRenderingFactory {
    public static final String RENDERING_ID_SIGNED_INT = "org.eclipse.debug.ui.rendering.signedint";
    public static final String RENDERING_ID_UNSIGNED_INT = "org.eclipse.debug.ui.rendering.unsignedint";
    public static final String RENDERING_ID_ASCII = "org.eclipse.debug.ui.rendering.ascii";

    public IMemoryRendering createRendering(IMemoryBlock memoryBlock, String renderingId) {
        if (renderingId.equals(RENDERING_ID_SIGNED_INT)) {
            return new SignedIntegerRendering(memoryBlock, renderingId);
        }
        if (renderingId.equals(RENDERING_ID_UNSIGNED_INT)) {
            return new UnsignedIntegerRendering(memoryBlock, renderingId);
        }
        if (renderingId.equals(RENDERING_ID_ASCII)) {
            return new ASCIIRendering(memoryBlock, renderingId);
        }
        return null;
    }
}

