/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.MemoryRenderingManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabItem;

public class EmptyViewTab
extends AbstractMemoryViewTab {
    TextViewer fTextViewer;

    public EmptyViewTab(IMemoryBlock newMemory, TabItem newTab, MenuManager menuMgr, IMemoryRendering rendering) {
        super(newMemory, newTab, menuMgr, rendering);
        this.maintainRefAndEnablement(false);
        this.fTabItem = newTab;
        this.fTextViewer = new TextViewer((Composite)newTab.getParent(), 8);
        this.fTabItem.setControl(this.fTextViewer.getControl());
        this.fTextViewer.setDocument((IDocument)new Document());
        StyledText styleText = this.fTextViewer.getTextWidget();
        styleText.setText("\r\n\r\n" + DebugUIMessages.getString("EmptyViewTab.Unable_to_create") + "\n" + this.getRenderingName() + "\n");
        this.setTabName(newMemory);
    }

    private String getRenderingName() {
        String name = MemoryRenderingManager.getMemoryRenderingManager().getRenderingTypeById(this.getRenderingId()).getName();
        return name;
    }

    protected void setTabName(IMemoryBlock newMemory) {
        String name;
        String tabName = null;
        tabName = "";
        try {
            if (newMemory instanceof IMemoryBlockExtension) {
                tabName = ((IMemoryBlockExtension)newMemory).getExpression();
                if (tabName == null) {
                    tabName = DebugUIMessages.getString("EmptyViewTab.Unknown");
                }
            } else {
                long address = newMemory.getStartAddress();
                tabName = Long.toHexString(address);
            }
        }
        catch (DebugException debugException) {
            tabName = DebugUIMessages.getString("EmptyViewTab.Unknown");
        }
        if ((name = this.getRenderingName()) != null) {
            tabName = String.valueOf(tabName) + " <" + name + ">";
        }
        this.fTabItem.setText(tabName);
    }

    public void goToAddress(BigInteger address) throws DebugException {
    }

    public void resetAtBaseAddress() throws DebugException {
    }

    public void refresh() {
    }

    public boolean isDisplayingError() {
        return true;
    }

    public boolean isEnabled() {
        return false;
    }

    public void setFont(Font font) {
    }

    public void setTabLabel(String label) {
    }

    public String getTabLabel() {
        return null;
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    public BigInteger getSelectedAddress() {
        return null;
    }

    public String getSelectedContent() {
        return null;
    }

    public void setEnabled(boolean enabled) {
    }
}

