/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IMultipaneMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IntegerRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class LittleEndianAction
implements IObjectActionDelegate {
    IWorkbenchPart fTargetPart;
    IMemoryRendering fRendering;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        IntegerRendering intRendering;
        if (this.fRendering instanceof IntegerRendering && (intRendering = (IntegerRendering)this.fRendering).getCurrentEndianess() != 0) {
            intRendering.setCurrentEndianess(0);
            if (this.fTargetPart instanceof IMemoryView) {
                IMemoryViewTab top = ((IMemoryView)this.fTargetPart).getTopMemoryTab();
                top.refresh();
            } else if (this.fTargetPart instanceof IMultipaneMemoryView) {
                IMemoryViewPane[] viewPanes = ((IMultipaneMemoryView)this.fTargetPart).getViewPanes();
                int i = 0;
                while (i < viewPanes.length) {
                    IMemoryView memoryView;
                    IMemoryViewTab top;
                    IMemoryViewPane viewPane = viewPanes[i];
                    if (viewPane != null && viewPane instanceof IMemoryView && (top = (memoryView = (IMemoryView)((Object)viewPane)).getTopMemoryTab()) != null && top.getRendering() == this.fRendering) {
                        top.refresh();
                    }
                    ++i;
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection strucSelection;
        if (selection instanceof IStructuredSelection && (strucSelection = (IStructuredSelection)selection).getFirstElement() instanceof IMemoryRendering) {
            this.fRendering = (IMemoryRendering)strucSelection.getFirstElement();
            if (this.fRendering.getBlock() instanceof IMemoryBlockExtension) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
            if (this.fRendering instanceof IntegerRendering) {
                int endianess = ((IntegerRendering)this.fRendering).getCurrentEndianess();
                if (endianess == 0) {
                    action.setChecked(true);
                } else {
                    action.setChecked(false);
                }
            }
        }
    }
}

