/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class VariablesViewer
extends TreeViewer {
    private Item fNewItem;

    public VariablesViewer(Composite parent) {
        super(parent);
    }

    public VariablesViewer(Composite parent, int style) {
        super(parent, style);
    }

    public VariablesViewer(Tree tree) {
        super(tree);
    }

    public void refresh() {
        super.refresh();
        ISelection selection = this.getSelection();
        if (selection.isEmpty()) {
            if (this.getNewItem() != null) {
                if (!this.getNewItem().isDisposed()) {
                    this.showItem(this.getNewItem());
                }
                this.setNewItem(null);
            }
        } else {
            this.setSelection(selection);
        }
    }

    protected Item newItem(Widget parent, int style, int index) {
        if (index != -1) {
            this.setNewItem(super.newItem(parent, style, index));
            return this.getNewItem();
        }
        return super.newItem(parent, style, index);
    }

    protected Item getNewItem() {
        return this.fNewItem;
    }

    protected void setNewItem(Item newItem) {
        this.fNewItem = newItem;
    }

    public void setExpandedElements(Object[] elements) {
        this.getControl().setRedraw(false);
        super.setExpandedElements(elements);
        this.getControl().setRedraw(true);
    }

    public void collapseAll() {
        if (this.getRoot() != null) {
            super.collapseAll();
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        ILabelProvider provider = (ILabelProvider)this.getLabelProvider();
        String text = provider.getText(element);
        if ("".equals(item.getText()) || !"...".equals(text)) {
            item.setText(text);
        }
        Image image = provider.getImage(element);
        if (item.getImage() != image) {
            item.setImage(image);
        }
        if (provider instanceof IColorProvider) {
            IColorProvider cp = (IColorProvider)provider;
            TreeItem treeItem = (TreeItem)item;
            treeItem.setForeground(cp.getForeground(element));
            treeItem.setBackground(cp.getBackground(element));
        }
    }
}

