/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.UpdatePolicy;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.BookmarkFolder;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.search.IUpdateSiteAdapter;

public class DiscoveryFolder
extends BookmarkFolder {
    private static final long serialVersionUID = 1L;
    UpdatePolicy updatePolicy = new UpdatePolicy();

    public DiscoveryFolder() {
        super(UpdateUI.getString("DiscoveryFolder.name"));
        this.setModel(UpdateUI.getDefault().getUpdateModel());
    }

    public void initialize() {
        this.children.clear();
        if (!UpdateUI.getDefault().getPluginPreferences().getBoolean("discoverySitesEnabled")) {
            return;
        }
        try {
            URL updateMapURL = UpdateUtils.getUpdateMapURL();
            if (updateMapURL != null) {
                this.updatePolicy = new UpdatePolicy();
                IStatus status = UpdateUtils.loadUpdatePolicy((UpdatePolicy)this.updatePolicy, (URL)updateMapURL, (IProgressMonitor)new NullProgressMonitor());
                if (status != null) {
                    UpdateUtils.log((IStatus)status);
                }
            }
        }
        catch (CoreException e) {
            UpdateUtils.log((IStatus)e.getStatus());
        }
        try {
            ILocalSite site = SiteManager.getLocalSite();
            IInstallConfiguration config = site.getCurrentConfiguration();
            IConfiguredSite[] csites = config.getConfiguredSites();
            int i = 0;
            while (i < csites.length) {
                IConfiguredSite csite = csites[i];
                IFeatureReference[] refs = csite.getConfiguredFeatures();
                int j = 0;
                while (j < refs.length) {
                    IFeatureReference ref = refs[j];
                    IFeature feature = ref.getFeature(null);
                    IURLEntry[] entries = feature.getDiscoverySiteEntries();
                    if (entries.length > 0 && !this.isIncluded(ref, refs)) {
                        this.addBookmarks(feature);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
    }

    private boolean isIncluded(IFeatureReference ref, IFeatureReference[] refs) {
        try {
            VersionedIdentifier vid = ref.getVersionedIdentifier();
            int i = 0;
            while (i < refs.length) {
                IFeatureReference candidate = refs[i];
                if (!candidate.equals(ref)) {
                    IFeature cfeature = candidate.getFeature(null);
                    IIncludedFeatureReference[] irefs = cfeature.getIncludedFeatureReferences();
                    int j = 0;
                    while (j < irefs.length) {
                        IIncludedFeatureReference iref = irefs[j];
                        VersionedIdentifier ivid = iref.getVersionedIdentifier();
                        if (ivid.equals((Object)vid)) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private void addBookmarks(IFeature feature) {
        if (this.updatePolicy != null && this.updatePolicy.isLoaded()) {
            IUpdateSiteAdapter mappedSite = this.updatePolicy.getMappedDiscoverySite(feature.getVersionedIdentifier().getIdentifier());
            if (mappedSite != null) {
                SiteBookmark bookmark = new SiteBookmark(mappedSite.getLabel(), mappedSite.getURL(), false);
                bookmark.setReadOnly(true);
                if (!this.contains(bookmark)) {
                    this.internalAdd(bookmark);
                }
                return;
            }
            if (!this.updatePolicy.isFallbackAllowed()) {
                return;
            }
        }
        IURLEntry[] entries = feature.getDiscoverySiteEntries();
        int i = 0;
        while (i < entries.length) {
            IURLEntry entry = entries[i];
            SiteBookmark bookmark = new SiteBookmark(entry.getAnnotation(), entry.getURL(), entry.getType() == 1);
            bookmark.setReadOnly(entry.getType() != 1);
            if (!this.contains(bookmark)) {
                this.internalAdd(bookmark);
            }
            ++i;
        }
    }

    private boolean contains(SiteBookmark bookmark) {
        int i = 0;
        while (i < this.children.size()) {
            Object o = this.children.get(i);
            if (o instanceof SiteBookmark && bookmark.getURL().equals(((SiteBookmark)o).getURL())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getChildren(Object parent) {
        if (!this.hasChildren()) {
            this.initialize();
        }
        return super.getChildren(parent);
    }
}

