/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.security;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.security.JarVerificationDialog;
import org.eclipse.update.internal.ui.security.JarVerificationPage;

public class JarVerificationService
implements IVerificationListener {
    private Shell shell;
    private int lastVerifyCode = -1;
    private Map processed = new HashMap();

    public JarVerificationService() {
        this(null);
    }

    public JarVerificationService(Shell aShell) {
        this.shell = aShell;
        if (this.shell == null) {
            final Display disp = Display.getDefault();
            if (disp == null) {
                this.shell = new Shell(new Display());
            } else {
                disp.syncExec(new Runnable(){

                    public void run() {
                        JarVerificationService.this.shell = disp.getActiveShell();
                    }
                });
            }
        }
    }

    private int openWizard(IVerificationResult result) {
        JarVerificationPage page = new JarVerificationPage(result);
        JarVerificationDialog dialog = new JarVerificationDialog(this.shell, (IDialogPage)page, result);
        dialog.create();
        dialog.getShell().setSize(600, 500);
        dialog.getShell().setText(UpdateUI.getString("JarVerificationDialog.wtitle"));
        dialog.open();
        int code = dialog.getReturnCode() == 0 ? 2 : (dialog.getReturnCode() == 2 ? 3 : 0);
        return code;
    }

    public int prompt(final IVerificationResult verificationResult) {
        if (!UpdateCore.getPlugin().getPluginPreferences().getBoolean("org.eclipse.update.core.checkSignature")) {
            return 3;
        }
        if (verificationResult.alreadySeen()) {
            return 3;
        }
        if (this.see(verificationResult)) {
            return 3;
        }
        if (this.lastVerifyCode == 3) {
            return 3;
        }
        switch (verificationResult.getVerificationCode()) {
            case 6: {
                return 1;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 3;
            }
        }
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                JarVerificationService.this.lastVerifyCode = JarVerificationService.this.openWizard(verificationResult);
            }
        });
        return this.lastVerifyCode;
    }

    private boolean see(IVerificationResult verificationResult) {
        Long cachedValue;
        String key = String.valueOf(verificationResult.getFeature().getVersionedIdentifier().toString()) + "/" + verificationResult.getContentReference().getIdentifier();
        Long value = new Long(verificationResult.getContentReference().getLastModified());
        if (value.equals(cachedValue = (Long)this.processed.get(key))) {
            return true;
        }
        this.processed.put(key, value);
        return false;
    }
}

