/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.FeatureDownloadException;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.security.JarVerificationService;
import org.eclipse.update.internal.ui.wizards.DuplicateConflictsDialog;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.LicensePage;
import org.eclipse.update.internal.ui.wizards.ModeSelectionPage;
import org.eclipse.update.internal.ui.wizards.OptionalFeaturesPage;
import org.eclipse.update.internal.ui.wizards.ReviewPage;
import org.eclipse.update.internal.ui.wizards.SearchRunner;
import org.eclipse.update.internal.ui.wizards.SitePage;
import org.eclipse.update.internal.ui.wizards.TargetPage;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;

public class InstallWizard
extends Wizard
implements IOperationListener,
ISearchProvider {
    private ModeSelectionPage modePage;
    private SitePage sitePage;
    private ReviewPage reviewPage;
    private LicensePage licensePage;
    private OptionalFeaturesPage optionalFeaturesPage;
    private TargetPage targetPage;
    private IInstallConfiguration config;
    private int installCount = 0;
    private SearchRunner searchRunner;
    private UpdateSearchRequest searchRequest;
    private ArrayList jobs;
    private boolean needsRestart;
    private static boolean isRunning;
    private IBatchOperation installOperation;
    private Job job;
    public static final Object jobFamily;
    private IJobChangeListener jobListener;

    static {
        jobFamily = new Object();
    }

    public InstallWizard() {
        this(null);
    }

    public InstallWizard(UpdateSearchRequest searchRequest) {
        isRunning = true;
        this.searchRequest = searchRequest;
        this.setDialogSettings(UpdateUI.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(UpdateUIImages.DESC_UPDATE_WIZ);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(UpdateUI.getString("InstallWizard.wtitle"));
    }

    public InstallWizard(UpdateSearchRequest searchRequest, ArrayList jobs) {
        this(searchRequest);
        this.jobs = jobs;
    }

    public int getInstallCount() {
        return this.installCount;
    }

    public boolean isRestartNeeded() {
        return this.installCount > 0 && this.needsRestart;
    }

    public boolean performCancel() {
        isRunning = false;
        if (this.targetPage != null) {
            this.targetPage.removeAddedSites();
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean proceed;
        DuplicateConflictsDialog dialog;
        IInstallFeatureOperation[] selectedJobs = this.reviewPage.getSelectedJobs();
        this.saveSettings();
        ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts((IInstallFeatureOperation[])selectedJobs, (IInstallConfiguration)this.config);
        if (conflicts != null && (dialog = new DuplicateConflictsDialog(this.getShell(), conflicts)).open() != 0) {
            return false;
        }
        if (Platform.getJobManager().find(jobFamily).length > 0 && !(proceed = MessageDialog.openQuestion((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("InstallWizard.anotherJobTitle"), (String)UpdateUI.getString("InstallWizard.anotherJob")))) {
            return false;
        }
        this.installOperation = this.getBatchInstallOperation(selectedJobs);
        if (this.installOperation != null) {
            this.launchInBackground();
        }
        return true;
    }

    public void addPages() {
        this.searchRunner = new SearchRunner(this.getShell(), (IRunnableContext)this.getContainer());
        if (this.searchRequest == null && this.jobs == null) {
            this.modePage = new ModeSelectionPage(this.searchRunner);
            this.addPage((IWizardPage)this.modePage);
            this.sitePage = new SitePage(this.searchRunner);
            this.addPage((IWizardPage)this.sitePage);
        } else {
            this.searchRunner.setSearchProvider(this);
            if (this.jobs != null) {
                this.searchRunner.setNewSearchNeeded(false);
            }
        }
        this.reviewPage = new ReviewPage(this.searchRunner, this.jobs);
        this.searchRunner.setResultCollector((IUpdateSearchResultCollector)this.reviewPage);
        this.addPage((IWizardPage)this.reviewPage);
        try {
            this.config = SiteManager.getLocalSite().getCurrentConfiguration();
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        this.licensePage = new LicensePage(true);
        this.addPage((IWizardPage)this.licensePage);
        this.optionalFeaturesPage = new OptionalFeaturesPage(this.config);
        this.addPage((IWizardPage)this.optionalFeaturesPage);
        this.targetPage = new TargetPage(this.config);
        this.addPage((IWizardPage)this.targetPage);
    }

    private void saveSettings() {
        if (this.modePage != null) {
            this.modePage.saveSettings();
        }
    }

    private boolean isPageRequired(IWizardPage page) {
        if (page == null) {
            return false;
        }
        if (page.equals(this.licensePage)) {
            return OperationsManager.hasSelectedJobsWithLicenses((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.optionalFeaturesPage)) {
            return OperationsManager.hasSelectedJobsWithOptionalFeatures((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.targetPage)) {
            return this.reviewPage.getSelectedJobs().length > 0;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        boolean start = false;
        IWizardPage nextPage = null;
        if (this.modePage != null && page.equals(this.modePage)) {
            boolean update = this.modePage.isUpdateMode();
            if (update) {
                return this.reviewPage;
            }
            return this.sitePage;
        }
        if (this.sitePage != null && page.equals(this.sitePage)) {
            return this.reviewPage;
        }
        if (page.equals((Object)this.reviewPage)) {
            this.updateDynamicPages();
        }
        int i = 0;
        while (i < pages.length) {
            if (pages[i].equals(page)) {
                start = true;
            } else if (start && this.isPageRequired(pages[i])) {
                nextPage = pages[i];
                break;
            }
            ++i;
        }
        return nextPage;
    }

    private void updateDynamicPages() {
        if (this.licensePage != null) {
            IInstallFeatureOperation[] licenseJobs = OperationsManager.getSelectedJobsWithLicenses((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
            this.licensePage.setJobs(licenseJobs);
        }
        if (this.optionalFeaturesPage != null) {
            IInstallFeatureOperation[] optionalJobs = OperationsManager.getSelectedJobsWithOptionalFeatures((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
            this.optionalFeaturesPage.setJobs(optionalJobs);
        }
        if (this.targetPage != null) {
            IInstallFeatureOperation[] installJobs = this.reviewPage.getSelectedJobs();
            this.targetPage.setJobs(installJobs);
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page.equals(this.targetPage) && page.isPageComplete();
    }

    private void preserveOriginatingURLs(IFeature feature, IFeatureReference[] optionalFeatures) {
        URL url = feature.getSite().getURL();
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IIncludedFeatureReference iref = irefs[i];
                boolean preserve = false;
                if (iref.isOptional()) {
                    boolean onTheList = false;
                    int j = 0;
                    while (j < optionalFeatures.length) {
                        if (optionalFeatures[j].equals(iref)) {
                            onTheList = true;
                            break;
                        }
                        ++j;
                    }
                    if (!onTheList) {
                        preserve = true;
                    }
                }
                if (preserve) {
                    try {
                        String id = iref.getVersionedIdentifier().getIdentifier();
                        UpdateUI.setOriginatingURL(id, url);
                    }
                    catch (CoreException coreException) {}
                } else {
                    try {
                        IFeature ifeature = iref.getFeature(null);
                        this.preserveOriginatingURLs(ifeature, optionalFeatures);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean afterExecute(IOperation operation, Object data) {
        if (!(operation instanceof IInstallFeatureOperation)) {
            return true;
        }
        IInstallFeatureOperation job = (IInstallFeatureOperation)operation;
        IFeature oldFeature = job.getOldFeature();
        if (oldFeature == null && job.getOptionalFeatures() != null) {
            this.preserveOriginatingURLs(job.getFeature(), job.getOptionalFeatures());
        }
        ++this.installCount;
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public static synchronized boolean isRunning() {
        return isRunning || Platform.getJobManager().find(jobFamily).length > 0;
    }

    private IBatchOperation getBatchInstallOperation(IInstallFeatureOperation[] selectedJobs) {
        JarVerificationService verificationListener = new JarVerificationService(UpdateUI.getActiveWorkbenchShell());
        IInstallFeatureOperation[] operations = new IInstallFeatureOperation[selectedJobs.length];
        int i = 0;
        while (i < selectedJobs.length) {
            IInstallFeatureOperation op;
            IInstallFeatureOperation job = selectedJobs[i];
            IFeature[] unconfiguredOptionalFeatures = null;
            IFeatureReference[] optionalFeatures = null;
            if (UpdateUtils.hasOptionalFeatures((IFeature)job.getFeature())) {
                optionalFeatures = this.optionalFeaturesPage.getCheckedOptionalFeatures(job);
                unconfiguredOptionalFeatures = this.optionalFeaturesPage.getUnconfiguredOptionalFeatures(job, job.getTargetSite());
            }
            operations[i] = op = OperationsManager.getOperationFactory().createInstallOperation(job.getTargetSite(), job.getFeature(), optionalFeatures, unconfiguredOptionalFeatures, (IVerificationListener)verificationListener);
            ++i;
        }
        return OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
    }

    private void launchInBackground() {
        if (this.jobListener != null) {
            Platform.getJobManager().removeJobChangeListener(this.jobListener);
        }
        if (this.job != null) {
            Platform.getJobManager().cancel((Object)this.job);
        }
        this.jobListener = new UpdateJobChangeListener();
        Platform.getJobManager().addJobChangeListener(this.jobListener);
        this.job = new Job(UpdateUI.getString("InstallWizard.jobName")){

            public IStatus run(IProgressMonitor monitor) {
                if (InstallWizard.this.download(monitor)) {
                    return Status.OK_STATUS;
                }
                isRunning = false;
                return Status.CANCEL_STATUS;
            }

            public boolean belongsTo(Object family) {
                return jobFamily == family;
            }
        };
        this.job.setUser(true);
        this.job.setPriority(10);
        this.job.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void install(IProgressMonitor monitor) {
        try {
            try {
                this.needsRestart = this.installOperation.execute(monitor, (IOperationListener)this);
                UpdateUI.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        UpdateUI.requestRestart(InstallWizard.this.isRestartNeeded());
                    }
                });
            }
            catch (InvocationTargetException e) {
                final Throwable targetException = e.getTargetException();
                if (!(targetException instanceof InstallAbortedException)) {
                    UpdateUI.getStandardDisplay().syncExec(new Runnable(){

                        public void run() {
                            UpdateUI.logException(targetException);
                        }
                    });
                }
            }
            catch (CoreException coreException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            isRunning = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            isRunning = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean download(IProgressMonitor monitor) {
        try {
            IFeatureOperation[] ops = this.installOperation.getOperations();
            monitor.beginTask(UpdateUI.getString("InstallWizard.download"), 3 * ops.length);
            int i = 0;
            while (true) {
                if (i >= ops.length) {
                    Object var8_9 = null;
                    break;
                }
                IInstallFeatureOperation op = (IInstallFeatureOperation)ops[i];
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 3);
                try {
                    UpdateUtils.downloadFeatureContent((IConfiguredSite)op.getTargetSite(), (IFeature)op.getFeature(), (IFeatureReference[])op.getOptionalFeatures(), (IProgressMonitor)subMonitor);
                }
                catch (CoreException e) {
                    if (e instanceof FeatureDownloadException) {
                        boolean retry = this.retryDownload((FeatureDownloadException)e);
                        if (retry) {
                            --i;
                        }
                    } else {
                        UpdateCore.log((Throwable)e);
                    }
                    Object var8_8 = null;
                    monitor.done();
                    return false;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return true;
    }

    private boolean retryDownload(final FeatureDownloadException e) {
        final boolean[] retry = new boolean[1];
        UpdateUI.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                retry[0] = MessageDialog.openQuestion((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("InstallWizard.retryTitle"), (String)(String.valueOf(e.getMessage()) + "\n" + UpdateUI.getString("InstallWizard.retry")));
            }
        });
        return retry[0];
    }

    static /* synthetic */ void access$1(InstallWizard installWizard, IProgressMonitor iProgressMonitor) {
        installWizard.install(iProgressMonitor);
    }

    private class UpdateJobChangeListener
    extends JobChangeAdapter {
        UpdateJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            if (event.getJob() == InstallWizard.this.job && event.getResult() == Status.OK_STATUS) {
                Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                Platform.getJobManager().cancel((Object)InstallWizard.this.job);
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                UpdateUI.getStandardDisplay().asyncExec(new Runnable(this, progressService){
                    final /* synthetic */ UpdateJobChangeListener this$1;
                    private final /* synthetic */ IProgressService val$progressService;
                    {
                        this.this$1 = updateJobChangeListener;
                        this.val$progressService = iProgressService;
                    }

                    public void run() {
                        try {
                            this.val$progressService.busyCursorWhile(new IRunnableWithProgress(this){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run(IProgressMonitor monitor) {
                                    InstallWizard.access$1(UpdateJobChangeListener.access$0(1.access$0(this.this$2)), monitor);
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            UpdateUI.logException(e);
                        }
                        catch (InterruptedException e) {
                            UpdateUI.logException(e, false);
                        }
                    }

                    static /* synthetic */ UpdateJobChangeListener access$0(1 var0) {
                        return var0.this$1;
                    }
                });
            } else if (event.getJob() == InstallWizard.this.job && event.getResult() != Status.OK_STATUS) {
                isRunning = false;
                Platform.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                Platform.getJobManager().cancel((Object)InstallWizard.this.job);
                UpdateUI.getStandardDisplay().syncExec(new Runnable(this, event){
                    final /* synthetic */ UpdateJobChangeListener this$1;
                    private final /* synthetic */ IJobChangeEvent val$event;
                    {
                        this.this$1 = updateJobChangeListener;
                        this.val$event = iJobChangeEvent;
                    }

                    public void run() {
                        UpdateUI.log(this.val$event.getResult(), true);
                    }
                });
            }
        }

        static /* synthetic */ InstallWizard access$0(UpdateJobChangeListener updateJobChangeListener) {
            return updateJobChangeListener.InstallWizard.this;
        }
    }
}

