/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.internal.ui.model.SiteBookmark;

public class SitesImportExport {
    static String lastLocation = null;

    public static SiteBookmark[] getImportedBookmarks(Shell parent) {
        FileDialog dialog = new FileDialog(parent);
        dialog.setText(UpdateUI.getString("LocalSiteSelector.dialogMessageImport"));
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        SiteBookmark[] siteBookmarks = null;
        String bookmarksFile = dialog.open();
        while (bookmarksFile != null && siteBookmarks == null) {
            File file = new File(bookmarksFile);
            siteBookmarks = SitesImportExport.createImportedBookmarks(file);
            if (siteBookmarks != null && siteBookmarks.length != 0) break;
            MessageDialog.openInformation((Shell)parent, (String)UpdateUI.getString("LocalSiteSelector.importInfoTitle"), (String)UpdateUI.getString("LocalSiteSelector.importInfoMessage"));
            bookmarksFile = dialog.open();
        }
        return siteBookmarks;
    }

    public static void exportBookmarks(Shell parent, SiteBookmark[] siteBookmarks) {
        FileDialog dialog = new FileDialog(parent, 8192);
        dialog.setText(UpdateUI.getString("LocalSiteSelector.dialogMessageExport"));
        dialog.setFileName("bookmarks.xml");
        String bookmarksFile = dialog.open();
        if (bookmarksFile == null) {
            return;
        }
        Vector<SiteBookmark> bookmarks = new Vector<SiteBookmark>(siteBookmarks.length);
        int i = 0;
        while (i < siteBookmarks.length) {
            bookmarks.add(siteBookmarks[i]);
            ++i;
        }
        BookmarkUtil.store(bookmarksFile, bookmarks);
    }

    static SiteBookmark[] createImportedBookmarks(File file) {
        Vector bookmarks = new Vector();
        BookmarkUtil.parse(file.getAbsolutePath(), bookmarks);
        return BookmarkUtil.getBookmarks(bookmarks);
    }
}

