/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.Doc;
import bilab.Notify;
import bilab.Summary;
import bilab.ValueView;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import scigol.Any;
import scigol.ClassInfo;
import scigol.ClassScope;
import scigol.Entry;
import scigol.LocalScope;
import scigol.NamespaceScope;
import scigol.Num;
import scigol.ScigolAnnotation;
import scigol.Scope;
import scigol.TypeSpec;
import scigol.Value;

public class EnvNavigatorView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private Action selectionChangedAction;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        ViewContentProvider contentProvider = new ViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(contentProvider));
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.hookPostSelectionSelectionChangedAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EnvNavigatorView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                EnvNavigatorView.this.showMessage("Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                EnvNavigatorView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = this.selectionChangedAction = new Action(){

            public void run() {
                block20: {
                    ValueView valueView = ValueView.getInstance();
                    try {
                        ISelection selection = EnvNavigatorView.this.viewer.getSelection();
                        Object obj = ((IStructuredSelection)selection).getFirstElement();
                        if (valueView != null && obj instanceof Entry) {
                            Entry e = (Entry)obj;
                            Object v = e.getStaticValue();
                            TypeSpec type = e.type;
                            if (type.isAny()) {
                                type = TypeSpec.typeOf(((Any)v).value);
                            }
                            if (type.isNum()) {
                                type = TypeSpec.typeOf(((Num)v).value);
                            }
                            if (type.equals(new TypeSpec((Type)((Object)NamespaceScope.class)))) {
                                return;
                            }
                            if (type.isFunc()) {
                                StringBuilder sb = new StringBuilder();
                                sb.append(String.valueOf(e.name) + " : " + (v != null ? v.toString() : "null") + "\n");
                                BilabPlugin.getDefault().getGlobalScope();
                                TypeSpec summaryAnnotationType = new TypeSpec((Type)((Object)Summary.class));
                                TypeSpec docAnnotationType = new TypeSpec((Type)((Object)Doc.class));
                                Annotation docAnnot = e.getAnnotation(docAnnotationType);
                                if (docAnnot != null) {
                                    String doc = null;
                                    if (docAnnot instanceof ScigolAnnotation) {
                                        Value val = (Value)((ScigolAnnotation)docAnnot).getMembers().get(0);
                                        doc = (String)val.getValue();
                                    } else {
                                        doc = ((Doc)docAnnot).value();
                                    }
                                    if (!doc.startsWith("file:") && !doc.startsWith("http:")) {
                                        sb.append(String.valueOf(e.name) + ":\n" + doc);
                                    } else {
                                        String URLString = doc;
                                        try {
                                            URL url = null;
                                            url = URLString.startsWith("file:") ? BilabPlugin.getResourceManager().findResource(URLString.substring(5)) : new URL(URLString);
                                            v = url;
                                            valueView.setInput(new Value(v));
                                            return;
                                        }
                                        catch (MalformedURLException malformedURLException) {
                                            sb.append(doc);
                                        }
                                        catch (IOException ex) {
                                            throw new BilabException("error reading help resource " + URLString + " - " + ex);
                                        }
                                    }
                                } else {
                                    Annotation summaryAnnot = e.getAnnotation(summaryAnnotationType);
                                    if (summaryAnnot != null) {
                                        String summary = null;
                                        if (summaryAnnot instanceof ScigolAnnotation) {
                                            Value val = (Value)((ScigolAnnotation)summaryAnnot).getMembers().get(0);
                                            summary = (String)val.getValue();
                                        } else {
                                            summary = ((Summary)summaryAnnot).value();
                                        }
                                        sb.append(summary);
                                    }
                                }
                                v = sb.toString();
                            }
                            if (!(v instanceof NamespaceScope)) {
                                valueView.setInput(new Value(v));
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (valueView == null) break block20;
                        valueView.setInput(new Value("<error obtaining value: " + t + ">"));
                    }
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EnvNavigatorView.this.doubleClickAction.run();
            }
        });
    }

    private void hookPostSelectionSelectionChangedAction() {
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                EnvNavigatorView.this.selectionChangedAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Environment Navigator", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private Object invisibleRoot;
        NamespaceScope globalScope;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(EnvNavigatorView.this.getViewSite())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof Scope) {
                return ((Scope)child).getOuter();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            try {
                if (parent instanceof String && parent.equals("namespaces")) {
                    LinkedList<NamespaceScope> namespaces = new LinkedList<NamespaceScope>();
                    namespaces.add(this.globalScope);
                    AbstractList<String> namespaceNames = NamespaceScope.getNamespaceNames();
                    for (String namespaceName : namespaceNames) {
                        NamespaceScope nsScope = this.globalScope.getNamespaceScope(namespaceName);
                        if (nsScope == null) continue;
                        namespaces.add(nsScope);
                    }
                    namespaces.add(this.globalScope.getNamespaceScope("bilab.lib"));
                    namespaces.add(this.globalScope.getNamespaceScope("bilab.emboss"));
                    namespaces.add(this.globalScope.getNamespaceScope("bilab.phylip"));
                    return namespaces.toArray();
                }
                if (parent instanceof Scope) {
                    if (parent instanceof NamespaceScope) {
                        return ((NamespaceScope)parent).getDeclaredEntries(null, null);
                    }
                    if (parent instanceof ClassScope) {
                        return ((ClassScope)parent).getClassType().getClassInfo().getDeclaredEntries(null);
                    }
                    return ((Scope)parent).getEntries(null, null);
                }
                if (parent instanceof Entry) {
                    TypeSpec type;
                    Entry e = (Entry)parent;
                    if (e.type.isType() && e.getStaticValue() != null && (type = (TypeSpec)e.getStaticValue()).isClassOrBuiltinClassOrInterface()) {
                        ClassInfo cinfo = type.getClassInfo();
                        return cinfo.getAllEntries(null);
                    }
                }
            }
            catch (Throwable t) {
                Notify.devWarning(this, "Exception creating children for " + parent + " - " + t);
                t.printStackTrace();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        private void initialize() {
            this.globalScope = BilabPlugin.getDefault().getGlobalScope();
            this.invisibleRoot = "namespaces";
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        protected ViewContentProvider viewContentProvider;
        static /* synthetic */ Class class$0;

        public ViewLabelProvider(ViewContentProvider cp) {
            this.viewContentProvider = cp;
        }

        public String getText(Object obj) {
            try {
                if (obj instanceof Scope) {
                    if (obj instanceof NamespaceScope) {
                        String name = ((NamespaceScope)obj).fullNamespaceName();
                        if (!name.equals("")) {
                            return name;
                        }
                        return "<global>";
                    }
                    if (obj instanceof LocalScope) {
                        return "<local>";
                    }
                    if (obj instanceof ClassScope) {
                        return ((ClassScope)obj).getClassType().typeName();
                    }
                } else if (obj instanceof Entry) {
                    TypeSpec summaryAnnotationType;
                    Annotation summaryAnnot;
                    Entry e = (Entry)obj;
                    String s = e.name;
                    TypeSpec type = e.type;
                    if (!e.isProperty()) {
                        if (type.isAny()) {
                            type = TypeSpec.typeOf(((Any)e.getStaticValue()).value);
                        }
                        if (type.isNum()) {
                            type = TypeSpec.typeOf(((Num)e.getStaticValue()).value);
                        }
                    }
                    s = e.type.isAny() || e.type.isNum() ? String.valueOf(s) + " :" + e.type + "(" + type + ")" : String.valueOf(s) + " :" + type;
                    if (!(!type.isBuiltin() || type.isAny() || type.isMap() || type.isList() || type.isMatrix() || type.isVector())) {
                        Object v = e.getStaticValue();
                        s = v != null ? String.valueOf(s) + " = " + e.getStaticValue().toString() : String.valueOf(s) + " = null";
                    }
                    if ((summaryAnnot = e.getAnnotation(summaryAnnotationType = new TypeSpec((Type)((Object)Summary.class)))) != null) {
                        String summary = null;
                        if (summaryAnnot instanceof ScigolAnnotation) {
                            Value v = (Value)((ScigolAnnotation)summaryAnnot).getMembers().get(0);
                            summary = (String)v.getValue();
                        } else {
                            summary = ((Summary)summaryAnnot).value();
                        }
                        s = String.valueOf(s) + " - " + summary;
                    }
                    return s;
                }
                return obj.toString();
            }
            catch (Throwable throwable) {
                return "<error>";
            }
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof NamespaceScope || this.viewContentProvider.hasChildren(obj)) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

