/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import SQLite.Authorizer;
import SQLite.Callback;
import SQLite.Database;
import SQLite.Function;
import SQLite.FunctionContext;
import SQLite.ProgressHandler;
import SQLite.Trace;
import SQLite.Vm;

public class SQLiteTest
implements Callback,
Function,
Authorizer,
Trace,
ProgressHandler {
    private StringBuffer acc = new StringBuffer();

    public void columns(String[] col) {
        System.out.println("#cols = " + col.length);
        int i = 0;
        while (i < col.length) {
            System.out.println("col" + i + ": " + col[i]);
            ++i;
        }
    }

    public void types(String[] types) {
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                System.out.println("coltype" + i + ": " + types[i]);
                ++i;
            }
        }
    }

    public boolean newrow(String[] data) {
        int i = 0;
        while (i < data.length) {
            System.out.println("data" + i + ": " + data[i]);
            ++i;
        }
        return false;
    }

    public void function(FunctionContext fc, String[] args) {
        System.out.println("function:");
        int i = 0;
        while (i < args.length) {
            System.out.println("arg[" + i + "]=" + args[i]);
            ++i;
        }
        if (args.length > 0) {
            fc.set_result(args[0].toLowerCase());
        }
    }

    public void step(FunctionContext fc, String[] args) {
        System.out.println("step:");
        int i = 0;
        while (i < args.length) {
            this.acc.append(args[i]);
            this.acc.append(" ");
            ++i;
        }
    }

    public void last_step(FunctionContext fc) {
        System.out.println("last_step");
        fc.set_result(this.acc.toString());
        this.acc.setLength(0);
    }

    public int authorize(int what, String arg1, String arg2, String arg3, String arg4) {
        System.out.println("AUTH: " + what + "," + arg1 + "," + arg2 + "," + arg3 + "," + arg4);
        return 0;
    }

    public void trace(String stmt) {
        System.out.println("TRACE: " + stmt);
    }

    public boolean progress() {
        System.out.println("PROGRESS");
        return true;
    }

    public static void test() {
        System.out.println("LIB version: " + Database.version());
        Database db = new Database();
        try {
            try {
                db.open("U:\\dev\\GTL\\win\\BiLabRCP\\BiLab\\resources\\test.db", 438);
                System.out.println("DB version: " + db.dbversion());
                db.interrupt();
                db.busy_timeout(1000);
                db.busy_handler(null);
                db.exec("create table TEST (firstname char(32), lastname char(32) )", (Callback)new SQLiteTest());
                db.create_function("myregfunc", -1, (Function)new SQLiteTest());
                db.function_type("myregfunc", -2);
                db.create_aggregate("myaggfunc", 1, (Function)new SQLiteTest());
                db.function_type("myaggfunc", -2);
                db.exec("PRAGMA show_datatypes = on", null);
                System.out.println("==== local callback ====");
                db.exec("select * from sqlite_master", (Callback)new SQLiteTest());
                System.out.println("==== get_table ====");
                System.out.print(db.get_table("select * from TEST"));
                System.out.println("==== get_table w/ args ====");
                String[] qargs = new String[]{"tab%"};
                System.out.print(db.get_table("select * from sqlite_master where type like '%q'", qargs));
                System.out.println("==== call regular function ====");
                db.exec("select myregfunc(TEST.firstname) from TEST", (Callback)new SQLiteTest());
                System.out.println("==== call aggregate function ====");
                db.exec("select myaggfunc(TEST.firstname) from TEST", (Callback)new SQLiteTest());
                System.out.println("==== compile/step interface ====");
                SQLiteTest cb = new SQLiteTest();
                db.set_authorizer((Authorizer)cb);
                db.trace((Trace)cb);
                Vm vm = db.compile("select * from TEST; delete from TEST where id = 5; insert into TEST values(5, 'Speedy', 'Gonzales'); select * from TEST");
                int stmt = 0;
                do {
                    if (++stmt > 3) {
                        System.out.println("setting progress handler");
                        db.progress_handler(3, (ProgressHandler)cb);
                    }
                    System.out.println("---- STMT #" + stmt + " ----");
                    while (vm.step((Callback)cb)) {
                    }
                } while (vm.compile());
                db.close();
                System.out.println("An exception is expected from now on.");
                System.out.println("==== local callback ====");
                db.exec("select * from sqlite_master", (Callback)new SQLiteTest());
            }
            catch (Exception e) {
                System.err.println("error: " + e);
            }
        }
        finally {
            try {
                try {
                    System.err.println("cleaning up ...");
                    db.close();
                }
                catch (Exception e) {
                    System.err.println("error: " + e);
                }
            }
            finally {
                System.err.println("done.");
            }
        }
    }
}

