/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.Sophistication;
import bilab.Summary;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import scigol.accessor;

@Sophistication(value=3)
public abstract class ViewerBase
extends Viewer
implements ISelectionListener {
    @accessor
    @Summary(value="is this viewer in-line or does is use an external viewer component?")
    public boolean get_IsExternal() {
        return false;
    }

    public abstract void dispose();

    public abstract Point preferedSize();

    public abstract Point maximumSize();

    @accessor
    public abstract String get_title();

    @accessor
    public abstract String get_description();

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    protected static Composite optionalControlsComposite(Composite parent) {
        OverlayingComposite overlay = new OverlayingComposite(parent, 0);
        new Button((Composite)overlay, 1028);
        return overlay;
    }

    private static class OverlayingComposite
    extends Composite {
        public OverlayingComposite(Composite parent, int style) {
            super(parent, style);
            Display display = Display.getCurrent();
            this.setBackground(display.getSystemColor(1));
            this.addControlListener(new ResizeControlListener(this));
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Control[] children = this.getChildren();
            if (children.length == 0) {
                return new Point(1024, 1024);
            }
            Point size = new Point(0, 0);
            Control[] controlArray = children;
            int n = 0;
            int n2 = controlArray.length;
            while (n < n2) {
                Control c = controlArray[n];
                Point csize = c.computeSize(wHint, hHint, changed);
                if (csize.x > size.x) {
                    size.x = csize.x;
                }
                if (csize.y > size.y) {
                    size.y = csize.y;
                }
                ++n;
            }
            return size;
        }

        public Point computeSize(int wHint, int hHint) {
            return this.computeSize(wHint, hHint, false);
        }

        public void layout() {
            Rectangle b = this.getBounds();
            Control[] controlArray = this.getChildren();
            int n = 0;
            int n2 = controlArray.length;
            while (n < n2) {
                Control c = controlArray[n];
                Point size = c.computeSize(-1, -1, true);
                c.setBounds(b.x, b.y, Math.min(size.x, b.width), Math.min(size.y, b.height));
                ++n;
            }
        }

        private static class ResizeControlListener
        implements ControlListener {
            private OverlayingComposite c;

            public ResizeControlListener(OverlayingComposite overlayingComposite) {
                this.c = overlayingComposite;
            }

            public void controlResized(ControlEvent e) {
                this.c.layout();
            }

            public void controlMoved(ControlEvent e) {
            }
        }
    }
}

