/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.model;

import bilab.notebook.model.Graphic;
import bilab.notebook.model.ModelElement;

public class Connection
extends ModelElement {
    public static final Integer DASHED_CONNECTION = new Integer(2);
    public static final String LINESTYLE_PROP = "Connection.LineStyle";
    private static final long serialVersionUID = 1L;
    public static final Integer SOLID_CONNECTION = new Integer(1);
    private boolean isConnected;
    private int lineStyle = 1;
    private Graphic source;
    private Graphic target;

    public Connection(Graphic source, Graphic target) {
        this.reconnect(source, target);
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.removeConnection(this);
            this.target.removeConnection(this);
            this.isConnected = false;
        }
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public Graphic getSource() {
        return this.source;
    }

    public Graphic getTarget() {
        return this.target;
    }

    public void reconnect() {
        if (!this.isConnected) {
            this.source.addConnection(this);
            this.target.addConnection(this);
            this.isConnected = true;
        }
    }

    public void reconnect(Graphic newSource, Graphic newTarget) {
        if (newSource == null || newTarget == null || newSource == newTarget) {
            throw new IllegalArgumentException();
        }
        this.disconnect();
        this.source = newSource;
        this.target = newTarget;
        this.reconnect();
    }

    public void setLineStyle(int lineStyle) {
        if (lineStyle != 2 && lineStyle != 1) {
            throw new IllegalArgumentException();
        }
        this.lineStyle = lineStyle;
        this.firePropertyChange(LINESTYLE_PROP, null, new Integer(this.lineStyle));
    }
}

