/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.model.commands;

import bilab.notebook.model.Connection;
import bilab.notebook.model.Graphic;
import org.eclipse.gef.commands.Command;

public class ConnectionCreateCommand
extends Command {
    private Connection connection;
    private final int lineStyle;
    private final Graphic source;
    private Graphic target;

    public ConnectionCreateCommand(Graphic source, int lineStyle) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("connection creation");
        this.source = source;
        this.lineStyle = lineStyle;
    }

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        for (Connection conn : this.source.getSourceConnections()) {
            if (!conn.getTarget().equals(this.target)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        this.connection = new Connection(this.source, this.target);
        this.connection.setLineStyle(this.lineStyle);
    }

    public void redo() {
        this.connection.reconnect();
    }

    public void setTarget(Graphic target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

