/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.model.commands;

import bilab.notebook.model.Connection;
import bilab.notebook.model.Graphic;
import org.eclipse.gef.commands.Command;

public class ConnectionReconnectCommand
extends Command {
    private Connection connection;
    private Graphic newSource;
    private Graphic newTarget;
    private final Graphic oldSource;
    private final Graphic oldTarget;

    public ConnectionReconnectCommand(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        this.connection = conn;
        this.oldSource = conn.getSource();
        this.oldTarget = conn.getTarget();
    }

    public boolean canExecute() {
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource.equals(this.oldTarget)) {
            return false;
        }
        for (Connection conn : this.newSource.getSourceConnections()) {
            if (!conn.getTarget().equals(this.oldTarget) || conn.equals(this.connection)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget.equals(this.oldSource)) {
            return false;
        }
        for (Connection conn : this.newTarget.getTargetConnections()) {
            if (!conn.getSource().equals(this.oldSource) || conn.equals(this.connection)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.reconnect(this.newSource, this.oldTarget);
        } else if (this.newTarget != null) {
            this.connection.reconnect(this.oldSource, this.newTarget);
        } else {
            throw new IllegalStateException("Should not happen");
        }
    }

    public void setNewSource(Graphic connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection startpoint");
        this.newSource = connectionSource;
        this.newTarget = null;
    }

    public void setNewTarget(Graphic connectionTarget) {
        if (connectionTarget == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection endpoint");
        this.newSource = null;
        this.newTarget = connectionTarget;
    }

    public void undo() {
        this.connection.reconnect(this.oldSource, this.oldTarget);
    }
}

