/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ColourScheme;
import jalview.ConservationColourScheme;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.IdPanel;
import jalview.ResidueColourScheme;
import jalview.ResidueProperties;
import jalview.ScalePanel;
import jalview.ScorePanel;
import jalview.ScoreSequence;
import jalview.SeqPanel;
import jalview.Sequence;
import jalview.SequenceGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.Vector;

public class AlignmentPanel
extends Panel {
    public SeqPanel seqPanel;
    public IdPanel idPanel;
    public ScalePanel scalePanel;
    public Component parent;
    public Vector sel;
    public boolean[] selected;
    public Vector selectedColumns;
    public boolean groupEdit = false;
    public Hashtable[] cons;
    boolean conservation = false;
    public Color[] color = ResidueProperties.color;
    public int scaleheight = 20;

    public AlignmentPanel(Component p, DrawableSequence[] s) {
        this.parent = p;
        this.idPanel = new IdPanel(this);
        this.seqPanel = new SeqPanel(this, s);
        this.scalePanel = new ScalePanel(this);
        this.sel = new Vector();
        this.selected = new boolean[this.seqPanel.align.size];
        this.selectedColumns = new Vector();
        this.componentInit();
        System.out.println("Loaded AlignmentPanel");
    }

    public int countSelected() {
        int count = 0;
        int i = 0;
        while (i < this.selected.length) {
            if (this.selected[i]) {
                ++count;
            }
            ++i;
        }
        return this.sel.size();
    }

    public void componentInit() {
        this.setLayout(null);
        this.add(this.idPanel);
        this.add(this.scalePanel);
        this.add(this.seqPanel);
        this.selectAll(false);
        System.out.println("Finished AlignmentPanel.componentInit");
    }

    public void selectAll(boolean flag) {
        int i = 0;
        if (flag) {
            while (i < this.seqPanel.align.size) {
                if (!this.sel.contains(this.seqPanel.align.sequences[i])) {
                    this.sel.addElement(this.seqPanel.align.sequences[i]);
                }
                ++i;
            }
        } else {
            this.sel = null;
            this.sel = new Vector();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void oldreshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        int idw = this.idPanel.idCanvas.idWidth;
        this.scalePanel.reshape(0, 0, width, this.scaleheight);
        this.idPanel.reshape(0, this.scaleheight, idw, height - this.scaleheight);
        this.seqPanel.reshape(idw, this.scaleheight, width - idw, height - this.scaleheight);
    }

    public void setSequenceColor(ColourScheme c) {
        int count = this.countSelected();
        if (count == 0) {
            if (this.cons == null) {
                System.out.println("Calculating consensus");
                this.seqPanel.align.percentIdentity();
                this.cons = this.seqPanel.align.cons;
            } else {
                this.cons = this.seqPanel.align.cons;
            }
            if (c instanceof ResidueColourScheme) {
                System.out.println("Setting consensus");
                ((ResidueColourScheme)c).cons = this.cons;
            }
            this.seqPanel.align.setColourScheme(c);
            int i = 0;
            while (i < this.seqPanel.align.groups.size()) {
                SequenceGroup sg = (SequenceGroup)this.seqPanel.align.groups.elementAt(i);
                sg.colourScheme = c;
                sg.color = this.color;
                if (this.conservation && sg.conserve != null) {
                    ConservationColourScheme tmp = new ConservationColourScheme(sg);
                    sg.colourScheme = tmp;
                }
                sg.colourScheme.setColours(sg);
                ++i;
            }
        } else {
            SequenceGroup sg = this.seqPanel.align.addGroup();
            sg.colourScheme = c;
            sg.color = this.color;
            this.seqPanel.align.setColourScheme(sg);
            int i = 0;
            while (i < this.sel.size()) {
                this.seqPanel.align.removeFromGroup(this.seqPanel.align.findGroup((Sequence)this.sel.elementAt(i)), (Sequence)this.sel.elementAt(i));
                this.seqPanel.align.addToGroup(sg, (Sequence)this.sel.elementAt(i));
                ++i;
            }
            if (this.conservation && sg.conserve != null) {
                sg.colourScheme = new ConservationColourScheme(sg);
            }
            sg.colourScheme.setColours(sg);
        }
    }

    public void setSequenceColor(int start, int end) {
        int i = 0;
        while (i < this.seqPanel.align.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.seqPanel.align.groups.elementAt(i);
            int k = 0;
            while (k < sg.sequences.size()) {
                DrawableSequence ds = (DrawableSequence)sg.sequences.elementAt(k);
                int j = start;
                while (j <= end) {
                    sg.colourScheme.setColours(ds, j);
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    public void setSequenceColor(DrawableSequence seq2, int start, int end) {
        SequenceGroup sg = this.seqPanel.align.findGroup(seq2);
        int j = start;
        while (j <= end) {
            sg.colourScheme.setColours(seq2, j);
            ++j;
        }
    }

    public void setSequenceColor() {
        int i = 0;
        while (i < this.seqPanel.align.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.seqPanel.align.groups.elementAt(i);
            sg.colourScheme.setColours(sg);
            ++i;
        }
    }

    public void setSequenceColor(int threshold, ColourScheme scheme) {
        int count = this.countSelected();
        if (count == 0) {
            if (this.cons == null) {
                this.seqPanel.align.percentIdentity();
                this.cons = this.seqPanel.align.cons;
            }
            if (this.conservation) {
                int j = 0;
                while (j < this.seqPanel.align.groups.size()) {
                    SequenceGroup sg = (SequenceGroup)this.seqPanel.align.groups.elementAt(j);
                    if (sg.conserve != null) {
                        sg.colourScheme = new ConservationColourScheme(sg);
                        sg.colourScheme.setColours(sg);
                    }
                    ++j;
                }
            } else {
                int i = 0;
                while (i < this.seqPanel.align.groups.size()) {
                    SequenceGroup sg = (SequenceGroup)this.seqPanel.align.groups.elementAt(i);
                    if (sg.colourScheme instanceof ResidueColourScheme) {
                        ((ResidueColourScheme)sg.colourScheme).colourThreshold = threshold;
                        ((ResidueColourScheme)sg.colourScheme).cons = this.cons;
                        sg.colourScheme.setColours(sg);
                    }
                    ++i;
                }
            }
        } else {
            SequenceGroup sg = this.seqPanel.align.addGroup();
            sg.colourScheme = scheme;
            int i = 0;
            while (i < this.sel.size()) {
                this.seqPanel.align.removeFromGroup(this.seqPanel.align.findGroup((Sequence)this.sel.elementAt(i)), (Sequence)this.sel.elementAt(i));
                this.seqPanel.align.addToGroup(sg, (Sequence)this.sel.elementAt(i));
                ++i;
            }
            if (this.conservation) {
                if (sg.colourScheme instanceof ResidueColourScheme) {
                    ((ResidueColourScheme)sg.colourScheme).colourThreshold = threshold;
                    ((ResidueColourScheme)sg.colourScheme).cons = this.cons;
                    if (sg.conserve != null) {
                        sg.colourScheme = new ConservationColourScheme(sg);
                        sg.colourScheme.setColours(sg);
                    }
                }
            } else if (sg.colourScheme instanceof ResidueColourScheme) {
                ((ResidueColourScheme)sg.colourScheme).colourThreshold = threshold;
                ((ResidueColourScheme)sg.colourScheme).cons = this.cons;
                sg.colourScheme.setColours(sg);
            }
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame("SeqPanel");
        Sequence[] seq2 = FormatAdapter.read(args[0], "File", "POSTAL");
        DrawableSequence[] s = new ScoreSequence[seq2.length];
        int i = 0;
        while (i < seq2.length) {
            s[i] = new ScoreSequence(seq2[i]);
            ++i;
        }
        DrawableSequence[] s1 = new DrawableSequence[seq2.length];
        int i2 = 0;
        while (i2 < seq2.length) {
            s1[i2] = new DrawableSequence(seq2[i2]);
            ++i2;
        }
        AlignmentPanel ap = new AlignmentPanel(null, s1);
        new ScorePanel(null, s);
        f.setLayout(new BorderLayout());
        f.add("Center", ap);
        f.resize(700, 500);
        f.show();
    }
}

