/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.Sequence;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class BLCFile
extends FileParse {
    int maxLength = 0;
    Vector seqs = new Vector();
    Vector headers = new Vector();
    Vector titles = new Vector();

    public BLCFile(String inStr) {
        this.readLines(inStr);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public BLCFile(String inFile, String type) throws IOException {
        super(inFile, type);
        System.out.print("Reading file....");
        this.readLines();
        System.out.println("done");
        System.out.println("Parsing file....");
        this.parse();
    }

    public void parse() {
        Vector<String> seqstrings = new Vector<String>();
        Vector<Integer> starts = new Vector<Integer>();
        Vector<Integer> ends = new Vector<Integer>();
        int i = 0;
        while (i < this.lineArray.size()) {
            String line = (String)this.lineArray.elementAt(i);
            if (line.indexOf(">") >= 0) {
                String tmp = line.substring(line.indexOf(">") + 1);
                StringTokenizer st = new StringTokenizer(tmp);
                String id = st.nextToken();
                if (id.indexOf("/") > 0) {
                    StringTokenizer st2 = new StringTokenizer(id, "/");
                    if (st2.countTokens() == 2) {
                        id = st2.nextToken();
                        String tmp2 = st2.nextToken();
                        if ((st2 = new StringTokenizer(tmp2, "-")).countTokens() == 2) {
                            starts.addElement(new Integer(st2.nextToken()));
                            starts.addElement(new Integer(st2.nextToken()));
                        } else {
                            starts.addElement(new Integer(-1));
                            ends.addElement(new Integer(-1));
                        }
                    }
                } else {
                    starts.addElement(new Integer(-1));
                    ends.addElement(new Integer(-1));
                }
                String title = "";
                while (st.hasMoreTokens()) {
                    title = String.valueOf(title) + " " + st.nextToken();
                }
                System.out.println(id);
                this.headers.addElement(id);
                this.titles.addElement(title);
                seqstrings.addElement("");
            }
            if (line.indexOf("*") >= 0) {
                int startcol = line.indexOf("*");
                line = (String)this.lineArray.elementAt(++i);
                while (i < this.lineArray.size() && line.indexOf("*") < 0) {
                    System.out.println(":" + line + ":");
                    int j = startcol;
                    while (j < this.headers.size()) {
                        String s = (String)seqstrings.elementAt(j);
                        if (line.length() > j) {
                            seqstrings.setElementAt(String.valueOf(s) + line.substring(j, j + 1), j);
                        } else {
                            seqstrings.setElementAt(String.valueOf(s) + "-", j);
                        }
                        ++j;
                    }
                    line = (String)this.lineArray.elementAt(++i);
                }
                int j = startcol;
                while (j < this.headers.size()) {
                    if ((Integer)starts.elementAt(j) >= 0 && (Integer)ends.elementAt(j) >= 0) {
                        this.seqs.addElement(new Sequence((String)this.headers.elementAt(j - startcol), (String)seqstrings.elementAt(j), (Integer)starts.elementAt(j), (Integer)ends.elementAt(j)));
                    } else {
                        this.seqs.addElement(new Sequence((String)this.headers.elementAt(j - startcol), (String)seqstrings.elementAt(j), 1, ((String)seqstrings.elementAt(j)).length()));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static String print(Sequence[] s) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        int max = -1;
        while (i < s.length && s[i] != null) {
            out.append(">" + s[i].getName() + "/" + s[i].start + "-" + s[i].end + "\n");
            if (s[i].getSequence().length() > max) {
                max = s[i].getSequence().length();
            }
            ++i;
            out.append("* iteration\n");
            int j = 0;
            while (j < max) {
                i = 0;
                while (i < s.length && s[i] != null) {
                    out.append(s[i].getSequence().substring(j, j + 1));
                    ++i;
                }
                out.append("\n");
                ++j;
            }
        }
        out.append("*\n");
        return out.toString();
    }

    public static void main(String[] args) {
        try {
            BLCFile blc = new BLCFile(args[0], "File");
            Sequence[] s = new DrawableSequence[blc.seqs.size()];
            int i = 0;
            while (i < blc.seqs.size()) {
                s[i] = new DrawableSequence((Sequence)blc.seqs.elementAt(i));
                ++i;
            }
            String out = BLCFile.print(s);
            AlignFrame af = new AlignFrame(null, (DrawableSequence[])s);
            af.resize(700, 500);
            af.show();
            System.out.println(out);
        }
        catch (IOException e) {
            System.out.println("Exception " + e);
        }
    }
}

