/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ColourScheme;
import jalview.Conservation;
import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.SequenceGroup;
import java.awt.Color;

public class ConservationColourScheme
extends ResidueColourScheme {
    Conservation conserve;
    boolean byResidue = true;
    ColourScheme cs;
    int inc = 30;

    public ConservationColourScheme(SequenceGroup sg, int inc) {
        this(sg);
        this.inc = inc;
    }

    public ConservationColourScheme(SequenceGroup sg) {
        this.conserve = sg.conserve;
        this.colourThreshold = 7;
        this.cs = sg.colourScheme;
    }

    public void setColours(DrawableSequence seq2, int j) {
        Color c = Color.white;
        String s = seq2.getSequence().substring(j, j + 1);
        try {
            if (this.colourThreshold > 0 && this.conserve.consSequence != null) {
                if (this.fullConservation(j)) {
                    c = this.byResidue ? this.findColour(seq2, s, j) : Color.red;
                } else if (this.byResidue) {
                    int tmp = 10;
                    int t = Integer.parseInt(this.conserve.consSequence.sequence.substring(j, j + 1));
                    c = this.findColour(seq2, s, j);
                    while (tmp >= t) {
                        c = this.lighter(c, this.inc);
                        --tmp;
                    }
                } else {
                    c = Color.yellow;
                }
            }
            seq2.setResidueBoxColour(j, c);
        }
        catch (Exception exception) {
            seq2.setResidueBoxColour(j, Color.white);
        }
    }

    public Color findColour(DrawableSequence seq2, String s, int j) {
        return this.cs.findColour(seq2, s, j);
    }

    public boolean fullConservation(int j) {
        String tmp = this.conserve.consSequence.sequence.substring(j, j + 1);
        return tmp.equals("*");
    }

    public boolean aboveThreshold(DrawableSequence seq2, int j, int threshold) {
        String tmp = this.conserve.consSequence.sequence.substring(j, j + 1);
        return Integer.parseInt(tmp) >= threshold || tmp.equals("*");
    }

    public Color lighter(Color c, int inc) {
        int red = c.getRed();
        int blue = c.getBlue();
        int green = c.getGreen();
        red = red < 255 - inc ? (red += inc) : 255;
        blue = blue < 255 - inc ? (blue += inc) : 255;
        green = green < 255 - inc ? (green += inc) : 255;
        return new Color(red, green, blue);
    }
}

