/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.BLCFile;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.Sequence;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class JnetFile
extends FileParse {
    int maxLength = 0;
    Vector seqs = new Vector();
    Vector headers = new Vector();
    Vector titles = new Vector();
    Vector conf;
    Vector hscores = new Vector();
    Vector escores = new Vector();
    Vector cscores = new Vector();

    public JnetFile(String inStr) {
        this.conf = new Vector();
        this.readLines(inStr);
        this.parse();
    }

    public JnetFile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.conf = new Vector();
        System.out.print("Reading file....");
        this.readLines();
        System.out.println("done");
        System.out.println("Parsing file....");
        this.parse();
    }

    public void parse() {
        String seq2 = "";
        String pred = "";
        int i = 0;
        while (i < this.lineArray.size()) {
            String line = (String)this.lineArray.elementAt(i);
            if (line.indexOf("START PRED") >= 0) {
                ++i;
                while (i < this.lineArray.size() && line.indexOf("END PRED") < 0) {
                    line = (String)this.lineArray.elementAt(i);
                    StringTokenizer str = new StringTokenizer(line);
                    if (str.countTokens() != 6) {
                        System.out.println("Wrong number of columns " + str.countTokens());
                    } else {
                        seq2 = String.valueOf(seq2) + str.nextToken();
                        pred = String.valueOf(pred) + str.nextToken();
                        this.conf.addElement(new Double(str.nextToken()));
                        this.hscores.addElement(new Double(str.nextToken()));
                        this.escores.addElement(new Double(str.nextToken()));
                        this.cscores.addElement(new Double(str.nextToken()));
                    }
                    ++i;
                }
            }
            ++i;
        }
        System.out.println(String.valueOf(this.conf.size()) + " " + this.hscores.size() + " " + this.escores.size() + " " + this.cscores.size());
        this.seqs.addElement(new Sequence("Query", seq2, 1, seq2.length()));
        Sequence tmp = new Sequence("Predicition", pred, 1, pred.length());
        tmp.score[0] = this.conf;
        tmp.score[1] = this.hscores;
        tmp.score[2] = this.escores;
        tmp.score[3] = this.cscores;
        this.seqs.addElement(tmp);
        System.out.println("Sequence is " + ((Sequence)this.seqs.elementAt((int)0)).sequence);
        System.out.println("size = " + this.seqs.size());
    }

    public static String print(Sequence[] s) {
        StringBuffer out = new StringBuffer();
        out.append("START PRED\n");
        int i = 0;
        while (i < s[0].sequence.length()) {
            out.append(String.valueOf(s[0].sequence.substring(i, i + 1)) + " ");
            out.append(String.valueOf(s[1].sequence.substring(i, i + 1)) + " ");
            out.append(s[1].score[0].elementAt(i) + " ");
            out.append(s[1].score[1].elementAt(i) + " ");
            out.append(s[1].score[2].elementAt(i) + " ");
            out.append(s[1].score[3].elementAt(i) + " ");
            out.append("\n");
            ++i;
        }
        out.append("END PRED\n");
        return out.toString();
    }

    public static void main(String[] args) {
        try {
            BLCFile blc = new BLCFile(args[0], "File");
            Sequence[] s = new DrawableSequence[blc.seqs.size()];
            int i = 0;
            while (i < blc.seqs.size()) {
                s[i] = new DrawableSequence((Sequence)blc.seqs.elementAt(i));
                ++i;
            }
            String out = BLCFile.print(s);
            AlignFrame af = new AlignFrame(null, (DrawableSequence[])s);
            af.resize(700, 500);
            af.show();
            System.out.println(out);
        }
        catch (IOException e) {
            System.out.println("Exception " + e);
        }
    }
}

