/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import java.io.PrintStream;

public class Matrix {
    double[][] value;
    int rows;
    int cols;
    double[] d;
    double[] e;

    public Matrix(double[][] value, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.value = value;
    }

    public Matrix transpose() {
        double[][] out = new double[this.cols][this.rows];
        int i = 0;
        while (i < this.cols) {
            int j = 0;
            while (j < this.rows) {
                out[i][j] = this.value[j][i];
                ++j;
            }
            ++i;
        }
        return new Matrix(out, this.cols, this.rows);
    }

    public void print(PrintStream ps) {
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                Format.print(ps, "%8.2f", this.value[i][j]);
                ++j;
            }
            ps.println();
            ++i;
        }
    }

    public Matrix preMultiply(Matrix in) {
        System.out.println("new matrix size " + in.rows + " " + this.cols);
        double[][] tmp = new double[in.rows][this.cols];
        int i = 0;
        while (i < in.rows) {
            int j = 0;
            while (j < this.cols) {
                tmp[i][j] = 0.0;
                int k = 0;
                while (k < in.cols) {
                    double[] dArray = tmp[i];
                    int n = j;
                    dArray[n] = dArray[n] + in.value[i][k] * this.value[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new Matrix(tmp, in.rows, this.cols);
    }

    public double[] vectorPostMultiply(double[] in) {
        double[] out = new double[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = 0.0;
            int k = 0;
            while (k < in.length) {
                int n = i;
                out[n] = out[n] + this.value[i][k] * in[k];
                ++k;
            }
            ++i;
        }
        return out;
    }

    public Matrix postMultiply(Matrix in) {
        double[][] out = new double[this.rows][in.cols];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < in.cols) {
                out[i][j] = 0.0;
                int k = 0;
                while (k < this.rows) {
                    out[i][j] = out[i][j] + this.value[i][k] * in.value[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new Matrix(out, this.cols, in.rows);
    }

    public Matrix copy() {
        double[][] newmat = new double[this.rows][this.cols];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                newmat[i][j] = this.value[i][j];
                ++j;
            }
            ++i;
        }
        return new Matrix(newmat, this.rows, this.cols);
    }

    public void tred() {
        int j;
        double g;
        int k;
        int l;
        int n = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        int i = n;
        while (i >= 2) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 1) {
                k = 1;
                while (k <= l) {
                    scale += Math.abs(this.value[i - 1][k - 1]);
                    ++k;
                }
                if (scale == 0.0) {
                    this.e[i - 1] = this.value[i - 1][l - 1];
                } else {
                    k = 1;
                    while (k <= l) {
                        double[] dArray = this.value[i - 1];
                        int n2 = k - 1;
                        dArray[n2] = dArray[n2] / scale;
                        h += this.value[i - 1][k - 1] * this.value[i - 1][k - 1];
                        ++k;
                    }
                    double f = this.value[i - 1][l - 1];
                    g = f > 0.0 ? -1.0 * Math.sqrt(h) : Math.sqrt(h);
                    this.e[i - 1] = scale * g;
                    h -= f * g;
                    this.value[i - 1][l - 1] = f - g;
                    f = 0.0;
                    j = 1;
                    while (j <= l) {
                        this.value[j - 1][i - 1] = this.value[i - 1][j - 1] / h;
                        g = 0.0;
                        k = 1;
                        while (k <= j) {
                            g += this.value[j - 1][k - 1] * this.value[i - 1][k - 1];
                            ++k;
                        }
                        k = j + 1;
                        while (k <= l) {
                            g += this.value[k - 1][j - 1] * this.value[i - 1][k - 1];
                            ++k;
                        }
                        this.e[j - 1] = g / h;
                        f += this.e[j - 1] * this.value[i - 1][j - 1];
                        ++j;
                    }
                    double hh = f / (h + h);
                    j = 1;
                    while (j <= l) {
                        f = this.value[i - 1][j - 1];
                        this.e[j - 1] = g = this.e[j - 1] - hh * f;
                        k = 1;
                        while (k <= j) {
                            double[] dArray = this.value[j - 1];
                            int n3 = k - 1;
                            dArray[n3] = dArray[n3] - (f * this.e[k - 1] + g * this.value[i - 1][k - 1]);
                            ++k;
                        }
                        ++j;
                    }
                }
            } else {
                this.e[i - 1] = this.value[i - 1][l - 1];
            }
            this.d[i - 1] = h;
            --i;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        i = 1;
        while (i <= n) {
            l = i - 1;
            if (this.d[i - 1] != 0.0) {
                j = 1;
                while (j <= l) {
                    g = 0.0;
                    k = 1;
                    while (k <= l) {
                        g += this.value[i - 1][k - 1] * this.value[k - 1][j - 1];
                        ++k;
                    }
                    k = 1;
                    while (k <= l) {
                        double[] dArray = this.value[k - 1];
                        int n4 = j - 1;
                        dArray[n4] = dArray[n4] - g * this.value[k - 1][i - 1];
                        ++k;
                    }
                    ++j;
                }
            }
            this.d[i - 1] = this.value[i - 1][i - 1];
            this.value[i - 1][i - 1] = 1.0;
            j = 1;
            while (j <= l) {
                this.value[j - 1][i - 1] = 0.0;
                this.value[i - 1][j - 1] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void tqli() {
        int n = this.rows;
        int i = 2;
        while (i <= n) {
            this.e[i - 2] = this.e[i - 1];
            ++i;
        }
        this.e[n - 1] = 0.0;
        int l = 1;
        while (l <= n) {
            int m;
            int iter = 0;
            do {
                double c;
                m = l;
                while (m <= n - 1) {
                    double dd = Math.abs(this.d[m - 1]) + Math.abs(this.d[m]);
                    if (Math.abs(this.e[m - 1]) + dd == dd) break;
                    ++m;
                }
                if (m == l) continue;
                if (++iter == 30) {
                    System.out.print("Too many iterations in tqli");
                    System.exit(0);
                }
                double g = (this.d[l] - this.d[l - 1]) / (2.0 * this.e[l - 1]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m - 1] - this.d[l - 1] + this.e[l - 1] / (g + this.sign(r, g));
                double s = c = 1.0;
                double p = 0.0;
                i = m - 1;
                while (i >= l) {
                    double f = s * this.e[i - 1];
                    double b = c * this.e[i - 1];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i] - p;
                    r = (this.d[i - 1] - g) * s + 2.0 * c * b;
                    p = s * r;
                    this.d[i] = g + p;
                    g = c * r - b;
                    int k = 1;
                    while (k <= n) {
                        f = this.value[k - 1][i];
                        this.value[k - 1][i] = s * this.value[k - 1][i - 1] + c * f;
                        this.value[k - 1][i - 1] = c * this.value[k - 1][i - 1] - s * f;
                        ++k;
                    }
                    --i;
                }
                this.d[l - 1] = this.d[l - 1] - p;
                this.e[l - 1] = g;
                this.e[m - 1] = 0.0;
            } while (m != l);
            ++l;
        }
    }

    public void tred2() {
        int j;
        double g;
        int k;
        int l;
        int n = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        int i = n - 1;
        while (i >= 1) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 0) {
                k = 0;
                while (k < l) {
                    scale += Math.abs(this.value[i][k]);
                    ++k;
                }
                if (scale == 0.0) {
                    this.e[i] = this.value[i][l];
                } else {
                    k = 0;
                    while (k < l) {
                        double[] dArray = this.value[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += this.value[i][k] * this.value[i][k];
                        ++k;
                    }
                    double f = this.value[i][l];
                    g = f > 0.0 ? -1.0 * Math.sqrt(h) : Math.sqrt(h);
                    this.e[i] = scale * g;
                    h -= f * g;
                    this.value[i][l] = f - g;
                    f = 0.0;
                    j = 0;
                    while (j < l) {
                        this.value[j][i] = this.value[i][j] / h;
                        g = 0.0;
                        k = 0;
                        while (k < j) {
                            g += this.value[j][k] * this.value[i][k];
                            ++k;
                        }
                        k = j;
                        while (k < l) {
                            g += this.value[k][j] * this.value[i][k];
                            ++k;
                        }
                        this.e[j] = g / h;
                        f += this.e[j] * this.value[i][j];
                        ++j;
                    }
                    double hh = f / (h + h);
                    j = 0;
                    while (j < l) {
                        f = this.value[i][j];
                        this.e[j] = g = this.e[j] - hh * f;
                        k = 0;
                        while (k < j) {
                            double[] dArray = this.value[j];
                            int n3 = k;
                            dArray[n3] = dArray[n3] - (f * this.e[k] + g * this.value[i][k]);
                            ++k;
                        }
                        ++j;
                    }
                }
            } else {
                this.e[i] = this.value[i][l];
            }
            this.d[i] = h;
            --i;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        i = 0;
        while (i < n) {
            l = i - 1;
            if (this.d[i] != 0.0) {
                j = 0;
                while (j < l) {
                    g = 0.0;
                    k = 0;
                    while (k < l) {
                        g += this.value[i][k] * this.value[k][j];
                        ++k;
                    }
                    k = 0;
                    while (k < l) {
                        double[] dArray = this.value[k];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - g * this.value[k][i];
                        ++k;
                    }
                    ++j;
                }
            }
            this.d[i] = this.value[i][i];
            this.value[i][i] = 1.0;
            j = 0;
            while (j < l) {
                this.value[j][i] = 0.0;
                this.value[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void tqli2() {
        int n = this.rows;
        int i = 2;
        while (i <= n) {
            this.e[i - 2] = this.e[i - 1];
            ++i;
        }
        this.e[n - 1] = 0.0;
        int l = 1;
        while (l <= n) {
            int m;
            int iter = 0;
            do {
                double c;
                m = l;
                while (m <= n - 1) {
                    double dd = Math.abs(this.d[m - 1]) + Math.abs(this.d[m]);
                    if (Math.abs(this.e[m - 1]) + dd == dd) break;
                    ++m;
                }
                if (m == l) continue;
                if (++iter == 30) {
                    System.out.print("Too many iterations in tqli");
                    System.exit(0);
                }
                double g = (this.d[l] - this.d[l - 1]) / (2.0 * this.e[l - 1]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m - 1] - this.d[l - 1] + this.e[l - 1] / (g + this.sign(r, g));
                double s = c = 1.0;
                double p = 0.0;
                i = m - 1;
                while (i >= l) {
                    double f = s * this.e[i - 1];
                    double b = c * this.e[i - 1];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i] - p;
                    r = (this.d[i - 1] - g) * s + 2.0 * c * b;
                    p = s * r;
                    this.d[i] = g + p;
                    g = c * r - b;
                    int k = 1;
                    while (k <= n) {
                        f = this.value[k - 1][i];
                        this.value[k - 1][i] = s * this.value[k - 1][i - 1] + c * f;
                        this.value[k - 1][i - 1] = c * this.value[k - 1][i - 1] - s * f;
                        ++k;
                    }
                    --i;
                }
                this.d[l - 1] = this.d[l - 1] - p;
                this.e[l - 1] = g;
                this.e[m - 1] = 0.0;
            } while (m != l);
            ++l;
        }
    }

    public double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }

    public double[] getColumn(int n) {
        double[] out = new double[this.rows];
        int i = 0;
        while (i < this.rows) {
            out[i] = this.value[i][n];
            ++i;
        }
        return out;
    }

    public void printD(PrintStream ps) {
        int j = 0;
        while (j < this.rows) {
            Format.print(ps, "%15.4e", this.d[j]);
            ++j;
        }
    }

    public void printE(PrintStream ps) {
        int j = 0;
        while (j < this.rows) {
            Format.print(ps, "%15.4e", this.e[j]);
            ++j;
        }
    }

    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);
        double[][] in = new double[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                in[i][j] = Math.random();
                ++j;
            }
            ++i;
        }
        Matrix origmat = new Matrix(in, n, n);
        Matrix trans = origmat.transpose();
        Matrix symm = trans.postMultiply(origmat);
        symm.copy();
        System.currentTimeMillis();
        symm.tred();
        System.currentTimeMillis();
        System.currentTimeMillis();
        symm.tqli();
        System.currentTimeMillis();
    }
}

