/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.Alignment;
import jalview.Cluster;
import jalview.MSFfile;
import jalview.MyCanvas;
import jalview.Sequence;
import jalview.SequenceNode;
import jalview.TreeFile;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.io.IOException;
import java.util.Vector;

public class NJTree {
    TreeFile tf;
    Sequence[] sequence;
    float[][] distance;
    int noClus;
    Vector cluster;
    int[] done;
    int noseqs;
    int mini;
    int minj;
    float ri;
    float rj;
    Vector node;
    String type;
    String pwtype;

    public NJTree(Sequence[] sequence, String type, String pwtype) {
        this.sequence = sequence;
        this.node = new Vector();
        this.type = type;
        this.pwtype = pwtype;
        if (!type.equals("NJ")) {
            type = "AV";
        }
        if (!pwtype.equals("PID")) {
            type = "SW";
        }
        int i = 0;
        this.done = new int[sequence.length];
        while (i < sequence.length && sequence[i] != null) {
            this.done[i] = 0;
            ++i;
        }
        this.noseqs = i++;
        this.distance = this.findDistances();
        this.makeLeaves();
        this.noClus = this.cluster.size();
        this.cluster();
    }

    public void cluster() {
        while (this.noClus > 2) {
            if (this.type.equals("NJ")) {
                this.findMinNJDistance();
            } else {
                this.findMinDistance();
            }
            Cluster c = this.joinClusters(this.mini, this.minj);
            this.done[this.minj] = 1;
            this.cluster.setElementAt(null, this.minj);
            this.cluster.setElementAt(c, this.mini);
            --this.noClus;
        }
        boolean onefound = false;
        int one = -1;
        int two = -1;
        int i = 0;
        while (i < this.noseqs) {
            if (this.done[i] != 1) {
                if (!onefound) {
                    two = i;
                    onefound = true;
                } else {
                    one = i;
                }
            }
            ++i;
        }
        this.joinClusters(one, two);
        this.tf = new TreeFile((SequenceNode)this.node.elementAt(one));
    }

    public Cluster joinClusters(int i, int j) {
        float dist = this.distance[i][j];
        int noi = ((Cluster)this.cluster.elementAt((int)i)).value.length;
        int noj = ((Cluster)this.cluster.elementAt((int)j)).value.length;
        int[] value = new int[noi + noj];
        int ii = 0;
        while (ii < noi) {
            value[ii] = ((Cluster)this.cluster.elementAt((int)i)).value[ii];
            ++ii;
        }
        ii = noi;
        while (ii < noi + noj) {
            value[ii] = ((Cluster)this.cluster.elementAt((int)j)).value[ii - noi];
            ++ii;
        }
        Cluster c = new Cluster(value);
        this.ri = this.findr(i, j);
        this.rj = this.findr(j, i);
        if (this.type.equals("NJ")) {
            this.findClusterNJDistance(i, j);
        } else {
            this.findClusterDistance(i, j);
        }
        SequenceNode sn = new SequenceNode();
        sn.left = (SequenceNode)this.node.elementAt(i);
        sn.right = (SequenceNode)this.node.elementAt(j);
        SequenceNode tmpi = (SequenceNode)this.node.elementAt(i);
        SequenceNode tmpj = (SequenceNode)this.node.elementAt(j);
        if (this.type.equals("NJ")) {
            this.findNewNJDistances(tmpi, tmpj, dist);
        } else {
            this.findNewDistances(tmpi, tmpj, dist);
        }
        tmpi.parent = sn;
        tmpj.parent = sn;
        this.node.setElementAt(sn, i);
        return c;
    }

    public void findNewNJDistances(SequenceNode tmpi, SequenceNode tmpj, float dist) {
        tmpi.dist = (dist + this.ri - this.rj) / 2.0f;
        tmpj.dist = dist - tmpi.dist;
        if (tmpi.dist < 0.0f) {
            tmpi.dist = 0.0f;
        }
        if (tmpj.dist < 0.0f) {
            tmpj.dist = 0.0f;
        }
    }

    public void findNewDistances(SequenceNode tmpi, SequenceNode tmpj, float dist) {
        float ih = 0.0f;
        float jh = 0.0f;
        SequenceNode sni = tmpi;
        SequenceNode snj = tmpj;
        while (sni != null) {
            ih += sni.dist;
            sni = (SequenceNode)sni.left;
        }
        while (snj != null) {
            jh += snj.dist;
            snj = (SequenceNode)snj.left;
        }
        tmpi.dist = dist / 2.0f - ih;
        tmpj.dist = dist / 2.0f - jh;
    }

    public void findClusterDistance(int i, int j) {
        int noi = ((Cluster)this.cluster.elementAt((int)i)).value.length;
        int noj = ((Cluster)this.cluster.elementAt((int)j)).value.length;
        float[] newdist = new float[this.noseqs];
        int l = 0;
        while (l < this.noseqs) {
            newdist[l] = l != i && l != j ? (this.distance[i][l] * (float)noi + this.distance[j][l] * (float)noj) / (float)(noi + noj) : 0.0f;
            ++l;
        }
        int ii = 0;
        while (ii < this.noseqs) {
            this.distance[i][ii] = newdist[ii];
            this.distance[ii][i] = newdist[ii];
            ++ii;
        }
    }

    public void findClusterNJDistance(int i, int j) {
        int cfr_ignored_0 = ((Cluster)this.cluster.elementAt((int)i)).value.length;
        int cfr_ignored_1 = ((Cluster)this.cluster.elementAt((int)j)).value.length;
        float[] newdist = new float[this.noseqs];
        int l = 0;
        while (l < this.noseqs) {
            newdist[l] = l != i && l != j ? (this.distance[i][l] + this.distance[j][l] - this.distance[i][j]) / 2.0f : 0.0f;
            ++l;
        }
        int ii = 0;
        while (ii < this.noseqs) {
            this.distance[i][ii] = newdist[ii];
            this.distance[ii][i] = newdist[ii];
            ++ii;
        }
    }

    public float findr(int i, int j) {
        float tmp = 1.0f;
        int k = 0;
        while (k < this.noseqs) {
            if (k != i && k != j && this.done[k] != 1) {
                tmp += this.distance[i][k];
            }
            ++k;
        }
        if (this.noClus > 2) {
            tmp /= (float)(this.noClus - 2);
        }
        return tmp;
    }

    public float findMinNJDistance() {
        float min = 100000.0f;
        int i = 0;
        while (i < this.noseqs - 1) {
            int j = i + 1;
            while (j < this.noseqs) {
                float tmp;
                if (this.done[i] != 1 && this.done[j] != 1 && (tmp = this.distance[i][j] - (this.findr(i, j) + this.findr(j, i))) < min) {
                    this.mini = i;
                    this.minj = j;
                    min = tmp;
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public float findMinDistance() {
        float min = 100000.0f;
        int i = 0;
        while (i < this.noseqs - 1) {
            int j = i + 1;
            while (j < this.noseqs) {
                if (this.done[i] != 1 && this.done[j] != 1 && this.distance[i][j] < min) {
                    this.mini = i;
                    this.minj = j;
                    min = this.distance[i][j];
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public float[][] findDistances() {
        float[][] distance = new float[this.noseqs][this.noseqs];
        if (this.pwtype.equals("PID")) {
            int i = 0;
            while (i < this.noseqs - 1) {
                int j = i;
                while (j < this.noseqs) {
                    if (j == i) {
                        distance[i][i] = 0.0f;
                    } else {
                        distance[i][j] = 100.0f - Alignment.compare(this.sequence[i], this.sequence[j]);
                        distance[j][i] = distance[i][j];
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int j;
            float max = -1.0f;
            int i = 0;
            while (i < this.noseqs - 1) {
                j = i;
                while (j < this.noseqs) {
                    AlignSeq as = new AlignSeq(this.sequence[i], this.sequence[j], "pep");
                    as.calcScoreMatrix();
                    as.traceAlignment();
                    as.printAlignment();
                    distance[i][j] = as.maxscore;
                    if (max < distance[i][j]) {
                        max = distance[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.noseqs - 1) {
                j = i;
                while (j < this.noseqs) {
                    distance[i][j] = max - distance[i][j];
                    distance[j][i] = distance[i][j];
                    ++j;
                }
                ++i;
            }
        }
        return distance;
    }

    public void makeLeaves() {
        this.cluster = new Vector();
        int i = 0;
        while (i < this.noseqs) {
            SequenceNode sn = new SequenceNode();
            sn.element = this.sequence[i];
            this.node.addElement(sn);
            int[] value = new int[]{i++};
            Cluster c = new Cluster(value);
            this.cluster.addElement(c);
        }
    }

    public static void main(String[] args) {
        try {
            MSFfile msf = new MSFfile(args[0], "File");
            Sequence[] s = new Sequence[msf.seqs.size()];
            int i = 0;
            while (i < msf.seqs.size()) {
                s[i] = (Sequence)msf.seqs.elementAt(i);
                ++i;
            }
            NJTree njt = new NJTree(s, args[1], args[2]);
            Frame f = new Frame();
            f.setLayout(new BorderLayout());
            Panel p = new Panel();
            p.setLayout(new BorderLayout());
            MyCanvas mc = new MyCanvas(njt.tf);
            p.add("Center", mc);
            f.resize(600, 600);
            f.add("Center", p);
            f.show();
            njt.tf.reCount(njt.tf.top);
            njt.tf.findHeight(njt.tf.top);
            njt.tf.printNode(njt.tf.top);
            njt.tf.draw(p.getGraphics(), 500, 500);
            njt.tf.groupNodes(njt.tf.top, Float.valueOf(args[3]).floatValue());
        }
        catch (IOException e) {
            System.out.println("Exception : " + e);
        }
    }
}

