/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.ResidueProperties;
import java.awt.Color;
import java.util.Hashtable;

public class PIDColourScheme
extends ResidueColourScheme {
    public Color[] pidColours;
    public float[] thresholds;

    public PIDColourScheme() {
        this(null);
    }

    public PIDColourScheme(Hashtable[] cons) {
        this.cons = cons;
        this.pidColours = ResidueProperties.pidColours;
        this.thresholds = ResidueProperties.pidThresholds;
    }

    public void setColours(DrawableSequence seq2, int j) {
        Color c = Color.white;
        String s = seq2.getSequence().substring(j, j + 1);
        if (this.cons != null && j < this.cons.length) {
            c = this.findColour(seq2, s, j);
        }
        seq2.setResidueBoxColour(j, c);
    }

    public Color findColour(DrawableSequence seq2, String s, int j) {
        Color c = Color.white;
        String cfr_ignored_0 = (String)this.cons[j].get("max");
        double sc = 0.0;
        if (this.cons[j].contains(s)) {
            sc = ((Double)this.cons[j].get(s)).floatValue();
            if (!(s.equals("-") || s.equals(".") || s.equals(" "))) {
                int i = 0;
                while (i < this.thresholds.length) {
                    if (sc > (double)this.thresholds[i]) {
                        c = this.pidColours[i];
                        break;
                    }
                    ++i;
                }
            } else {
                c = Color.white;
            }
        }
        return c;
    }
}

