/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.AlignmentPanel;
import jalview.FileParse;
import jalview.Format;
import jalview.PostalColourScheme;
import jalview.Sequence;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PostalFile
extends FileParse {
    Vector scores = new Vector();
    Vector seqs = new Vector();

    public PostalFile(String inStr) {
        this.readLines(inStr);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public PostalFile(String inFile, String type) throws IOException {
        super(inFile, type);
        System.out.print("Reading file....");
        this.readLines();
        System.out.println("done");
        System.out.println("Parsing file....");
        this.parse();
    }

    public void parse() {
        int i = 0;
        i = 0;
        while (i < this.noLines) {
            String tmp = this.lineArray.elementAt(i).toString();
            if (tmp.indexOf(" ") != 0) {
                String id;
                StringTokenizer str = new StringTokenizer(tmp.toString(), " ");
                if (tmp.indexOf("#") == 0) {
                    id = "";
                    if (str.countTokens() == 3) {
                        id = str.nextToken();
                        id = str.nextToken();
                        if (id.indexOf("_acc") >= 0) {
                            id = id.substring(0, id.indexOf("_acc"));
                        }
                        if (!id.equals("Consensus")) {
                            String sc = str.nextToken();
                            char[] ch = sc.toCharArray();
                            Vector<Double> sco = new Vector<Double>();
                            int j = 0;
                            while (j < ch.length) {
                                if (ch[j] == '.') {
                                    sco.addElement(new Double(10.0));
                                } else {
                                    sco.addElement(new Double(Character.getNumericValue(ch[j])));
                                }
                                ++j;
                            }
                            this.scores.addElement(sco);
                        }
                    }
                } else if (tmp.indexOf(" ") != 0) {
                    StringTokenizer st;
                    id = str.nextToken();
                    int start = -1;
                    int end = -1;
                    if (id.indexOf("/") > 0 && (st = new StringTokenizer(id, "/")).countTokens() == 2) {
                        id = st.nextToken();
                        tmp = st.nextToken();
                        if ((st = new StringTokenizer(tmp, "-")).countTokens() == 2) {
                            start = Integer.valueOf(st.nextToken());
                            end = Integer.valueOf(st.nextToken());
                        } else {
                            start = -1;
                            end = -1;
                        }
                    }
                    String seq2 = str.nextToken();
                    if (start != -1 && end != -1) {
                        Sequence tmp2 = new Sequence(id, seq2, start, end);
                        this.seqs.addElement(tmp2);
                    } else {
                        Sequence tmp2 = new Sequence(id, seq2, 1, seq2.length());
                        this.seqs.addElement(tmp2);
                    }
                }
            }
            ++i;
        }
        this.addScores();
    }

    public static String print(Sequence[] s) {
        StringBuffer out = new StringBuffer("");
        int max = 0;
        int maxid = 0;
        int i = 0;
        while (i < s.length && s[i] != null) {
            String tmp = String.valueOf(s[i].getName()) + "/" + s[i].start + "-" + s[i].end;
            if (s[i].getSequence().length() > max) {
                max = s[i].getSequence().length();
            }
            if (tmp.length() > maxid) {
                maxid = tmp.length();
            }
            ++i;
        }
        if ((maxid += 5) < 15) {
            maxid = 15;
        }
        int j = 0;
        while (j < s.length && s[j] != null) {
            out.append(String.valueOf(new Format("%-" + maxid + "s").form(String.valueOf(s[j].getName()) + "/" + s[j].start + "-" + s[j].end)) + " ");
            out.append(String.valueOf(s[j].getSequence()) + "\n");
            out.append(String.valueOf(new Format("%-" + maxid + "s").form("#=GC " + s[j].getName() + "_acc")) + " ");
            int ii = 0;
            while (ii < s[j].score[0].size()) {
                if (((Double)s[j].score[0].elementAt(ii)).intValue() == 10) {
                    out.append(".");
                } else {
                    int t = ((Double)s[j].score[0].elementAt(ii)).intValue();
                    out.append(t);
                }
                ++ii;
            }
            out.append("\n");
            ++j;
        }
        return out.toString();
    }

    public void addScores() {
        System.out.println("Adding scores");
        int i = 0;
        while (i < this.seqs.size()) {
            Sequence ds = (Sequence)this.seqs.elementAt(i);
            if (i < this.scores.size() && ds != null && this.scores.elementAt(i) != null) {
                System.out.println("Adding scores for " + ds.name + " " + ((Vector)this.scores.elementAt(i)).size());
                ds.score[0] = (Vector)this.scores.elementAt(i);
            }
            ++i;
        }
    }

    public static void setColours(AlignmentPanel ap) {
        PostalColourScheme pcs = new PostalColourScheme();
        ap.setSequenceColor(pcs);
    }

    public static void main(String[] args) {
        AlignFrame af = new AlignFrame(null, args[0], "File", "POSTAL");
        af.resize(700, 500);
        af.show();
        try {
            PostalFile pf = new PostalFile(args[0], "File");
            PostalFile.setColours(af.ap);
            af.updateFont();
            af.updateFont();
        }
        catch (IOException iOException) {}
    }
}

