/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ScalePanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;

public class ScaleCanvas
extends Canvas {
    Image img;
    Graphics gg;
    int imgWidth;
    int imgHeight;
    Font f;
    int charWidth;
    int charHeight;
    protected ScalePanel scalePanel;
    boolean paintFlag = false;

    public ScaleCanvas(ScalePanel scalePanel) {
        this.scalePanel = scalePanel;
    }

    public void paint(Graphics g) {
        if (this.img == null || this.imgWidth != this.size().width || this.imgHeight != this.size().height || this.paintFlag) {
            this.imgWidth = this.size().width;
            this.imgHeight = this.size().height;
            this.img = this.createImage(this.imgWidth, this.imgHeight);
            this.gg = this.img.getGraphics();
            this.gg.setColor(Color.white);
            this.gg.fillRect(0, 0, this.imgWidth, this.imgHeight);
            this.f = this.scalePanel.alignPanel.seqPanel.seqCanvas.f;
            this.gg.setFont(this.f);
            FontMetrics fm = this.gg.getFontMetrics(this.f);
            if (this.scalePanel.alignPanel.seqPanel.fastDraw) {
                this.f = new Font("Courier", this.f.getStyle(), this.f.getSize());
                this.charWidth = fm.charWidth('W');
                this.charHeight = fm.getHeight();
            } else {
                this.charWidth = fm.charWidth('W') + 2;
                this.charHeight = fm.getHeight();
            }
            this.paintFlag = false;
        }
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.imgWidth, this.imgHeight);
        this.gg.setColor(Color.black);
        int startx = this.scalePanel.alignPanel.seqPanel.offx;
        int endx = startx + this.scalePanel.alignPanel.seqPanel.seqCanvas.size().width / this.charWidth;
        if (endx > this.scalePanel.alignPanel.seqPanel.align.maxLength) {
            startx = startx - endx + this.scalePanel.alignPanel.seqPanel.align.maxLength;
            endx = this.scalePanel.alignPanel.seqPanel.align.maxLength;
        }
        if (startx < 0) {
            startx = 0;
        }
        int scalestartx = startx - startx % 10 + 10;
        Enumeration e = this.scalePanel.alignPanel.selectedColumns.elements();
        while (e.hasMoreElements()) {
            int sel = (Integer)e.nextElement();
            if (sel < startx || sel > endx) continue;
            this.gg.setColor(Color.red);
            this.gg.fillRect(this.scalePanel.alignPanel.idPanel.idCanvas.idWidth + (sel - startx) * this.charWidth, 17 - this.charHeight, this.charWidth, this.charHeight);
        }
        this.gg.setColor(Color.black);
        int i = scalestartx;
        while (i < endx) {
            String string = String.valueOf(i);
            this.gg.drawString(string, this.scalePanel.alignPanel.idPanel.idCanvas.idWidth + (i - startx - 1) * this.charWidth, 15);
            i += 10;
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public Dimension minimumSize() {
        return new Dimension(500, 40);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }
}

