/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableAlignment;
import jalview.DrawableSequence;
import jalview.ScoreSequence;
import jalview.SeqPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class SeqCanvas
extends Canvas {
    DrawableAlignment da;
    Image img;
    Graphics gg;
    int imgWidth;
    int imgHeight;
    int fontStyle = 0;
    int fontSize = 10;
    String fontName = "Courier";
    public Font f = new Font(this.fontName, this.fontStyle, this.fontSize);
    int charWidth = 8;
    int charHeight = 8;
    public boolean showScores = true;
    int pady = 2;
    int oldstartx;
    int oldstarty;
    int oldendx;
    int oldendy;
    boolean paintFlag = false;
    boolean boxFlag = true;
    boolean textFlag = true;
    boolean colourText = false;
    int startx;
    int starty;
    int endx;
    int endy;
    Color lightBlue = new Color(175, 175, 255);
    Color midBlue = new Color(110, 110, 255);
    String colourFlag = "PID";
    boolean badResidues = false;
    boolean colourSelected = false;
    protected SeqPanel seqPanel;

    public SeqCanvas(SeqPanel seqPanel) {
        this.seqPanel = seqPanel;
        this.da = seqPanel.align;
    }

    public void setFont(Font f) {
        this.f = f;
        if (this.gg != null) {
            FontMetrics fm = this.gg.getFontMetrics(f);
            if (this.seqPanel.fastDraw) {
                this.f = new Font("Courier", f.getStyle(), f.getSize());
                this.charWidth = fm.charWidth('W');
                this.charHeight = this.setCharHeight(fm, this.showScores);
            } else {
                this.charWidth = fm.charWidth('W') + 2;
                this.charHeight = this.setCharHeight(fm, this.showScores);
            }
        }
    }

    public void paint(Graphics g) {
        int dely;
        int delx;
        if (this.img == null || this.imgWidth != this.size().width || this.imgHeight != this.size().height || this.paintFlag) {
            this.imgWidth = this.size().width;
            this.imgHeight = this.size().height;
            this.img = this.createImage(this.imgWidth, this.imgHeight);
            this.gg = this.img.getGraphics();
            this.gg.setFont(this.f);
            this.seqPanel.alignPanel.idPanel.idCanvas.f = this.f;
            this.seqPanel.alignPanel.scalePanel.scaleCanvas.f = this.f;
            FontMetrics fm = this.gg.getFontMetrics(this.f);
            this.charWidth = this.seqPanel.fastDraw ? fm.charWidth('W') : fm.charWidth('W') + 2;
            this.charHeight = this.setCharHeight(fm, this.showScores);
            this.seqPanel.setScrollValues(this.seqPanel.offx, this.seqPanel.offy);
            this.paintFlag = false;
            this.oldstartx = -1;
            this.oldendx = -1;
            this.oldstarty = -1;
            this.oldendy = -1;
        }
        this.startx = this.seqPanel.offx;
        this.starty = this.seqPanel.offy;
        this.endx = this.getEndx();
        this.endy = this.getEndy();
        if (this.endx > this.seqPanel.align.maxLength) {
            this.startx = this.startx - this.endx + this.seqPanel.align.maxLength;
            this.endx = this.seqPanel.align.maxLength;
        }
        if (this.starty < 0) {
            this.starty = 0;
        }
        if (this.startx < 0) {
            this.startx = 0;
        }
        long tstart = System.currentTimeMillis();
        if (this.oldendx == -1) {
            this.fillBackground(this.gg, Color.white, 0, 0, this.imgWidth, this.imgHeight);
            this.drawPanel(this.gg, this.startx, this.endx, this.starty, this.endy);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        } else if (this.oldstartx < this.startx) {
            delx = (this.startx - this.oldstartx) * this.charWidth;
            int delx2 = (this.oldendx - this.startx) * this.charWidth;
            this.gg.copyArea(delx, 0, delx2, this.da.getHeight(this.starty, this.endy), -delx, 0);
            this.drawPanel(this.gg, this.oldendx, this.endx, this.starty, this.endy);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
        } else if (this.oldstartx > this.startx) {
            delx = (this.oldstartx - this.startx) * this.charWidth;
            int delx2 = (this.endx - this.oldstartx) * this.charWidth;
            this.gg.copyArea(0, 0, delx2, this.da.getHeight(this.starty, this.endy), delx, 0);
            this.drawPanel(this.gg, this.startx, this.oldstartx, this.starty, this.endy);
            this.oldstartx = this.startx;
            this.oldendx = this.endx;
        } else if (this.oldstarty < this.starty) {
            dely = this.da.getHeight(this.oldstarty, this.starty);
            int dely2 = this.da.getHeight(this.starty, this.oldendy);
            this.gg.copyArea(0, dely, (this.endx - this.startx) * this.charWidth, dely2, 0, -dely);
            this.drawPanel(this.gg, this.startx, this.endx, this.oldendy, this.endy);
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        } else if (this.oldstarty > this.starty) {
            dely = this.da.getHeight(this.endy, this.oldendy);
            int dely2 = this.da.getHeight(this.oldstarty, this.endy);
            this.gg.copyArea(0, 0, (this.endx - this.startx) * this.charWidth, dely2, 0, dely);
            this.drawPanel(this.gg, this.startx, this.endx, this.starty, this.oldstarty);
            this.oldstarty = this.starty;
            this.oldendy = this.endy;
        }
        long tend = System.currentTimeMillis();
        if (this.seqPanel.alignPanel.parent instanceof AlignFrame) {
            ((AlignFrame)this.seqPanel.alignPanel.parent).redraw.setText("Redraw time = " + (tend - tstart) + " ms");
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public void drawPanel(Graphics g, int x1, int x2, int y1, int y2) {
        g.setFont(this.f);
        this.fillBackground(g, Color.white, (x1 - this.startx) * this.charWidth, this.da.getHeight(this.starty, y1), (x2 - x1) * this.charWidth, this.da.getHeight(y1, y2));
        int i = y1;
        while (i < y2) {
            ((DrawableSequence)this.seqPanel.align.sequences[i]).drawSequence(g, x1, x2, (x1 - this.startx) * this.charWidth, this.da.getHeight(this.starty, i), this.charWidth, this.da.ds[i].charHeight, this.showScores);
            ++i;
        }
    }

    public boolean keyDown(Event evt, int key) {
        return this.seqPanel.alignPanel.idPanel.keyDown(evt, key);
    }

    public int getEndy() {
        int h = 0;
        int i = this.starty;
        int tmp = this.starty;
        while (h < this.size().height && i < this.da.ds.length && this.da.ds[i] != null) {
            h += this.da.ds[i].charHeight;
            ++i;
        }
        if (h < this.size().height) {
            tmp = this.da.size;
            h = this.size().height;
            while (h > 0 && tmp > 0) {
                h -= this.da.ds[tmp - 1].charHeight;
                --tmp;
            }
            if (h <= 0) {
                ++tmp;
            }
        } else {
            --i;
        }
        this.endy = this.starty + this.size().height / this.charHeight;
        if (this.endy >= this.seqPanel.align.size) {
            this.starty = this.starty - this.endy + this.seqPanel.align.size;
            this.endy = this.seqPanel.align.size;
        }
        if (this.starty < 0) {
            this.starty = 0;
        }
        this.starty = tmp;
        if (this.starty < 0) {
            this.starty = 0;
        }
        return i;
    }

    public int getEndx() {
        return this.startx + this.size().width / this.charWidth;
    }

    public int setCharHeight(FontMetrics fm, boolean showScores) {
        int height = fm.getHeight();
        if (this.seqPanel.align instanceof DrawableAlignment) {
            DrawableAlignment da = this.seqPanel.align;
            int i = 0;
            while (i < da.ds.length && da.ds[i] != null) {
                da.ds[i].charHeight = da.ds[i] instanceof ScoreSequence ? height * 3 : (showScores ? height * 2 : height);
                ++i;
            }
        }
        if (showScores) {
            return fm.getHeight() * 2;
        }
        return fm.getHeight();
    }

    public void fillBackground(Graphics g, Color c, int x1, int y1, int width, int height) {
        g.setColor(c);
        g.fillRect(x1, y1, width, height);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void setFont(int style, int size) {
        this.fontStyle = style;
        this.fontSize = size;
        this.f = new Font(this.fontName, this.fontStyle, this.fontSize);
        this.setFont(this.f);
    }

    public int getIndex(int y) {
        int y1 = 0;
        int i = this.starty;
        while (i <= this.endy) {
            int y2;
            if (i < this.da.ds.length && this.da.ds[i] != null) {
                y2 = y1 + this.da.ds[i].charHeight;
                if (y >= y1 && y <= y2) {
                    return i;
                }
            } else {
                return -1;
            }
            y1 = y2;
            ++i;
        }
        return -1;
    }
}

