/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.FileParse;
import jalview.Sequence;
import jalview.SequenceFeature;
import jalview.SimpleBrowser;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SwissprotFile
extends FileParse {
    String title;
    String id = "";
    String acc;
    Sequence sequence;
    Vector features;
    int length;
    Vector pdbcode = new Vector();

    public SwissprotFile(String inStr) {
        this.features = new Vector();
        this.readLines(inStr);
        this.parse();
    }

    public SwissprotFile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.features = new Vector();
        this.readLines();
        this.parse();
    }

    public void parse() {
        int start = -1;
        int end = -1;
        int i = 0;
        while (i < this.noLines) {
            if (this.lineArray.elementAt(i).toString().indexOf(" ") != 0) {
                String tmp;
                StringTokenizer str = new StringTokenizer(this.lineArray.elementAt(i).toString(), " ");
                String type = str.nextToken();
                if (type.equals("<PRE>ID")) {
                    this.id = str.nextToken();
                } else if (type.equals("AC")) {
                    this.acc = str.nextToken();
                    if (this.acc.indexOf(";") != -1) {
                        this.acc = this.acc.substring(0, this.acc.indexOf(";"));
                    }
                } else if (type.equals("DE")) {
                    this.title = str.nextToken();
                    ++i;
                    while (this.lineArray.elementAt(i).toString().indexOf(" ") == 0) {
                        this.title = String.valueOf(this.title) + this.lineArray.elementAt(i).toString();
                        ++i;
                    }
                } else if (type.equals("SQ")) {
                    tmp = str.nextToken();
                    tmp = str.nextToken();
                    this.length = Integer.valueOf(tmp);
                    ++i;
                    String seq2 = "";
                    while (this.lineArray.elementAt(i).toString().indexOf(" ") == 0) {
                        seq2 = String.valueOf(seq2) + this.lineArray.elementAt(i).toString();
                        ++i;
                    }
                    String seq22 = "";
                    StringTokenizer str2 = new StringTokenizer(seq2, " ");
                    while (str2.hasMoreTokens()) {
                        seq22 = String.valueOf(seq22) + str2.nextToken();
                    }
                    this.sequence = start != -1 ? new Sequence(this.id, seq22, start, end) : new Sequence(this.id, seq22, 1, this.length);
                    this.sequence.features = new Vector();
                    int j = 0;
                    while (j < this.features.size()) {
                        this.sequence.features.addElement(this.features.elementAt(j));
                        ((SequenceFeature)this.features.elementAt((int)j)).sequence = this.sequence;
                        ++j;
                    }
                } else if (type.equals("FT") && !this.lineArray.elementAt(i).toString().substring(6, 7).equals(" ")) {
                    String ftype = str.nextToken();
                    try {
                        int fstart = Integer.valueOf(str.nextToken());
                        int fend = Integer.valueOf(str.nextToken());
                        String def = "";
                        while (str.hasMoreTokens()) {
                            def = String.valueOf(def) + str.nextToken() + " ";
                        }
                        if (!ftype.equals("REPEAT")) {
                            this.features.addElement(new SequenceFeature(null, ftype, fstart, fend, def));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Exception : " + e);
                    }
                } else if (type.equals("DR")) {
                    tmp = SimpleBrowser.parse(this.lineArray.elementAt(i).toString());
                    StringTokenizer str2 = new StringTokenizer(tmp);
                    String dtype = str2.nextToken();
                    dtype = str2.nextToken();
                    if (dtype.indexOf(";") == dtype.length() - 1) {
                        dtype = dtype.substring(0, dtype.indexOf(";"));
                    }
                    if (dtype.equals("PDB")) {
                        String code = str2.nextToken();
                        if (code.indexOf(";") == code.length() - 1) {
                            code = code.substring(0, code.indexOf(";"));
                        }
                        System.out.println("Found pdb code " + code);
                        this.pdbcode.addElement(code);
                    }
                }
            }
            ++i;
        }
    }

    public void print() {
        System.out.println("ID = " + this.id);
        System.out.println("ACC = " + this.acc);
        System.out.println("length = " + this.length);
        System.out.println("SEQ = " + this.sequence.getSequence());
        int j = 0;
        while (j < this.features.size()) {
            SequenceFeature sf = (SequenceFeature)this.features.elementAt(j);
            System.out.println(String.valueOf(sf.type) + " " + sf.start + " " + sf.end + " " + sf.description);
            ++j;
        }
    }

    public static void main(String[] args) {
        try {
            SwissprotFile sp = new SwissprotFile("http://srs.ebi.ac.uk:5000/srs5bin/cgi-bin/wgetz?-e+[swall-id:" + args[0] + "]", "URL");
            sp.print();
        }
        catch (IOException e) {
            System.out.println("Exception " + e);
        }
    }
}

