/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.jazzlib.CRC32;
import net.sf.jazzlib.Deflater;
import net.sf.jazzlib.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, 4096);
    }

    public GZIPOutputStream(OutputStream out, int size) throws IOException {
        super(out, new Deflater(-1, true), size);
        int mod_time = (int)(System.currentTimeMillis() / 1000L);
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        byArray[4] = (byte)mod_time;
        byArray[5] = (byte)(mod_time >> 8);
        byArray[6] = (byte)(mod_time >> 16);
        byArray[7] = (byte)(mod_time >> 24);
        byArray[9] = -1;
        byte[] gzipHeader = byArray;
        out.write(gzipHeader);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        super.finish();
        int totalin = this.def.getTotalIn();
        int crcval = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
        byte[] gzipFooter = new byte[]{(byte)crcval, (byte)(crcval >> 8), (byte)(crcval >> 16), (byte)(crcval >> 24), (byte)totalin, (byte)(totalin >> 8), (byte)(totalin >> 16), (byte)(totalin >> 24)};
        this.out.write(gzipFooter);
    }
}

