/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import net.sf.jazzlib.DataFormatException;
import net.sf.jazzlib.InflaterHuffmanTree;
import net.sf.jazzlib.StreamManipulator;

class InflaterDynHeader {
    private static final int LNUM = 0;
    private static final int DNUM = 1;
    private static final int BLNUM = 2;
    private static final int BLLENS = 3;
    private static final int LENS = 4;
    private static final int REPS = 5;
    private static final int[] repMin = new int[]{3, 3, 11};
    private static final int[] repBits = new int[]{2, 3, 7};
    private byte[] blLens;
    private byte[] litdistLens;
    private InflaterHuffmanTree blTree;
    private int mode;
    private int lnum;
    private int dnum;
    private int blnum;
    private int num;
    private int repSymbol;
    private byte lastLen;
    private int ptr;
    private static final int[] BL_ORDER;

    static {
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        BL_ORDER = nArray;
    }

    /*
     * Unable to fully structure code
     */
    public boolean decode(StreamManipulator input) throws DataFormatException {
        while (true) {
            switch (this.mode) {
                case 0: {
                    this.lnum = input.peekBits(5);
                    if (this.lnum < 0) {
                        return false;
                    }
                    this.lnum += 257;
                    input.dropBits(5);
                    this.mode = 1;
                }
                case 1: {
                    this.dnum = input.peekBits(5);
                    if (this.dnum < 0) {
                        return false;
                    }
                    ++this.dnum;
                    input.dropBits(5);
                    this.num = this.lnum + this.dnum;
                    this.litdistLens = new byte[this.num];
                    this.mode = 2;
                }
                case 2: {
                    this.blnum = input.peekBits(4);
                    if (this.blnum < 0) {
                        return false;
                    }
                    this.blnum += 4;
                    input.dropBits(4);
                    this.blLens = new byte[19];
                    this.ptr = 0;
                    this.mode = 3;
                }
                case 3: {
                    while (this.ptr < this.blnum) {
                        len = input.peekBits(3);
                        if (len < 0) {
                            return false;
                        }
                        input.dropBits(3);
                        this.blLens[InflaterDynHeader.BL_ORDER[this.ptr]] = (byte)len;
                        ++this.ptr;
                    }
                    this.blTree = new InflaterHuffmanTree(this.blLens);
                    this.blLens = null;
                    this.ptr = 0;
                    this.mode = 4;
                }
                case 4: {
                    while (((symbol = this.blTree.getSymbol(input)) & -16) == 0) {
                        this.litdistLens[this.ptr++] = this.lastLen = (byte)symbol;
                        if (this.ptr != this.num) continue;
                        return true;
                    }
                    if (symbol < 0) {
                        return false;
                    }
                    if (symbol >= 17) {
                        this.lastLen = 0;
                    } else if (this.ptr == 0) {
                        throw new DataFormatException();
                    }
                    this.repSymbol = symbol - 16;
                    this.mode = 5;
                }
                case 5: {
                    bits = InflaterDynHeader.repBits[this.repSymbol];
                    count = input.peekBits(bits);
                    if (count < 0) {
                        return false;
                    }
                    input.dropBits(bits);
                    if (this.ptr + (count += InflaterDynHeader.repMin[this.repSymbol]) <= this.num) ** GOTO lbl64
                    throw new DataFormatException();
lbl-1000:
                    // 1 sources

                    {
                        this.litdistLens[this.ptr++] = this.lastLen;
lbl64:
                        // 2 sources

                        ** while (count-- > 0)
                    }
lbl65:
                    // 1 sources

                    if (this.ptr == this.num) {
                        return true;
                    }
                    this.mode = 4;
                }
            }
        }
    }

    public InflaterHuffmanTree buildLitLenTree() throws DataFormatException {
        byte[] litlenLens = new byte[this.lnum];
        System.arraycopy(this.litdistLens, 0, litlenLens, 0, this.lnum);
        return new InflaterHuffmanTree(litlenLens);
    }

    public InflaterHuffmanTree buildDistTree() throws DataFormatException {
        byte[] distLens = new byte[this.dnum];
        System.arraycopy(this.litdistLens, this.lnum, distLens, 0, this.dnum);
        return new InflaterHuffmanTree(distLens);
    }
}

