/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import scigol.FuncInfo;
import scigol.Symbol;
import scigol.TypeSpec;

public class LValue {
    protected Symbol _symbol;
    protected boolean _isProperty;
    protected FuncInfo _propCallSig;
    protected Object[] _propArgs;

    public LValue(Symbol s) {
        this._isProperty = false;
        this._symbol = s;
    }

    public LValue(Symbol s, FuncInfo callSig, Object[] propArgs) {
        this._isProperty = true;
        this._propArgs = propArgs;
        this._propCallSig = callSig;
        this._symbol = s;
    }

    public boolean isBoundProperty() {
        return this._isProperty;
    }

    public Object getValue() {
        if (!this._isProperty) {
            return this._symbol.getValue();
        }
        if (this._propCallSig.numArgs() == 0) {
            return this._symbol.getValue();
        }
        return this._symbol.getValue(this._propCallSig, this._propArgs);
    }

    public void setValue(Object value) {
        if (!this._isProperty) {
            this._symbol.setValue(value);
        } else if (this._propCallSig.numArgs() == 0) {
            this._symbol.setValue(value);
        } else {
            this._symbol.setValue(this._propCallSig, this._propArgs, value);
        }
    }

    public TypeSpec getType() {
        if (!this._isProperty) {
            return this._symbol.getType();
        }
        if (this._propCallSig.numArgs() == 0) {
            return this._symbol.getType();
        }
        return this._symbol.getType(this._propCallSig, this._propArgs);
    }

    public Symbol getSymbol() {
        return this._symbol;
    }

    public String toString() {
        return this._symbol.toString();
    }
}

