/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import uk.ac.sanger.artemis.Action;
import uk.ac.sanger.artemis.ActionVector;
import uk.ac.sanger.artemis.ChangeEvent;
import uk.ac.sanger.artemis.ChangeEventVector;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.OutOfDateException;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class ActionController
implements EntryGroupChangeListener,
EntryChangeListener,
FeatureChangeListener,
SequenceChangeListener {
    private Action current_action = null;
    private ActionVector action_vector = new ActionVector();

    public void startAction() {
        if (Options.getOptions().getUndoLevels() == 0) {
            return;
        }
        if (this.current_action != null) {
            this.current_action = null;
            throw new Error("internal error - ActionController.startAction() called twice");
        }
        this.current_action = new Action();
    }

    public void endAction() {
        if (Options.getOptions().getUndoLevels() == 0) {
            return;
        }
        if (this.current_action == null) {
            throw new Error("internal error - in ActionController.endAction() no Action in progress");
        }
        if (!this.current_action.isEmpty()) {
            this.action_vector.add(this.current_action);
        }
        this.current_action = null;
    }

    private void discardUndo() {
        this.action_vector = new ActionVector();
    }

    public boolean canUndo() {
        return this.action_vector.size() != 0;
    }

    public boolean undo() {
        if (this.action_vector.size() == 0) {
            return false;
        }
        Action temp_current_action = this.current_action;
        this.current_action = null;
        try {
            Action last_action = this.action_vector.removeAndReturnLast();
            if (last_action.isEmpty()) {
                return false;
            }
            ChangeEventVector last_action_change_events = last_action.getChangeEvents();
            int i = last_action_change_events.size() - 1;
            while (i >= 0) {
                ChangeEvent this_event = last_action_change_events.elementAt(i);
                if (this_event instanceof FeatureChangeEvent) {
                    this.undoFeatureChange((FeatureChangeEvent)this_event);
                } else if (this_event instanceof EntryChangeEvent) {
                    this.undoEntryChange((EntryChangeEvent)this_event);
                } else {
                    throw new Error("internal error - unknown event type: " + this_event);
                }
                --i;
            }
            if (temp_current_action != null) {
                throw new Error("internal error - in ActionController.undo() Action in progress");
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    private void undoFeatureChange(FeatureChangeEvent event) {
        Feature feature = event.getFeature();
        try {
            if (feature.getEntry() != null) {
                feature.set(null, event.getOldKey(), event.getOldLocation(), event.getOldQualifiers());
            }
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfDateException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    private void undoEntryChange(EntryChangeEvent event) {
        try {
            if (event.getType() == 1) {
                event.getEntry().add(event.getFeature(), true);
            } else if (event.getType() == 2) {
                event.getFeature().removeFromEntry();
            }
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.discardUndo();
            }
        }
    }

    public void entryChanged(EntryChangeEvent event) {
        if (this.current_action != null) {
            this.current_action.addChangeEvent(event);
        }
    }

    public void featureChanged(FeatureChangeEvent event) {
        if (this.current_action != null) {
            this.current_action.addChangeEvent(event);
        }
    }

    public void sequenceChanged(SequenceChangeEvent event) {
        this.discardUndo();
    }
}

