/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.ExternalProgramException;
import uk.ac.sanger.artemis.ExternalProgramMonitor;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Logger;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.ProcessMonitor;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class ExternalProgram {
    public static final int AA_PROGRAM = 0;
    public static final int DNA_PROGRAM = 1;
    public static final int APPLICATION = 2;
    private static final String file_counter_filename = "file_number_counter";
    private String name;
    private String program_options;
    private int program_type;
    static /* synthetic */ Class class$0;

    public ExternalProgram(String name, String program_options, int program_type) {
        this.name = name;
        this.program_options = program_options;
        this.program_type = program_type;
    }

    public int getType() {
        return this.program_type;
    }

    public ExternalProgramMonitor run(FeatureVector features, Logger logger) throws IOException, ExternalProgramException, EntryInformationException, ReadOnlyException {
        StringVector sequence_file_names = new StringVector();
        File file_of_filenames = this.prepareRun(features, sequence_file_names);
        Options.getOptions().getIntegerProperty("jcon_" + this.getName() + "_program_id");
        Options.getOptions().getIntegerProperty("jcon_min_jobs");
        Options.getOptions().getProperty("jcon_" + this.getName() + "_template");
        Options.getOptions().getProperty("jcon_batch_queue");
        try {
            String[] arguments;
            switch (this.program_type) {
                case 0: 
                case 1: {
                    arguments = new String[]{file_of_filenames.getPath(), this.getProgramOptions()};
                    break;
                }
                case 2: {
                    arguments = new String[]{file_of_filenames.getPath()};
                    break;
                }
                default: {
                    throw new Error("internal error - unknown program type");
                }
            }
            Process process = ExternalProgram.startProgram("run_" + this.getRealName(), arguments);
            return new ProcessMonitor(process, this.getName(), logger);
        }
        catch (SecurityException e) {
            throw new ExternalProgramException("SecurityException while running " + this.getName() + ": " + e.getMessage());
        }
    }

    private File prepareRun(FeatureVector features, StringVector sequence_file_names) throws IOException, ExternalProgramException, EntryInformationException, ReadOnlyException {
        String new_qualifier_name = String.valueOf(this.getName()) + "_file";
        if (this.getType() != 2) {
            int i = 0;
            while (i < features.size()) {
                Feature this_feature = features.elementAt(i);
                if (this_feature.getEntry().isReadOnly()) {
                    throw new ReadOnlyException();
                }
                EntryInformation entry_information = this_feature.getEntry().getEntryInformation();
                if (!entry_information.isValidQualifier(this_feature.getKey(), new_qualifier_name)) {
                    String message = this_feature.getKey() + " cannot have " + new_qualifier_name + " as a qualifier";
                    throw new EntryInformationException(message);
                }
                ++i;
            }
        }
        if (features.size() == 0) {
            return null;
        }
        NumberFormat number_format = NumberFormat.getNumberInstance();
        number_format.setMaximumIntegerDigits(5);
        number_format.setMinimumIntegerDigits(5);
        number_format.setGroupingUsed(false);
        File first_directory = null;
        Hashtable<File, Long> feature_count_hash = new Hashtable<File, Long>();
        int i = 0;
        while (i < features.size()) {
            Feature this_feature = features.elementAt(i);
            Entry this_feature_entry = this_feature.getEntry();
            File base_directory = this.getBaseDirectoryFromEntry(this_feature_entry);
            if (base_directory == null) {
                base_directory = new File(".");
            }
            if (first_directory == null) {
                first_directory = base_directory;
            }
            if (feature_count_hash.containsKey(base_directory)) {
                long new_number = (Long)feature_count_hash.get(base_directory) + 1L;
                feature_count_hash.put(base_directory, new Long(new_number));
            } else {
                feature_count_hash.put(base_directory, new Long(1L));
            }
            ++i;
        }
        Hashtable<File, Long> file_number_hash = new Hashtable<File, Long>();
        Enumeration e = feature_count_hash.keys();
        while (e.hasMoreElements()) {
            File directory = (File)e.nextElement();
            long old_file_number = this.getFileNumber(directory);
            long feature_count = (Long)feature_count_hash.get(directory);
            file_number_hash.put(directory, new Long(old_file_number));
            this.setFileNumber(directory, old_file_number + feature_count);
        }
        int i2 = 0;
        while (i2 < features.size()) {
            Feature this_feature = features.elementAt(i2);
            Entry this_feature_entry = this_feature.getEntry();
            File base_directory = this.getBaseDirectoryFromEntry(this_feature_entry);
            if (base_directory == null) {
                base_directory = new File(".");
            }
            File program_directory = new File(base_directory, this.getName());
            this.makeDirectory(program_directory);
            String test_name = this_feature_entry.getName();
            String entry_name = test_name == null ? "no_name" : test_name;
            long old_file_number = (Long)file_number_hash.get(base_directory);
            file_number_hash.put(base_directory, new Long(old_file_number + 1L));
            String new_file_name = String.valueOf(this.getName()) + File.separatorChar + entry_name + ".seq." + number_format.format(old_file_number);
            String new_file_name_full = new File(base_directory, String.valueOf(File.separatorChar) + new_file_name).getPath();
            sequence_file_names.add(new_file_name_full);
            File write_file = new File(new_file_name_full);
            FileWriter writer = new FileWriter(write_file);
            switch (this.program_type) {
                case 1: {
                    this_feature.writeBasesOfFeature(writer);
                    break;
                }
                case 0: {
                    this_feature.writeAminoAcidsOfFeature(writer);
                    break;
                }
                case 2: {
                    this_feature.writeNative(writer);
                    break;
                }
                default: {
                    throw new Error("internal error - unknown program type");
                }
            }
            ((Writer)writer).close();
            if (this.program_type != 2) {
                Qualifier new_qualifier = new Qualifier(new_qualifier_name, String.valueOf(new_file_name) + ".out");
                this_feature.setQualifier(new_qualifier);
            }
            ++i2;
        }
        File file_of_filenames = new File(new File(first_directory, this.getName()), String.valueOf(this.getName()) + "_" + "file_of_filenames." + (this.getFileNumber(first_directory) - 1L));
        FileWriter filenames_writer = new FileWriter(file_of_filenames);
        PrintWriter filenames_printwriter = new PrintWriter(filenames_writer);
        int i3 = 0;
        while (i3 < sequence_file_names.size()) {
            filenames_printwriter.println(sequence_file_names.elementAt(i3));
            ++i3;
        }
        filenames_printwriter.close();
        ((Writer)filenames_writer).close();
        return file_of_filenames;
    }

    public String getName() {
        return this.name;
    }

    public static Process startProgram(String name, String[] arguments) throws SecurityException, ExternalProgramException, IOException {
        String[] sh_arguments;
        InputStream code_stream = ExternalProgram.class.getResourceAsStream(name);
        if (code_stream == null) {
            code_stream = ExternalProgram.class.getResourceAsStream("/etc/" + name);
        }
        if (code_stream == null) {
            String[] real_arguments;
            if (arguments == null) {
                real_arguments = new String[1];
            } else {
                real_arguments = new String[arguments.length + 1];
                int i = 0;
                while (i < arguments.length) {
                    real_arguments[i + 1] = arguments[i];
                    ++i;
                }
            }
            real_arguments[0] = name;
            return Runtime.getRuntime().exec(real_arguments);
        }
        if (arguments == null) {
            sh_arguments = new String[2];
        } else {
            sh_arguments = new String[arguments.length + 2];
            int i = 0;
            while (i < arguments.length) {
                sh_arguments[i + 2] = arguments[i];
                ++i;
            }
        }
        sh_arguments[0] = "/bin/sh";
        sh_arguments[1] = "-s";
        Process process = Runtime.getRuntime().exec(sh_arguments);
        OutputStream out_stream = process.getOutputStream();
        byte[] buffer = new byte[10000];
        int read_size = 0;
        while ((read_size = code_stream.read(buffer)) != -1) {
            out_stream.write(buffer, 0, read_size);
        }
        code_stream.close();
        out_stream.close();
        return process;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getFileNumber(File directory) throws IOException {
        try {
            FileReader file_reader = new FileReader(new File(directory, String.valueOf(File.separatorChar) + this.getName() + File.separatorChar + file_counter_filename));
            BufferedReader reader = new BufferedReader(file_reader);
            String comment_line = reader.readLine();
            if (comment_line == null || comment_line.length() == 0) {
                return this.setFileNumber(directory, this.guessNumber(directory));
            }
            if (!comment_line.startsWith("#")) {
                return this.setFileNumber(directory, this.guessNumber(directory));
            }
            String number_line = reader.readLine();
            try {
                try {
                    long l = Integer.parseInt(number_line);
                    file_reader.close();
                    reader.close();
                    return l;
                }
                catch (NumberFormatException numberFormatException) {
                    long l = this.setFileNumber(directory, this.guessNumber(directory));
                    file_reader.close();
                    reader.close();
                    return l;
                }
            }
            catch (Throwable throwable) {
                file_reader.close();
                reader.close();
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.setFileNumber(directory, this.guessNumber(directory));
        }
        catch (IOException iOException) {
            return this.setFileNumber(directory, this.guessNumber(directory));
        }
    }

    protected long setFileNumber(File directory, long new_file_number) throws IOException {
        this.makeDirectory(new File(directory, this.getName()));
        FileWriter file_writer = new FileWriter(new File(directory, String.valueOf(File.separatorChar) + this.getName() + File.separatorChar + file_counter_filename));
        PrintWriter print_writer = new PrintWriter(file_writer);
        print_writer.println("# the file is machine generated - do not edit");
        print_writer.println(new_file_number);
        print_writer.close();
        file_writer.close();
        return new_file_number;
    }

    protected void makeDirectory(File directory) throws IOException {
        if (directory.exists()) {
            if (directory.isDirectory()) {
                if (directory.canWrite()) {
                    return;
                }
                throw new IOException("Cannot write to: " + directory.getAbsolutePath());
            }
            throw new IOException(String.valueOf(directory.getAbsolutePath()) + " is not a directory");
        }
        directory.mkdirs();
    }

    private long guessNumber(File directory) {
        try {
            long biggest_so_far = -1L;
            String[] file_names = new File(directory, this.getName()).list();
            if (file_names == null) {
                return 1L;
            }
            int i = 0;
            while (i < file_names.length) {
                int last_dot = file_names[i].lastIndexOf(46);
                String number_string = last_dot == -1 ? file_names[i] : file_names[i].substring(last_dot + 1);
                try {
                    long number = Long.parseLong(number_string);
                    if (number > biggest_so_far) {
                        biggest_so_far = number;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
            if (biggest_so_far == -1L) {
                return 1L;
            }
            return biggest_so_far;
        }
        catch (SecurityException securityException) {
            return 0L;
        }
    }

    public String getProgramOptions() {
        if (this.program_options.equals("-")) {
            return "";
        }
        return this.program_options;
    }

    public void setProgramOptions(String program_options) {
        this.program_options = program_options;
    }

    private String getRealName() {
        int plus_index = this.getName().indexOf(43);
        if (plus_index > 0) {
            return this.getName().substring(0, plus_index);
        }
        return this.getName();
    }

    private File getBaseDirectoryFromEntry(Entry entry) {
        FileDocument file_document;
        DocumentEntry document_entry;
        uk.ac.sanger.artemis.io.Entry embl_entry = entry.getEMBLEntry();
        if (embl_entry instanceof DocumentEntry && (document_entry = (DocumentEntry)embl_entry).getDocument() instanceof FileDocument && (file_document = (FileDocument)document_entry.getDocument()).getFile().getParent() != null) {
            return new File(file_document.getFile().getParent());
        }
        return null;
    }
}

