/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.IOException;
import java.util.StringTokenizer;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.ComparisonDataParseException;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class SSAHAComparisonData
extends SimpleComparisonData {
    public SSAHAComparisonData(LinePushBackReader stream) throws IOException {
        super(stream);
    }

    public SSAHAComparisonData() {
    }

    protected SimpleComparisonData getNewSimpleComparisonData() {
        return new SSAHAComparisonData();
    }

    public static AlignMatch makeMatchFromStringStatic(String line) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
        if (tokenizer.countTokens() != 9) {
            String message = "while reading SSAHA data: not enough fields in this line: " + line;
            throw new ComparisonDataParseException(message);
        }
        String direction_token = tokenizer.nextToken();
        tokenizer.nextToken();
        String q_start_token = tokenizer.nextToken();
        String q_end_token = tokenizer.nextToken();
        tokenizer.nextToken();
        String s_start_token = tokenizer.nextToken();
        String s_end_token = tokenizer.nextToken();
        String score_token = tokenizer.nextToken();
        String percent_ident_token = tokenizer.nextToken();
        try {
            int score = Integer.valueOf(score_token);
            int percent_ident = (int)Float.valueOf(percent_ident_token).floatValue();
            int q_start = Integer.valueOf(q_start_token);
            int q_end = Integer.valueOf(q_end_token);
            int s_start = Integer.valueOf(s_start_token);
            int s_end = Integer.valueOf(s_end_token);
            if (direction_token.equals("F")) {
                return SimpleComparisonData.makeAlignMatch(s_start, s_end, q_start, q_end, score, percent_ident);
            }
            return SimpleComparisonData.makeAlignMatch(s_start, s_end, q_end, q_start, score, percent_ident);
        }
        catch (NumberFormatException e) {
            throw new IOException("while reading SSAHA data: failed to parse a number from this string: " + e.getMessage());
        }
    }

    protected AlignMatch makeMatchFromString(String line) throws IOException {
        return SSAHAComparisonData.makeMatchFromStringStatic(line);
    }

    public static boolean formatCorrect(String line) {
        try {
            SSAHAComparisonData.makeMatchFromStringStatic(line);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

