/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import uk.ac.sanger.artemis.ChangeEvent;
import uk.ac.sanger.artemis.ChangeListener;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.GotoListener;
import uk.ac.sanger.artemis.OptionChangeEvent;
import uk.ac.sanger.artemis.OptionChangeListener;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selectable;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.DisplayAdjustmentListener;
import uk.ac.sanger.artemis.components.DisplayComponent;
import uk.ac.sanger.artemis.components.EntryGroupPanel;
import uk.ac.sanger.artemis.components.FeatureEdit;
import uk.ac.sanger.artemis.components.FeaturePopup;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.StringVector;

public class FeatureDisplay
extends EntryGroupPanel
implements EntryGroupChangeListener,
EntryChangeListener,
FeatureChangeListener,
SelectionChangeListener,
GotoListener,
SequenceChangeListener,
DisplayComponent,
OptionChangeListener,
DisplayAdjustmentListener {
    public static final int ZOOM_TO_SELECTION_KEY = 90;
    public static final int SCROLLBAR_AT_TOP = 1;
    public static final int SCROLLBAR_AT_BOTTOM = 2;
    public static final int NO_SCROLLBAR = 3;
    public static final int FORWARD = 1;
    public static final int REVERSE = 2;
    public static final int NO_FRAME = -1;
    public static final int FORWARD_STRAND = 3;
    public static final int REVERSE_STRAND = 4;
    public static final int FORWARD_FRAME_1 = 0;
    public static final int FORWARD_FRAME_2 = 1;
    public static final int FORWARD_FRAME_3 = 2;
    public static final int REVERSE_FRAME_3 = 5;
    public static final int REVERSE_FRAME_2 = 6;
    public static final int REVERSE_FRAME_1 = 7;
    public static final int SCALE_LINE = 8;
    private JScrollBar scrollbar = null;
    private JScrollBar scale_changer = null;
    private Color light_grey = new Color(240, 240, 240);
    private Color not_so_light_grey = new Color(200, 200, 200);
    private Color active_entry_colour = new Color(255, 255, 140);
    private FeatureVector visible_features = new FeatureVector();
    private boolean update_visible_features = true;
    private final Vector adjustment_listener_list = new Vector();
    private int left_edge_base = 1;
    private int scale_factor = 3;
    private float scale_value = 1.0f;
    private boolean show_labels = true;
    private boolean show_forward_lines = true;
    private boolean show_reverse_lines = true;
    private boolean rev_comp_display = false;
    private boolean one_line_per_entry = false;
    private boolean hard_left_edge = true;
    private boolean show_source_features = false;
    private boolean show_stop_codons = true;
    private boolean show_start_codons = false;
    private boolean show_feature_arrows;
    private boolean show_feature_borders;
    private boolean show_base_colours = false;
    private boolean frame_features_flag = false;
    private MarkerRange click_range = null;
    private Marker click_segment_marker = null;
    private boolean click_segment_marker_is_start_marker = false;
    private Marker other_end_of_segment_marker = null;
    private int current_min_score = 0;
    private int current_max_score = 100;
    private MouseEvent last_mouse_press_event;
    private boolean disable_display_events = false;
    private boolean raise_selection_flag = false;
    private static final int MINIMUM_LABEL_SPACING = 80;
    private static Color dark_green = new Color(0, 150, 0);
    private final char[] draw_one_char_temp_array = new char[1];
    private static final Comparator feature_comparator = new Comparator(){

        public int compare(Object feature1_object, Object feature2_object) {
            int feature2_size;
            Feature feature1 = (Feature)feature1_object;
            Feature feature2 = (Feature)feature2_object;
            int feature1_size = feature1.getBaseCount();
            if (feature1_size > (feature2_size = feature2.getBaseCount())) {
                return -1;
            }
            if (feature1_size < feature2_size) {
                return 1;
            }
            if (feature1.hashCode() < feature2.hashCode()) {
                return -1;
            }
            if (feature1.hashCode() == feature2.hashCode()) {
                return 0;
            }
            return 1;
        }
    };

    public FeatureDisplay(EntryGroup entry_group, Selection selection, GotoEventSource goto_event_source, BasePlotGroup base_plot_group) {
        this(entry_group, selection, goto_event_source, base_plot_group, 2);
    }

    public FeatureDisplay(EntryGroup entry_group, Selection selection, GotoEventSource goto_event_source, BasePlotGroup base_plot_group, int scrollbar_style) {
        super(entry_group, selection, goto_event_source, base_plot_group);
        this.show_feature_arrows = Options.getOptions().getPropertyTruthValue("draw_feature_arrows");
        this.show_feature_borders = Options.getOptions().getPropertyTruthValue("draw_feature_borders");
        this.frame_features_flag = Options.getOptions().getPropertyTruthValue("features_on_frame_lines");
        this.one_line_per_entry = Options.getOptions().getPropertyTruthValue("one_line_per_entry");
        this.show_labels = Options.getOptions().getPropertyTruthValue("feature_labels");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FeatureDisplay.this.fixScrollbar();
                FeatureDisplay.this.needVisibleFeatureVectorUpdate();
                FeatureDisplay.this.fireAdjustmentEvent(3);
            }

            public void componentShown(ComponentEvent e) {
                FeatureDisplay.this.fixScrollbar();
                FeatureDisplay.this.needVisibleFeatureVectorUpdate();
                FeatureDisplay.this.fireAdjustmentEvent(3);
            }
        });
        this.setScaleValue();
        if (scrollbar_style == 1) {
            this.createScrollbar(true);
        } else if (scrollbar_style == 2) {
            this.createScrollbar(false);
        }
        this.createScaleScrollbar();
        this.fixCanvasSize();
        this.fixScrollbar();
        this.addListeners();
        this.needVisibleFeatureVectorUpdate();
        this.fireAdjustmentEvent(3);
        this.getSelection().addSelectionChangeListener(this);
        this.getGotoEventSource().addGotoListener(this);
        this.getEntryGroup().addEntryGroupChangeListener(this);
        this.getEntryGroup().addEntryChangeListener(this);
        this.getEntryGroup().addFeatureChangeListener(this);
        this.getBases().addSequenceChangeListener(this, -5);
        Options.getOptions().addOptionChangeListener(this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fixCanvasSize();
    }

    public void setShowLabels(boolean show_labels) {
        if (this.show_labels != show_labels) {
            this.show_labels = show_labels;
            this.fixCanvasSize();
        }
    }

    public boolean getShowLabels() {
        return this.show_labels;
    }

    public void setShowForwardFrameLines(boolean show_forward_lines) {
        if (this.show_forward_lines != show_forward_lines) {
            this.show_forward_lines = show_forward_lines;
            this.fixCanvasSize();
        }
    }

    public boolean getShowForwardFrameLines() {
        return this.show_forward_lines;
    }

    public void setShowReverseFrameLines(boolean show_reverse_lines) {
        if (this.show_reverse_lines != show_reverse_lines) {
            this.show_reverse_lines = show_reverse_lines;
            this.fixCanvasSize();
        }
    }

    public boolean getShowSourceFeatures() {
        return this.show_source_features;
    }

    public void setShowSourceFeatures(boolean show_source_features) {
        if (this.show_source_features != show_source_features) {
            this.show_source_features = show_source_features;
            this.needVisibleFeatureVectorUpdate();
            this.repaint();
        }
    }

    public boolean getShowReverseFrameLines() {
        return this.show_reverse_lines;
    }

    public void setShowBaseColours(boolean show_base_colours) {
        if (this.show_base_colours != show_base_colours) {
            this.show_base_colours = show_base_colours;
            if (this.getScaleFactor() > 1) {
                this.setScaleFactor(1);
            }
            this.repaint();
        }
    }

    public boolean getShowBaseColours() {
        return this.show_base_colours;
    }

    public void setOneLinePerEntry(boolean one_line_per_entry) {
        if (this.one_line_per_entry != one_line_per_entry) {
            this.one_line_per_entry = one_line_per_entry;
            this.fixCanvasSize();
        }
    }

    public boolean getOneLinePerEntryFlag() {
        return this.one_line_per_entry;
    }

    public void setHardLeftEdge(boolean hard_left_edge) {
        if (this.hard_left_edge != hard_left_edge) {
            this.hard_left_edge = hard_left_edge;
            if (hard_left_edge && this.getForwardBaseAtLeftEdge() < 1) {
                this.setFirstVisibleForwardBase(1);
            }
            this.fixScrollbar();
        }
    }

    public boolean getHardLeftEdgeFlag() {
        return this.hard_left_edge;
    }

    public void setShowStopCodons(boolean show_stop_codons) {
        if (this.show_stop_codons != show_stop_codons) {
            this.show_stop_codons = show_stop_codons;
            this.getCanvas().repaint();
        }
    }

    public boolean getShowStopCodons() {
        return this.show_stop_codons;
    }

    public void setShowStartCodons(boolean show_start_codons) {
        if (this.show_start_codons != show_start_codons) {
            this.show_start_codons = show_start_codons;
            this.getCanvas().repaint();
        }
    }

    public boolean getShowStartCodons() {
        return this.show_start_codons;
    }

    public void setRevCompDisplay(boolean rev_comp_display) {
        if (this.rev_comp_display != rev_comp_display) {
            Marker last_base_marker;
            this.rev_comp_display = rev_comp_display;
            int remember_position = this.getCentreForwardBase();
            Marker first_base_marker = this.getSelection().getStartBaseOfSelection();
            if (first_base_marker != null && this.baseVisible(first_base_marker)) {
                remember_position = first_base_marker.getRawPosition();
            }
            if ((last_base_marker = this.getSelection().getStartBaseOfSelection()) != null && this.baseVisible(last_base_marker)) {
                remember_position = last_base_marker.getRawPosition();
            }
            this.fireAdjustmentEvent(2);
            this.makeBaseVisibleInternal(remember_position, this.isRevCompDisplay(), true);
            this.needVisibleFeatureVectorUpdate();
            this.fixScrollbar();
            this.getCanvas().repaint();
        }
    }

    public boolean isRevCompDisplay() {
        return this.rev_comp_display;
    }

    public void setShowFeatureArrows(boolean show_feature_arrows) {
        if (this.show_feature_arrows != show_feature_arrows) {
            this.show_feature_arrows = show_feature_arrows;
            this.getCanvas().repaint();
        }
    }

    public boolean getShowFeatureArrows() {
        return this.show_feature_arrows;
    }

    public void setShowFeatureBorders(boolean show_feature_borders) {
        if (this.show_feature_borders != show_feature_borders) {
            this.show_feature_borders = show_feature_borders;
            this.getCanvas().repaint();
        }
    }

    public boolean getShowFeatureBorders() {
        return this.show_feature_borders;
    }

    public void setFrameFeaturesFlag(boolean frame_features_flag) {
        if (this.frame_features_flag != frame_features_flag) {
            this.frame_features_flag = frame_features_flag;
            this.getCanvas().repaint();
        }
    }

    public boolean getFrameFeaturesFlag() {
        return this.frame_features_flag;
    }

    public void setMinimumScore(int minimum_score) {
        this.current_min_score = minimum_score;
        this.needVisibleFeatureVectorUpdate();
        this.getCanvas().repaint();
    }

    public int getMinimumScore() {
        return this.current_min_score;
    }

    public void setMaximumScore(int maximum_score) {
        this.current_max_score = maximum_score;
        this.needVisibleFeatureVectorUpdate();
        this.getCanvas().repaint();
    }

    public int getMaximumScore() {
        return this.current_max_score;
    }

    public void redisplay() {
        this.getCanvas().repaint();
    }

    public void addDisplayAdjustmentListener(DisplayAdjustmentListener l) {
        this.adjustment_listener_list.addElement(l);
    }

    public void removeDisplayAdjustmentListener(DisplayAdjustmentListener l) {
        this.adjustment_listener_list.removeElement(l);
    }

    private static void handleKeyPress(FeatureDisplay feature_display, KeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        switch (event.getKeyCode()) {
            case 90: {
                FeaturePopup.zoomToSelection(feature_display);
                break;
            }
        }
    }

    public void setScaleFactor(int scale_factor) {
        if (this.scale_factor != scale_factor) {
            int remember_position = this.getCentreForwardBase();
            if (this.hard_left_edge && this.getFirstVisibleForwardBase() == 1) {
                remember_position = 1;
            }
            if (!this.getSelection().isEmpty()) {
                Marker first_base_marker = this.getSelection().getStartBaseOfSelection();
                int first_base_marker_raw_position = first_base_marker.getRawPosition();
                int first_base_marker_position = this.isRevCompDisplay() ? this.getBases().getComplementPosition(first_base_marker_raw_position) : first_base_marker_raw_position;
                Marker last_base_marker = this.getSelection().getEndBaseOfSelection();
                int last_base_marker_raw_position = last_base_marker.getRawPosition();
                int last_base_marker_position = this.isRevCompDisplay() ? this.getBases().getComplementPosition(last_base_marker_raw_position) : last_base_marker_raw_position;
                int lowest_visible_base = this.getFirstVisibleForwardBase();
                int highest_visible_base = this.getLastVisibleForwardBase();
                int restricted_first_selected_base = lowest_visible_base;
                int restricted_last_selected_base = highest_visible_base;
                if (first_base_marker != null && first_base_marker_position > lowest_visible_base && first_base_marker_position < highest_visible_base) {
                    restricted_first_selected_base = first_base_marker_position;
                }
                if (last_base_marker != null && last_base_marker_position < highest_visible_base && last_base_marker_position > lowest_visible_base) {
                    restricted_last_selected_base = last_base_marker_position;
                }
                remember_position = this.getSelection().getMarkerRange() == null ? restricted_first_selected_base : restricted_first_selected_base + (restricted_last_selected_base - restricted_first_selected_base) / 2;
            }
            this.scale_factor = scale_factor;
            this.setScaleValue();
            this.scale_changer.setValue(scale_factor);
            this.setCentreVisibleForwardBase(remember_position);
            this.fixScrollbar();
            this.fireAdjustmentEvent(0);
            this.needVisibleFeatureVectorUpdate();
            this.getCanvas().repaint();
        }
    }

    public void featureChanged(FeatureChangeEvent event) {
        Feature event_feature = event.getFeature();
        if (!this.getEntryGroup().contains(event_feature)) {
            return;
        }
        if (this.featureVisible(event_feature) || this.getVisibleFeatures().contains(event_feature)) {
            if (this.getVisibleFeatures().contains(event_feature) && !this.featureVisible(event_feature)) {
                this.getVisibleFeatures().remove(event_feature);
            } else if (!this.getVisibleFeatures().contains(event_feature) && this.featureVisible(event_feature)) {
                this.getVisibleFeatures().add(event_feature);
            }
            this.getCanvas().repaint();
        }
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.getOneLinePerEntryFlag()) {
                    this.fixCanvasSize();
                }
                this.needVisibleFeatureVectorUpdate();
            }
        }
        this.getCanvas().repaint();
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.remove(event.getFeature());
                break;
            }
            case 2: {
                this.add(event.getFeature());
            }
        }
    }

    public void selectionChanged(SelectionChangeEvent event) {
        if (event.getSource() == this) {
            return;
        }
        this.needVisibleFeatureVectorUpdate();
        if (event.getType() == 1) {
            this.raise_selection_flag = true;
        }
        this.getCanvas().repaint();
    }

    public void sequenceChanged(SequenceChangeEvent event) {
        this.visible_features = new FeatureVector();
        if (event.getType() == 3) {
            int old_centre_position = this.getCentreForwardBase();
            int new_centre_position = this.getBases().getComplementPosition(old_centre_position);
            this.makeBaseVisibleInternal(new_centre_position, true, false);
        } else {
            this.makeBaseVisibleInternal(event.getPosition(), true, false);
        }
        this.fixScrollbar();
        this.needVisibleFeatureVectorUpdate();
        this.getCanvas().repaint();
        if (event.getType() == 3) {
            this.fireAdjustmentEvent(2);
        } else {
            this.fireAdjustmentEvent(1);
        }
    }

    public void optionChanged(OptionChangeEvent event) {
        this.getCanvas().repaint();
    }

    public void performGoto(GotoEvent event) {
        this.makeBaseVisible(event.getMarker());
    }

    public void displayAdjustmentValueChanged(DisplayAdjustmentEvent event) {
        this.disable_display_events = true;
        try {
            this.setScaleFactor(event.getScaleFactor());
            this.setFirstVisibleForwardBase(event.getStart());
        }
        finally {
            this.disable_display_events = false;
        }
    }

    public MarkerRange getVisibleMarkerRange() {
        int first_base = this.getFirstVisibleForwardBase();
        int last_base = this.getLastVisibleForwardBase();
        Strand strand = this.getBases().getForwardStrand();
        try {
            return strand.makeMarkerRangeFromPositions(first_base, last_base);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    void raiseFeature(Feature feature) {
        if (this.getVisibleFeatures().remove(feature)) {
            this.getVisibleFeatures().addElementAtEnd(feature);
            this.getCanvas().repaint();
        }
    }

    void lowerFeature(Feature feature) {
        if (this.getVisibleFeatures().remove(feature)) {
            this.getVisibleFeatures().insertElementAt(feature, 0);
            this.getCanvas().repaint();
        }
    }

    void smallestToFront() {
        this.visible_features = new FeatureVector();
        this.needVisibleFeatureVectorUpdate();
        this.getCanvas().repaint();
    }

    private void setCentreVisibleForwardBase(int base_position) {
        int max_visible_bases = this.getMaxVisibleBases();
        int possible_base_position = base_position - max_visible_bases / 2;
        int real_base_position = possible_base_position < 1 && this.hard_left_edge ? 1 : possible_base_position;
        if (real_base_position > this.getSequenceLength()) {
            real_base_position = this.getSequenceLength();
        }
        this.setFirstVisibleForwardBase(real_base_position);
    }

    private void makeBaseVisibleInternal(int base_position, boolean forward, boolean send_event) {
        int forward_base_position = base_position;
        if (!forward ^ this.isRevCompDisplay()) {
            forward_base_position = this.getBases().getComplementPosition(forward_base_position);
        }
        this.setCentreVisibleForwardBase(forward_base_position);
        if (send_event) {
            this.fireAdjustmentEvent(1);
        }
    }

    private void makeBaseVisible(Marker base_marker) {
        this.makeBaseVisibleInternal(base_marker.getPosition(), base_marker.getStrand().isForwardStrand(), true);
    }

    public void makeBaseVisible(int base) {
        this.makeBaseVisibleInternal(base, true, true);
    }

    private void add(Feature feature) {
        if (this.getEntryGroup().isActive(feature.getEntry()) && this.featureVisible(feature) && !this.visible_features.contains(feature)) {
            this.getVisibleFeatures().addElementAtEnd(feature);
        }
        this.getCanvas().repaint();
    }

    private void remove(Feature feature) {
        if (this.visible_features != null) {
            this.visible_features.remove(feature);
        }
        this.getCanvas().repaint();
    }

    private FeatureVector getVisibleFeatures() {
        return this.visible_features;
    }

    public FeatureVector getCurrentVisibleFeatures() {
        return (FeatureVector)this.visible_features.clone();
    }

    private Range getVisibleRange() {
        int last_visible_base;
        int first_visible_base = this.getFirstVisibleForwardBase();
        if (first_visible_base <= (last_visible_base = this.getLastVisibleForwardBase())) {
            return this.newRange(first_visible_base, last_visible_base);
        }
        return null;
    }

    private void updateVisibleFeatureVector() {
        Feature new_feature;
        Range visible_range;
        if (this.getCanvas().getSize().width == 0) {
            this.visible_features = new FeatureVector();
            return;
        }
        if (this.raise_selection_flag) {
            FeatureVector all_features = this.getSelection().getAllFeatures();
            int i = 0;
            while (i < all_features.size()) {
                this.raiseFeature(all_features.elementAt(i));
                ++i;
            }
            this.raise_selection_flag = false;
        }
        if (this.isRevCompDisplay()) {
            int first_visible_base = this.getFirstVisibleReverseBase();
            int last_visible_base = this.getLastVisibleReverseBase();
            visible_range = this.newRange(first_visible_base, last_visible_base);
        } else {
            visible_range = this.getVisibleRange();
        }
        if (visible_range == null) {
            this.visible_features = new FeatureVector();
            return;
        }
        FeatureVector real_visible_features = this.getSortedFeaturesInRange(visible_range);
        FeatureVector new_visible_features = new FeatureVector();
        int i = 0;
        while (i < this.visible_features.size()) {
            new_feature = this.visible_features.elementAt(i);
            if (real_visible_features.contains(new_feature)) {
                new_visible_features.addElementAtEnd(new_feature);
            }
            ++i;
        }
        i = 0;
        while (i < real_visible_features.size()) {
            new_feature = real_visible_features.elementAt(i);
            if (!this.visible_features.contains(new_feature) && !this.getSelection().contains(new_feature)) {
                new_visible_features.addElementAtEnd(new_feature);
            }
            ++i;
        }
        FeatureVector selection_features = this.getSelection().getAllFeatures();
        int i2 = 0;
        while (i2 < real_visible_features.size()) {
            Feature new_feature2 = real_visible_features.elementAt(i2);
            if (!this.visible_features.contains(new_feature2) && selection_features.contains(new_feature2)) {
                new_visible_features.addElementAtEnd(new_feature2);
            }
            ++i2;
        }
        this.visible_features = new_visible_features;
        this.update_visible_features = false;
    }

    private FeatureVector getSortedFeaturesInRange(Range range) {
        try {
            FeatureVector features_from_entry = this.getEntryGroup().getFeaturesInRange(range);
            int min_score = this.getMinimumScore();
            int max_score = this.getMaximumScore();
            FeatureVector filtered_features = new FeatureVector();
            int i = features_from_entry.size() - 1;
            while (i >= 0) {
                int this_feature_score;
                Feature this_feature = features_from_entry.elementAt(i);
                if ((!this_feature.getKey().equals("source") || this.getShowSourceFeatures() || this.getSelection().contains(this_feature)) && (min_score <= 0 && max_score >= 100 || (this_feature_score = this_feature.getScore()) == -1 || this_feature_score >= this.getMinimumScore() && this_feature_score <= this.getMaximumScore() || this.getSelection().contains(this_feature))) {
                    filtered_features.add(this_feature);
                }
                --i;
            }
            features_from_entry = filtered_features;
            FeatureVector sorted_features = features_from_entry.sort(feature_comparator);
            return sorted_features;
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    protected void paintCanvas(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.update_visible_features) {
            this.updateVisibleFeatureVector();
        }
        this.fillBackground(g);
        Selection selection = this.getSelection();
        FeatureVector selected_features = selection.getAllFeatures();
        FeatureSegmentVector selected_segments = selection.getSelectedSegments();
        int i = 0;
        while (i < this.getVisibleFeatures().size()) {
            this.drawFeature(g, this.getVisibleFeatures().elementAt(i), true, selected_features, selected_segments);
            ++i;
        }
        this.drawBaseSelection(g);
        this.drawScale(g);
        this.drawCodons(g);
        this.drawBases(g);
        i = 0;
        while (i < this.getVisibleFeatures().size()) {
            this.drawFeature(g, this.getVisibleFeatures().elementAt(i), false, selected_features, selected_segments);
            ++i;
        }
    }

    private void fillBackground(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getCanvas().getSize().width, this.getCanvas().getSize().height);
        if (this.getOneLinePerEntryFlag()) {
            int i = 0;
            while (i < this.getEntryGroup().size()) {
                int forward_entry_line = this.getDisplayLineOfEntryIndex(i, true);
                int reverse_entry_line = this.getDisplayLineOfEntryIndex(i, false);
                Entry current_entry = this.getEntryGroup().elementAt(i);
                if (this.getEntryGroup().getDefaultEntry() == current_entry && Options.getOptions().highlightActiveEntryFlag()) {
                    this.fillLane(g, forward_entry_line, this.active_entry_colour);
                    this.fillLane(g, reverse_entry_line, this.active_entry_colour);
                } else {
                    this.fillLane(g, forward_entry_line, this.light_grey);
                    this.fillLane(g, reverse_entry_line, this.light_grey);
                }
                ++i;
            }
        } else {
            if (this.show_forward_lines) {
                this.fillLane(g, this.getFrameDisplayLine(0), this.light_grey);
                this.fillLane(g, this.getFrameDisplayLine(1), this.light_grey);
                this.fillLane(g, this.getFrameDisplayLine(2), this.light_grey);
            }
            if (this.show_reverse_lines) {
                this.fillLane(g, this.getFrameDisplayLine(7), this.light_grey);
                this.fillLane(g, this.getFrameDisplayLine(6), this.light_grey);
                this.fillLane(g, this.getFrameDisplayLine(5), this.light_grey);
            }
        }
        this.fillLane(g, this.getFrameDisplayLine(3), this.not_so_light_grey);
        this.fillLane(g, this.getFrameDisplayLine(4), this.not_so_light_grey);
    }

    private void fillLane(Graphics g, int fill_line_number, Color colour) {
        int fill_line_top = fill_line_number * this.getLineHeight() + 1;
        g.setColor(colour);
        int first_visible_base_coord = this.getLowXPositionOfBase(this.getFirstVisibleForwardBase());
        int last_visible_base_coord = this.getHighXPositionOfBase(this.getLastVisibleForwardBase());
        g.fillRect(first_visible_base_coord, fill_line_top, last_visible_base_coord - first_visible_base_coord + 1, this.getFeatureHeight());
    }

    private void drawScale(Graphics g) {
        g.setColor(Color.black);
        int scale_line = this.getFrameDisplayLine(8);
        int scale_number_y_pos = scale_line * this.getLineHeight();
        float bases_per_pixel = (float)this.getMaxVisibleBases() / (float)this.getCanvasWidth();
        int base_label_spacing = this.getScaleFactor() == 0 ? (int)Math.ceil(80.0f * bases_per_pixel / 10.0f) * 10 : (int)Math.ceil(80.0f * bases_per_pixel / 100.0f) * 100;
        int cfr_ignored_0 = (int)((float)base_label_spacing / bases_per_pixel);
        int possible_index_of_first_label = this.isRevCompDisplay() ? (this.getSequenceLength() - this.getLastVisibleForwardBase() + 1) / base_label_spacing : this.getFirstVisibleForwardBase() / base_label_spacing;
        int index_of_first_label = possible_index_of_first_label <= 0 ? 1 : possible_index_of_first_label;
        int index_of_last_label = this.isRevCompDisplay() ? (this.getSequenceLength() - this.getFirstVisibleForwardBase() + 1) / base_label_spacing : this.getLastVisibleForwardBase() / base_label_spacing;
        int i = index_of_first_label;
        while (i <= index_of_last_label) {
            String label_string = String.valueOf(i * base_label_spacing);
            int scale_number_x_pos = this.isRevCompDisplay() ? this.getLowXPositionOfBase(this.getSequenceLength() - i * base_label_spacing + 1) : this.getLowXPositionOfBase(i * base_label_spacing);
            g.setFont(this.getFont());
            g.drawString(label_string, scale_number_x_pos + 2, scale_number_y_pos + this.getFontAscent() + 1);
            g.drawLine(scale_number_x_pos, scale_number_y_pos, scale_number_x_pos, scale_number_y_pos + this.getLineHeight());
            if (this.isRevCompDisplay()) {
                g.drawLine(scale_number_x_pos, scale_number_y_pos, scale_number_x_pos + this.getFontWidth(), scale_number_y_pos);
            } else {
                g.drawLine(scale_number_x_pos, scale_number_y_pos + this.getLineHeight(), scale_number_x_pos + this.getFontWidth(), scale_number_y_pos + this.getLineHeight());
            }
            ++i;
        }
    }

    private void drawBases(Graphics g) {
        Strand forward_strand;
        Strand reverse_strand;
        if (this.getScaleFactor() > 1 || this.getScaleFactor() == 1 && !this.show_base_colours) {
            return;
        }
        if (this.isRevCompDisplay()) {
            reverse_strand = this.getBases().getForwardStrand();
            forward_strand = this.getBases().getReverseStrand();
        } else {
            forward_strand = this.getBases().getForwardStrand();
            reverse_strand = this.getBases().getReverseStrand();
        }
        Range forward_range = this.newRange(this.getFirstVisibleForwardBase(), this.getLastVisibleForwardBase());
        String forward_visible_bases = forward_strand.getSubSequence(forward_range).toUpperCase();
        int forward_frame_line = this.getFrameDisplayLine(3);
        int forward_sequence_length = forward_visible_bases.length();
        int offset = this.getForwardBaseAtLeftEdge() < 1 ? 1 - this.getForwardBaseAtLeftEdge() : 0;
        int base_index = 0;
        while (base_index < forward_sequence_length) {
            char char_to_draw = forward_visible_bases.charAt(base_index);
            if (this.getScaleFactor() == 0) {
                this.drawOneBaseLetter(g, char_to_draw, (offset + base_index) * this.getFontWidth(), forward_frame_line * this.getLineHeight());
            } else {
                this.drawOnePixelBase(g, char_to_draw, offset + base_index, forward_frame_line * this.getLineHeight());
            }
            ++base_index;
        }
        Range reverse_range = this.newRange(this.getFirstVisibleReverseBase(), this.getLastVisibleReverseBase());
        String reverse_visible_bases = reverse_strand.getSubSequence(reverse_range).toUpperCase();
        int reverse_frame_line = this.getFrameDisplayLine(4);
        int reverse_sequence_length = reverse_visible_bases.length();
        int base_index2 = 0;
        while (base_index2 < reverse_sequence_length) {
            char char_to_draw = reverse_visible_bases.charAt(reverse_sequence_length - base_index2 - 1);
            if (this.getScaleFactor() == 0) {
                this.drawOneBaseLetter(g, char_to_draw, (offset + base_index2) * this.getFontWidth(), reverse_frame_line * this.getLineHeight());
            } else {
                this.drawOnePixelBase(g, char_to_draw, offset + base_index2, reverse_frame_line * this.getLineHeight());
            }
            ++base_index2;
        }
    }

    private void drawCodons(Graphics g) {
        g.setColor(Color.black);
        if (this.getScaleFactor() == 0) {
            if (!this.getOneLinePerEntryFlag()) {
                if (this.show_forward_lines) {
                    this.drawForwardCodonLetters(g);
                }
                if (this.show_reverse_lines) {
                    this.drawReverseCodonLetters(g);
                }
            }
        } else if ((this.show_stop_codons || this.show_start_codons) && this.getScaleFactor() <= 7 && !this.getOneLinePerEntryFlag()) {
            if (this.show_forward_lines) {
                this.drawForwardCodons(g);
            }
            if (this.show_reverse_lines) {
                this.drawReverseCodons(g);
            }
        }
    }

    private void drawForwardCodons(Graphics g) {
        Strand strand = this.isRevCompDisplay() ? this.getBases().getReverseStrand() : this.getBases().getForwardStrand();
        int first_visible_base = this.getForwardBaseAtLeftEdge();
        int frame_shift = (first_visible_base - 1) % 3;
        int start_base = first_visible_base - frame_shift;
        int end_base = this.getLastVisibleForwardBase() + 3;
        Object forward_stop_codons = null;
        if (this.show_stop_codons) {
            forward_stop_codons = new int[][]{strand.getStopCodons(this.newRange(start_base, end_base)), strand.getStopCodons(this.newRange(start_base + 1, end_base)), strand.getStopCodons(this.newRange(start_base + 2, end_base))};
        }
        Object forward_start_codons = null;
        if (this.show_start_codons) {
            StringVector start_codons = Options.getOptions().isEukaryoticMode() ? Options.getOptions().getEukaryoticStartCodons() : Options.getOptions().getProkaryoticStartCodons();
            forward_start_codons = new int[][]{strand.getMatchingCodons(this.newRange(start_base, end_base), start_codons), strand.getMatchingCodons(this.newRange(start_base + 1, end_base), start_codons), strand.getMatchingCodons(this.newRange(start_base + 2, end_base), start_codons)};
        }
        int i = 0;
        while (i < 3) {
            int frame_line = this.getFrameDisplayLine(0 + i);
            if (this.show_start_codons) {
                int[] this_frame_start_codons = forward_start_codons[i];
                this.drawCodonMarkLine(g, frame_line, this_frame_start_codons, 1, 80);
            }
            if (this.show_stop_codons) {
                int[] this_frame_stop_codons = forward_stop_codons[i];
                this.drawCodonMarkLine(g, frame_line, this_frame_stop_codons, 1, 100);
            }
            ++i;
        }
    }

    private void drawReverseCodons(Graphics g) {
        Strand strand = this.isRevCompDisplay() ? this.getBases().getForwardStrand() : this.getBases().getReverseStrand();
        int first_visible_base = this.getFirstVisibleReverseBase();
        int frame_shift = (first_visible_base - 1) % 3;
        int start_base = first_visible_base - frame_shift;
        int end_base = this.getLastVisibleReverseBase() + 3;
        Object reverse_stop_codons = null;
        if (this.show_stop_codons) {
            reverse_stop_codons = new int[][]{strand.getStopCodons(this.newRange(start_base, end_base)), strand.getStopCodons(this.newRange(start_base + 1, end_base)), strand.getStopCodons(this.newRange(start_base + 2, end_base))};
        }
        Object reverse_start_codons = null;
        if (this.show_start_codons) {
            StringVector start_codons = Options.getOptions().isEukaryoticMode() ? Options.getOptions().getEukaryoticStartCodons() : Options.getOptions().getProkaryoticStartCodons();
            reverse_start_codons = new int[][]{strand.getMatchingCodons(this.newRange(start_base, end_base), start_codons), strand.getMatchingCodons(this.newRange(start_base + 1, end_base), start_codons), strand.getMatchingCodons(this.newRange(start_base + 2, end_base), start_codons)};
        }
        int i = 0;
        while (i < 3) {
            int frame_line = this.getFrameDisplayLine(7 - i);
            if (this.show_start_codons) {
                int[] this_frame_start_codons = reverse_start_codons[i];
                this.drawCodonMarkLine(g, frame_line, this_frame_start_codons, 2, 80);
            }
            if (this.show_stop_codons) {
                int[] this_frame_stop_codons = reverse_stop_codons[i];
                this.drawCodonMarkLine(g, frame_line, this_frame_stop_codons, 2, 100);
            }
            ++i;
        }
    }

    private void drawForwardCodonLetters(Graphics g) {
        Strand strand = this.isRevCompDisplay() ? this.getBases().getReverseStrand() : this.getBases().getForwardStrand();
        int first_visible_base = this.getFirstVisibleForwardBase();
        int i = 0;
        while (i < 3) {
            int frame_shift = 1 - (first_visible_base + 3 - i) % 3;
            int start_base = first_visible_base + frame_shift;
            int end_base = this.getLastVisibleForwardBase() + 1;
            int frame_line = this.getFrameDisplayLine(0 + i);
            int frame_x_start = frame_shift;
            AminoAcidSequence this_frame_translation = strand.getTranslation(this.newRange(start_base, end_base), false);
            String this_frame_translation_string = this_frame_translation.toString();
            this.drawCodonLine(g, frame_x_start, frame_line, this_frame_translation_string, 1);
            ++i;
        }
    }

    private void drawReverseCodonLetters(Graphics g) {
        Strand strand = this.isRevCompDisplay() ? this.getBases().getForwardStrand() : this.getBases().getReverseStrand();
        int first_visible_base = this.getFirstVisibleReverseBase();
        int i = 0;
        while (i < 3) {
            int frame_shift = 1 - (first_visible_base + 3 - i) % 3;
            int start_base = first_visible_base + frame_shift;
            int end_base = this.getLastVisibleReverseBase() + 1;
            int frame_line = this.getFrameDisplayLine(7 - i);
            int frame_x_start = frame_shift;
            AminoAcidSequence this_frame_translation = strand.getTranslation(this.newRange(start_base, end_base), false);
            String this_frame_translation_string = this_frame_translation.toString();
            this.drawCodonLine(g, frame_x_start, frame_line, this_frame_translation_string, 2);
            ++i;
        }
    }

    private void drawCodonLine(Graphics g, int frame_start, int line_number, String codons, int direction) {
        int offset = this.getForwardBaseAtLeftEdge() < 1 && direction != 2 ? 1 - this.getForwardBaseAtLeftEdge() : 0;
        String upper_case_codons = codons.toUpperCase();
        int draw_y_position = line_number * this.getLineHeight();
        int i = 0;
        while (i < upper_case_codons.length()) {
            char aa_char = upper_case_codons.charAt(i);
            int draw_x_position = (int)((float)(offset + frame_start + 3 * i + 1) * this.getScaleValue());
            if (direction == 2) {
                draw_x_position = this.getLowXPositionOfBase(this.getLastVisibleForwardBase()) - draw_x_position;
            }
            this.drawOneLetter(g, aa_char, draw_x_position, draw_y_position);
            ++i;
        }
    }

    private void drawCodonMarkLine(Graphics g, int line_number, int[] codon_positions, int direction, int height_percent) {
        Color start_codon_colour;
        this.getForwardBaseAtLeftEdge();
        this.getFirstVisibleReverseBase();
        this.getLastVisibleForwardBase();
        double cfr_ignored_0 = this.getScaleValue();
        int line_height = this.getLineHeight();
        Integer colour_number = Options.getOptions().getIntegerProperty("colour_of_start_codon");
        if (colour_number != null) {
            int int_colour_number = colour_number;
            start_codon_colour = Options.getOptions().getColorFromColourNumber(int_colour_number);
        } else {
            start_codon_colour = Color.blue;
        }
        int draw_y_position = line_number * line_height + (int)(1.0 * (double)line_height * (double)(100 - height_percent) / 100.0 / 2.0 + 0.5);
        int mark_height = height_percent * line_height / 100;
        int last_x_position = -1;
        int i = 0;
        while (i < codon_positions.length) {
            int draw_x_position;
            int codon_base_start = codon_positions[i];
            if (codon_base_start == 0) break;
            if (direction == 1) {
                draw_x_position = this.getLowXPositionOfBase(codon_base_start);
            } else {
                int raw_base_position = this.getBases().getComplementPosition(codon_base_start);
                draw_x_position = this.getLowXPositionOfBase(raw_base_position);
            }
            if (last_x_position == -1 || draw_x_position != last_x_position) {
                if (height_percent < 100) {
                    this.drawOneCodonMark(g, draw_x_position, draw_y_position, direction, mark_height, start_codon_colour);
                } else {
                    this.drawOneCodonMark(g, draw_x_position, draw_y_position, direction, mark_height, Color.black);
                }
                last_x_position = draw_x_position;
            }
            ++i;
        }
    }

    private static Color getColourOfBase(char base_char) {
        switch (base_char) {
            case 'C': 
            case 'c': {
                return Color.blue;
            }
            case 'T': 
            case 't': {
                return Color.red;
            }
            case 'A': 
            case 'a': {
                return dark_green;
            }
            case 'G': 
            case 'g': {
                return Color.black;
            }
        }
        return Color.white;
    }

    private void drawOneLetter(Graphics g, char letter, int x_pos, int y_pos) {
        this.draw_one_char_temp_array[0] = letter;
        g.setFont(this.getFont());
        g.drawChars(this.draw_one_char_temp_array, 0, 1, x_pos, y_pos + this.getFontAscent() + 1);
    }

    private void drawOneBaseLetter(Graphics g, char base_char, int x_pos, int y_pos) {
        if (this.show_base_colours) {
            g.setColor(FeatureDisplay.getColourOfBase(base_char));
        }
        this.drawOneLetter(g, base_char, x_pos, y_pos);
    }

    private void drawOneCodonMark(Graphics g, int x_pos, int y_pos, int direction, int height, Color colour) {
        g.setColor(colour);
        if (this.getScaleFactor() == 1) {
            if (direction == 1) {
                g.drawLine(x_pos + 1, y_pos, x_pos + 1, y_pos + height - 1);
                g.drawLine(x_pos + 2, y_pos, x_pos + 2, y_pos + height - 1);
            } else {
                g.drawLine(x_pos - 1, y_pos, x_pos - 1, y_pos + height - 1);
                g.drawLine(x_pos - 2, y_pos, x_pos - 2, y_pos + height - 1);
            }
        }
        g.drawLine(x_pos, y_pos, x_pos, y_pos + height - 1);
    }

    private void drawOnePixelBase(Graphics g, char base_char, int x_pos, int y_pos) {
        g.setColor(FeatureDisplay.getColourOfBase(base_char));
        g.drawLine(x_pos, y_pos, x_pos, y_pos + this.getLineHeight() - 1);
    }

    private int getSegmentDisplayLine(FeatureSegment segment) {
        if (this.getOneLinePerEntryFlag()) {
            Feature feature = segment.getFeature();
            if ((feature.isProteinFeature() || this.frame_features_flag) && (this.show_forward_lines && feature.isForwardFeature() ^ this.isRevCompDisplay() || this.show_reverse_lines && !feature.isForwardFeature() ^ this.isRevCompDisplay())) {
                return this.getFeatureDisplayLine(feature);
            }
            if (feature.isForwardFeature() ^ this.isRevCompDisplay()) {
                return this.getFrameDisplayLine(3);
            }
            return this.getFrameDisplayLine(4);
        }
        int frame_id = this.maybeFlipFrameDirection(this.getSegmentFrameID(segment));
        return this.getFrameDisplayLine(frame_id);
    }

    private int getSegmentFrameID(FeatureSegment segment) {
        int frame_id = segment.getFrameID();
        Feature feature = segment.getFeature();
        if ((feature.isProteinFeature() || this.frame_features_flag) && (this.show_forward_lines && feature.isForwardFeature() ^ this.isRevCompDisplay() || this.show_reverse_lines && !feature.isForwardFeature() ^ this.isRevCompDisplay())) {
            return frame_id;
        }
        switch (frame_id) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return 3;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 4;
            }
        }
        return frame_id;
    }

    private int getFeatureDisplayLine(Feature feature) {
        int entry_index = this.getEntryGroup().indexOf(feature.getEntry());
        return this.getDisplayLineOfEntryIndex(entry_index, feature.isForwardFeature() ^ this.isRevCompDisplay());
    }

    private int getDisplayLineOfEntryIndex(int entry_index, boolean is_forward_feature) {
        if (is_forward_feature) {
            if (this.getShowForwardFrameLines()) {
                if (this.getShowLabels()) {
                    return entry_index * 2;
                }
                return entry_index;
            }
            return 0;
        }
        int return_value = 0;
        if (this.getShowLabels()) {
            return_value = this.getEntryGroup().size() * 2 + 3 - entry_index * 2;
            if (this.getShowForwardFrameLines()) {
                return_value += this.getEntryGroup().size() * 2;
            }
        } else {
            return_value = this.getEntryGroup().size() + 2 - entry_index;
            if (this.getShowForwardFrameLines()) {
                return_value += this.getEntryGroup().size();
            }
        }
        return return_value;
    }

    private int maybeFlipFrameDirection(int frame_id) {
        if (this.isRevCompDisplay()) {
            switch (frame_id) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 6;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 4;
                }
                case 7: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
            }
            return frame_id;
        }
        return frame_id;
    }

    private int getFrameDisplayLine(int frame_id) {
        int line_number;
        if (this.getOneLinePerEntryFlag()) {
            int return_value;
            switch (frame_id) {
                case 3: {
                    return_value = 0;
                    break;
                }
                case 4: {
                    if (this.show_labels) {
                        return_value = 3;
                        break;
                    }
                    return_value = 2;
                    break;
                }
                case 8: {
                    if (this.show_labels) {
                        return_value = 2;
                        break;
                    }
                    return_value = 1;
                    break;
                }
                default: {
                    throw new Error("internal error - unexpected value: " + frame_id);
                }
            }
            if (this.show_forward_lines) {
                if (this.show_labels) {
                    return_value += this.getEntryGroup().size();
                }
                return return_value + this.getEntryGroup().size();
            }
            return return_value;
        }
        switch (frame_id) {
            case 0: {
                line_number = 0;
                break;
            }
            case 1: {
                if (this.show_labels) {
                    line_number = 2;
                    break;
                }
                line_number = 1;
                break;
            }
            case 2: {
                if (this.show_labels) {
                    line_number = 4;
                    break;
                }
                line_number = 2;
                break;
            }
            case 3: {
                if (this.show_forward_lines) {
                    if (this.show_labels) {
                        line_number = 6;
                        break;
                    }
                    line_number = 3;
                    break;
                }
                line_number = 0;
                break;
            }
            case 4: {
                if (this.show_forward_lines) {
                    if (this.show_labels) {
                        line_number = 9;
                        break;
                    }
                    line_number = 5;
                    break;
                }
                if (this.show_labels) {
                    line_number = 3;
                    break;
                }
                line_number = 2;
                break;
            }
            case 5: {
                if (this.show_forward_lines) {
                    if (this.show_labels) {
                        line_number = 11;
                        break;
                    }
                    line_number = 6;
                    break;
                }
                if (this.show_labels) {
                    line_number = 5;
                    break;
                }
                line_number = 3;
                break;
            }
            case 6: {
                if (this.show_forward_lines) {
                    if (this.show_labels) {
                        line_number = 13;
                        break;
                    }
                    line_number = 7;
                    break;
                }
                if (this.show_labels) {
                    line_number = 7;
                    break;
                }
                line_number = 4;
                break;
            }
            case 7: {
                if (this.show_forward_lines) {
                    if (this.show_labels) {
                        line_number = 15;
                        break;
                    }
                    line_number = 8;
                    break;
                }
                if (this.show_labels) {
                    line_number = 9;
                    break;
                }
                line_number = 5;
                break;
            }
            default: {
                if (this.show_forward_lines) {
                    if (this.show_labels) {
                        line_number = 8;
                        break;
                    }
                    line_number = 4;
                    break;
                }
                line_number = this.show_labels ? 2 : 1;
            }
        }
        return line_number;
    }

    private int getLineCount() {
        int line_count = this.show_labels ? 5 : 3;
        int extra_line_count = this.getOneLinePerEntryFlag() ? this.getEntryGroup().size() : 3;
        if (this.show_labels) {
            extra_line_count *= 2;
        }
        if (this.show_forward_lines) {
            line_count += extra_line_count;
        }
        if (this.show_reverse_lines) {
            line_count += extra_line_count;
        }
        return line_count;
    }

    private int getSegmentVerticalOffset(FeatureSegment segment) {
        int line = this.getSegmentDisplayLine(segment);
        return this.getLineOffset(line);
    }

    private int getLineOffset(int line) {
        return line * this.getLineHeight();
    }

    private int getLowXPositionOfBase(int base_number) {
        return (int)((float)(base_number - this.getForwardBaseAtLeftEdge()) * this.getScaleValue());
    }

    private int getHighXPositionOfBase(int base_number) {
        if (this.getScaleFactor() == 0) {
            return this.getLowXPositionOfBase(base_number) + this.getFontWidth() - 1;
        }
        return this.getLowXPositionOfBase(base_number);
    }

    private int getLowXPositionOfMarker(Marker marker) {
        int position = marker.getRawPosition();
        if (this.isRevCompDisplay()) {
            position = this.getSequenceLength() - position + 1;
        }
        if (marker.getStrand().isForwardStrand() ^ this.isRevCompDisplay()) {
            return this.getLowXPositionOfBase(position);
        }
        return this.getHighXPositionOfBase(position);
    }

    private int getHighXPositionOfMarker(Marker marker) {
        int position = marker.getRawPosition();
        if (this.isRevCompDisplay()) {
            position = this.getSequenceLength() - position + 1;
        }
        if (marker.getStrand().isForwardStrand() ^ this.isRevCompDisplay()) {
            return this.getHighXPositionOfBase(position);
        }
        return this.getLowXPositionOfBase(position);
    }

    private MarkerRange getMarkerRangeFromPosition(Point position) {
        return this.getMarkerRangeFromPosition(position, true);
    }

    private int getBasePositionOfPoint(Point position, int direction) {
        if (direction == 3) {
            return (int)(1.0 * (double)position.x / (double)this.getScaleValue() + (double)this.getForwardBaseAtLeftEdge());
        }
        if (direction == 4) {
            int raw_base_position = (int)(1.0 * (double)position.x / (double)this.getScaleValue() + (double)this.getForwardBaseAtLeftEdge());
            return this.getBases().getComplementPosition(raw_base_position);
        }
        throw new Error("internal error - unexpected value: " + direction);
    }

    private MarkerRange getMarkerRangeFromPosition(Point position, boolean whole_codon) {
        int end_base_position;
        int start_base_position;
        int base_position;
        int frame_id;
        Strand strand;
        if (this.getOneLinePerEntryFlag()) {
            int scale_line = this.getFrameDisplayLine(8);
            int position_line = this.getLineFromPoint(position);
            if (position_line < scale_line) {
                strand = this.isRevCompDisplay() ? this.getBases().getReverseStrand() : this.getBases().getForwardStrand();
                frame_id = 3;
            } else if (position_line > scale_line) {
                strand = this.isRevCompDisplay() ? this.getBases().getForwardStrand() : this.getBases().getReverseStrand();
                frame_id = 4;
            } else {
                return null;
            }
            base_position = this.getBasePositionOfPoint(position, frame_id);
        } else {
            frame_id = this.getFrameFromPoint(position);
            switch (frame_id) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    strand = this.isRevCompDisplay() ? this.getBases().getReverseStrand() : this.getBases().getForwardStrand();
                    base_position = this.getBasePositionOfPoint(position, 3);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    strand = this.isRevCompDisplay() ? this.getBases().getForwardStrand() : this.getBases().getReverseStrand();
                    base_position = this.getBasePositionOfPoint(position, 4);
                    break;
                }
                default: {
                    base_position = 0;
                    strand = null;
                }
            }
        }
        if (whole_codon) {
            start_base_position = this.adjustBasePositionForFrame(frame_id, base_position, true);
            end_base_position = this.adjustBasePositionForFrame(frame_id, base_position, false);
        } else {
            start_base_position = base_position;
            end_base_position = base_position;
        }
        if (strand == null) {
            return null;
        }
        try {
            return strand.makeMarkerRangeFromPositions(start_base_position, end_base_position);
        }
        catch (OutOfRangeException outOfRangeException) {
            return null;
        }
    }

    private int adjustBasePositionForFrame(int frame_id, int base_position, boolean get_start) {
        int return_base_position;
        int end_offset = get_start ? 0 : 2;
        switch (frame_id) {
            case 0: 
            case 7: {
                int base_pos_mod3 = (base_position - 1) % 3;
                return_base_position = base_position + end_offset - base_pos_mod3;
                break;
            }
            case 1: 
            case 6: {
                int base_pos_mod3 = (base_position - 2) % 3;
                return_base_position = base_position + end_offset - base_pos_mod3;
                break;
            }
            case 2: 
            case 5: {
                int base_pos_mod3 = (base_position - 3) % 3;
                return_base_position = base_position + end_offset - base_pos_mod3;
                break;
            }
            default: {
                return_base_position = base_position;
            }
        }
        return return_base_position;
    }

    private void drawFeature(Graphics g, Feature feature, boolean draw_feature_fill, FeatureVector selected_features, FeatureSegmentVector selected_segments) {
        boolean highlight_feature_flag;
        FeatureSegmentVector this_feature_segments = feature.getSegments();
        if (this_feature_segments.size() == 0) {
            return;
        }
        if (selected_features.contains(feature)) {
            highlight_feature_flag = true;
        } else {
            if (!this.show_feature_borders && !draw_feature_fill) {
                return;
            }
            highlight_feature_flag = false;
        }
        int i = 0;
        while (i < this_feature_segments.size()) {
            FeatureSegment current_segment = this_feature_segments.elementAt(i);
            boolean highlight_segment_flag = selected_segments.indexOf(current_segment) != -1;
            boolean draw_direction_arrow_flag = i == this_feature_segments.size() - 1 && this.show_feature_arrows;
            this.drawSegment(g, current_segment, highlight_feature_flag, highlight_segment_flag, draw_feature_fill, draw_direction_arrow_flag);
            if (i + 1 < this_feature_segments.size()) {
                FeatureSegment next_segment = this_feature_segments.elementAt(i + 1);
                this.drawSegmentConnection(g, current_segment, next_segment);
            }
            ++i;
        }
        if (draw_feature_fill) {
            this.drawFeatureLabel(g, feature);
        }
        Thread.yield();
    }

    private void drawSegmentConnection(Graphics g, FeatureSegment lower_segment, FeatureSegment upper_segment) {
        int next_segment_vertical_offset;
        int this_segment_vertical_offset;
        int this_segment_end_coord;
        Marker upper_segment_start_marker = upper_segment.getStart();
        Marker lower_segment_end_marker = lower_segment.getEnd();
        int next_segment_start_coord = this.getLowXPositionOfMarker(upper_segment_start_marker);
        if (next_segment_start_coord > 16000) {
            next_segment_start_coord = 16000;
        }
        if (next_segment_start_coord < -16000) {
            next_segment_start_coord = -16000;
        }
        if ((this_segment_end_coord = this.getHighXPositionOfMarker(lower_segment_end_marker)) > 16000) {
            this_segment_end_coord = 16000;
        }
        if (this_segment_end_coord < -16000) {
            this_segment_end_coord = -16000;
        }
        int line_y_position_for_centre = (this_segment_vertical_offset = this.getSegmentVerticalOffset(lower_segment)) < (next_segment_vertical_offset = this.getSegmentVerticalOffset(upper_segment)) ? this_segment_vertical_offset : next_segment_vertical_offset;
        int line_y_position_for_this = this_segment_vertical_offset + this.getFeatureHeight() / 2;
        int line_y_position_for_next = next_segment_vertical_offset + this.getFeatureHeight() / 2;
        int horizontal_position_of_centre = (this_segment_end_coord + next_segment_start_coord) / 2;
        Feature segment_feature = lower_segment.getFeature();
        Color feature_colour = segment_feature.getColour();
        if (feature_colour == null || this.getSelection().contains(lower_segment.getFeature())) {
            g.setColor(Color.black);
        } else {
            g.setColor(feature_colour);
        }
        g.drawLine(this_segment_end_coord, line_y_position_for_this, horizontal_position_of_centre, line_y_position_for_centre);
        g.drawLine(horizontal_position_of_centre, line_y_position_for_centre, next_segment_start_coord, line_y_position_for_next);
    }

    private void drawFeatureLabel(Graphics g, Feature feature) {
        int label_x_coord;
        if (!this.show_labels && this.getScaleFactor() == 0) {
            return;
        }
        String label_or_gene = feature.getIDString();
        String label = feature.getLabel();
        if (label != null && label.equals("*")) {
            label_or_gene = "";
        }
        if (label_or_gene.length() == 0) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int string_width = fm.stringWidth(label_or_gene);
        FeatureSegment first_segment = feature.getSegments().elementAt(0);
        if (feature.isForwardFeature() ^ this.isRevCompDisplay()) {
            int segment_start_pos = first_segment.getStart().getRawPosition();
            if (this.isRevCompDisplay()) {
                segment_start_pos = this.getSequenceLength() - segment_start_pos + 1;
            }
            label_x_coord = this.getLowXPositionOfBase(segment_start_pos);
        } else {
            int segment_end_pos = first_segment.getEnd().getRawPosition();
            if (this.isRevCompDisplay()) {
                segment_end_pos = this.getSequenceLength() - segment_end_pos + 1;
            }
            label_x_coord = this.getLowXPositionOfBase(segment_end_pos);
        }
        if (label_x_coord >= this.getCanvas().getSize().width) {
            return;
        }
        int vertical_offset = this.getSegmentVerticalOffset(first_segment);
        if (this.show_labels) {
            vertical_offset += this.getLineHeight();
        }
        Shape saved_clip = g.getClip();
        if (this.show_labels) {
            g.setColor(Color.white);
            g.fillRect(label_x_coord - this.getFontWidth(), vertical_offset, string_width + this.getFontWidth() * 2, this.getLineHeight());
        } else {
            int segment_start_coord = this.getSegmentStartCoord(first_segment);
            int segment_end_coord = this.getSegmentEndCoord(first_segment);
            if (Math.abs(segment_end_coord - segment_start_coord) > 5) {
                if (segment_end_coord > segment_start_coord) {
                    g.setClip(segment_start_coord, vertical_offset, segment_end_coord - segment_start_coord, this.getFeatureHeight());
                } else {
                    g.setClip(segment_end_coord, vertical_offset, segment_start_coord - segment_end_coord, this.getFeatureHeight());
                }
            } else {
                return;
            }
        }
        g.setColor(Color.black);
        g.setFont(this.getFont());
        g.drawString(label_or_gene, label_x_coord + 1, vertical_offset + this.getFontAscent() + 1);
        if (!this.show_labels) {
            g.setClip(saved_clip);
        }
    }

    private int getSegmentStartCoord(FeatureSegment segment) {
        Marker segment_start_marker = segment.getStart();
        int segment_start_coord = this.getLowXPositionOfMarker(segment_start_marker);
        if (segment_start_coord > this.getCanvas().getSize().width) {
            segment_start_coord = this.getCanvas().getSize().width;
        }
        if (segment_start_coord < 0) {
            segment_start_coord = -1;
        }
        return segment_start_coord;
    }

    private int getSegmentEndCoord(FeatureSegment segment) {
        Marker segment_end_marker = segment.getEnd();
        int segment_end_coord = this.getHighXPositionOfMarker(segment_end_marker);
        if (segment_end_coord > this.getCanvas().getSize().width) {
            segment_end_coord = this.getCanvas().getSize().width;
        }
        if (segment_end_coord < 0) {
            segment_end_coord = -1;
        }
        return segment_end_coord;
    }

    private boolean baseVisible(Marker marker) {
        int first_visible_base = this.getForwardBaseAtLeftEdge();
        int last_visible_base = this.getLastVisibleForwardBase();
        int marker_position = marker.getRawPosition();
        if (this.isRevCompDisplay()) {
            marker_position = this.getBases().getComplementPosition(marker_position);
        }
        return marker_position >= first_visible_base && marker_position <= last_visible_base;
    }

    private boolean segmentVisible(FeatureSegment segment) {
        int segment_start_coord = this.getSegmentStartCoord(segment);
        int segment_end_coord = this.getSegmentEndCoord(segment);
        return (segment_end_coord >= 0 || segment_start_coord >= 0) && (segment_start_coord < this.getCanvas().getSize().width || segment_end_coord < this.getCanvas().getSize().width);
    }

    private boolean featureVisible(Feature feature) {
        int feature_score;
        if (this.getMinimumScore() > 0 && (feature_score = feature.getScore()) != -1 && feature_score < this.getMinimumScore()) {
            return false;
        }
        FeatureSegmentVector segments = feature.getSegments();
        int i = 0;
        while (i < segments.size()) {
            if (this.segmentVisible(segments.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void drawSegment(Graphics g, FeatureSegment segment, boolean highlight_feature, boolean highlight_segment, boolean draw_feature_fill, boolean draw_arrow) {
        if (!this.segmentVisible(segment)) {
            return;
        }
        Feature segment_feature = segment.getFeature();
        int vertical_offset = this.getSegmentVerticalOffset(segment) + 1;
        int segment_start_coord = this.getSegmentStartCoord(segment);
        int segment_end_coord = this.getSegmentEndCoord(segment);
        int segment_height = this.getFeatureHeight() - 1;
        int feature_direction = segment.getFeature().isForwardFeature() ^ this.isRevCompDisplay() ? 1 : -1;
        int[] x_points = new int[]{segment_start_coord, segment_end_coord, segment_end_coord, segment_start_coord};
        int[] y_points = new int[]{vertical_offset, vertical_offset, vertical_offset + segment_height, vertical_offset + segment_height};
        if (draw_feature_fill) {
            Color feature_colour = segment_feature.getColour();
            if (feature_colour == null) {
                g.setColor(Color.white);
            } else {
                g.setColor(feature_colour);
            }
            if (segment_feature.isForwardFeature() ^ this.isRevCompDisplay()) {
                int segment_width = segment_end_coord - segment_start_coord + 1;
                g.fillRect(segment_start_coord, vertical_offset, segment_width, segment_height + 1);
            } else {
                int segment_width = segment_start_coord - segment_end_coord + 1;
                g.fillRect(segment_end_coord, vertical_offset, segment_width, segment_height + 1);
            }
        } else {
            g.setColor(Color.black);
            g.drawPolygon(x_points, y_points, 4);
            if (highlight_feature) {
                x_points[0] = x_points[0] - feature_direction;
                x_points[1] = x_points[1] + feature_direction;
                x_points[2] = x_points[2] + feature_direction;
                x_points[3] = x_points[3] - feature_direction;
                y_points[0] = y_points[0] - 1;
                y_points[1] = y_points[1] - 1;
                y_points[2] = y_points[2] + 1;
                y_points[3] = y_points[3] + 1;
                g.drawPolygon(x_points, y_points, 4);
                x_points[0] = x_points[0] - feature_direction;
                x_points[1] = x_points[1] + feature_direction;
                x_points[2] = x_points[2] + feature_direction;
                x_points[3] = x_points[3] - feature_direction;
                y_points[0] = y_points[0] - 1;
                y_points[1] = y_points[1] - 1;
                y_points[2] = y_points[2] + 1;
                y_points[3] = y_points[3] + 1;
                g.drawPolygon(x_points, y_points, 4);
                if (highlight_segment) {
                    x_points[0] = x_points[0] - feature_direction;
                    x_points[1] = x_points[1] + feature_direction;
                    x_points[2] = x_points[2] + feature_direction;
                    x_points[3] = x_points[3] - feature_direction;
                    y_points[0] = y_points[0] - 1;
                    y_points[1] = y_points[1] - 1;
                    y_points[2] = y_points[2] + 1;
                    y_points[3] = y_points[3] + 1;
                    g.drawPolygon(x_points, y_points, 4);
                    x_points[0] = x_points[0] - feature_direction;
                    x_points[1] = x_points[1] + feature_direction;
                    x_points[2] = x_points[2] + feature_direction;
                    x_points[3] = x_points[3] - feature_direction;
                    y_points[0] = y_points[0] - 1;
                    y_points[1] = y_points[1] - 1;
                    y_points[2] = y_points[2] + 1;
                    y_points[3] = y_points[3] + 1;
                    g.drawPolygon(x_points, y_points, 4);
                }
            }
            if (draw_arrow) {
                int arrow_tip_x = x_points[1] + feature_direction * this.getFontWidth() * 8 / 10;
                int arrow_tip_y = (y_points[1] + y_points[2]) / 2;
                g.drawLine(x_points[1], y_points[1], arrow_tip_x, arrow_tip_y);
                g.drawLine(arrow_tip_x, arrow_tip_y, x_points[2], y_points[2]);
            }
        }
    }

    private void drawBaseSelection(Graphics g) {
        Marker raw_end_base;
        Marker raw_start_base;
        MarkerRange selection_range = this.getSelection().getMarkerRange();
        if (selection_range == null) {
            return;
        }
        if (selection_range.getStrand().isForwardStrand()) {
            raw_start_base = selection_range.getRawStart();
            raw_end_base = selection_range.getRawEnd();
        } else {
            raw_start_base = selection_range.getRawEnd();
            raw_end_base = selection_range.getRawStart();
        }
        int start_coord = this.getLowXPositionOfMarker(raw_start_base);
        int end_coord = this.getHighXPositionOfMarker(raw_end_base);
        if (start_coord > this.getCanvas().getSize().width && end_coord > this.getCanvas().getSize().width) {
            return;
        }
        if (start_coord < 0 && end_coord < 0) {
            return;
        }
        int strand_id = selection_range.getStrand().isForwardStrand() ^ this.isRevCompDisplay() ? 3 : 4;
        if (!this.getOneLinePerEntryFlag()) {
            int frame_id;
            if (selection_range.getStrand().isForwardStrand() ^ this.isRevCompDisplay()) {
                switch ((selection_range.getStart().getPosition() - 1) % 3) {
                    case 0: {
                        frame_id = 0;
                        break;
                    }
                    case 1: {
                        frame_id = 1;
                        break;
                    }
                    case 2: {
                        frame_id = 2;
                        break;
                    }
                    default: {
                        frame_id = -1;
                        break;
                    }
                }
            } else {
                switch ((selection_range.getStart().getPosition() - 1) % 3) {
                    case 0: {
                        frame_id = 7;
                        break;
                    }
                    case 1: {
                        frame_id = 6;
                        break;
                    }
                    case 2: {
                        frame_id = 5;
                        break;
                    }
                    default: {
                        frame_id = -1;
                    }
                }
            }
            if (this.show_forward_lines && strand_id == 3 || this.show_reverse_lines && strand_id == 4) {
                this.drawBaseRange(g, start_coord, end_coord, frame_id, Color.pink);
            }
        }
        this.drawBaseRange(g, start_coord, end_coord, strand_id, Color.yellow);
    }

    private void drawBaseRange(Graphics g, int start_coord, int end_coord, int frame_id, Color fill_colour) {
        if (start_coord < -1) {
            start_coord = -1;
        }
        if (end_coord < -1) {
            end_coord = -1;
        }
        if (end_coord > this.getCanvasWidth()) {
            end_coord = this.getCanvasWidth();
        }
        if (start_coord > this.getCanvasWidth()) {
            start_coord = this.getCanvasWidth();
        }
        int frame_line = this.getFrameDisplayLine(frame_id);
        int frame_line_y_coord = this.getLineOffset(frame_line);
        int[] x_points = new int[]{start_coord, end_coord, end_coord, start_coord};
        int[] y_points = new int[]{frame_line_y_coord, frame_line_y_coord, frame_line_y_coord + this.getFeatureHeight() + 1, frame_line_y_coord + this.getFeatureHeight() + 1};
        g.setColor(fill_colour);
        if (start_coord > end_coord) {
            g.fillRect(end_coord, frame_line_y_coord + 1, start_coord - end_coord + 1, this.getFeatureHeight());
        } else {
            g.fillRect(start_coord, frame_line_y_coord + 1, end_coord - start_coord + 1, this.getFeatureHeight());
        }
        g.setColor(Color.black);
        g.drawPolygon(x_points, y_points, 4);
    }

    private int buttonDownCount(MouseEvent event) {
        int count = 0;
        if ((event.getModifiers() & 0x10) > 0) {
            ++count;
        }
        if ((event.getModifiers() & 8) > 0) {
            ++count;
        }
        if ((event.getModifiers() & 4) > 0) {
            ++count;
        }
        return count;
    }

    private void addListeners() {
        this.getCanvas().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (FeatureDisplay.this.click_segment_marker != null) {
                    FeatureDisplay.this.getEntryGroup().getActionController().endAction();
                    FeatureDisplay.this.click_segment_marker = null;
                }
                if (FeatureDisplay.this.buttonDownCount(event) > 1) {
                    return;
                }
                FeatureDisplay.this.last_mouse_press_event = event;
                FeatureDisplay.this.handleCanvasMousePress(event);
                if (FeatureDisplay.this.isMenuTrigger(event)) {
                    FeaturePopup popup = new FeaturePopup(FeatureDisplay.this, FeatureDisplay.this.getEntryGroup(), FeatureDisplay.this.getSelection(), FeatureDisplay.this.getGotoEventSource(), FeatureDisplay.this.getBasePlotGroup());
                    JComponent parent = (JComponent)event.getSource();
                    parent.add(popup);
                    popup.show(parent, event.getX(), event.getY());
                }
            }

            public void mouseReleased(MouseEvent event) {
                FeatureDisplay.this.last_mouse_press_event = null;
                if (FeatureDisplay.this.click_segment_marker != null) {
                    FeatureDisplay.this.getEntryGroup().getActionController().endAction();
                    FeatureDisplay.this.click_segment_marker = null;
                }
            }
        });
        this.getCanvas().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent event) {
                if (FeatureDisplay.this.last_mouse_press_event != null && !FeatureDisplay.this.isMenuTrigger(FeatureDisplay.this.last_mouse_press_event)) {
                    FeatureDisplay.this.handleCanvasMouseDrag(event);
                }
            }
        });
        this.getCanvas().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                FeatureDisplay.handleKeyPress(FeatureDisplay.this, event);
            }
        });
    }

    private void handleCanvasMousePress(MouseEvent event) {
        if (event.getID() != 501) {
            return;
        }
        this.getCanvas().requestFocus();
        if (event.getClickCount() == 2) {
            this.handleCanvasDoubleClick(event);
        } else {
            this.handleCanvasSingleClick(event);
        }
        this.getCanvas().repaint();
    }

    private void handleCanvasDoubleClick(MouseEvent event) {
        if (this.isMenuTrigger(event)) {
            return;
        }
        if ((event.getModifiers() & 8) != 0 || event.isAltDown()) {
            Selectable clicked_thing = this.getThingAtPoint(event.getPoint());
            if (clicked_thing == null) {
                MarkerRange new_click_range = this.getMarkerRangeFromPosition(event.getPoint());
                if (new_click_range == null) {
                    return;
                }
                MarkerRange orf_range = Strand.getORFAroundMarker(new_click_range.getStart(), true);
                if (orf_range == null) {
                    return;
                }
                this.getSelection().setMarkerRange(orf_range);
            } else {
                Feature clicked_feature = this.getFeatureOf(clicked_thing);
                this.getSelection().set(clicked_feature);
                if (Options.readWritePossible()) {
                    new FeatureEdit(clicked_feature, this.getEntryGroup(), this.getSelection(), this.getGotoEventSource()).show();
                }
            }
        }
        this.makeSelectionVisible();
    }

    private void handleCanvasSingleClick(MouseEvent event) {
        this.click_segment_marker = null;
        Selectable clicked_thing = this.getThingAtPoint(event.getPoint());
        if (clicked_thing == null || (event.getModifiers() & 8) != 0) {
            if (this.isMenuTrigger(event)) {
                return;
            }
            if (event.isShiftDown() && this.getSelection().getAllFeatures().size() > 0) {
                return;
            }
            MarkerRange old_selected_range = this.getSelection().getMarkerRange();
            MarkerRange new_click_range = this.getMarkerRangeFromPosition(event.getPoint());
            if (new_click_range == null) {
                this.click_range = null;
                this.getSelection().clear();
                return;
            }
            MarkerRange new_selection_range = !event.isShiftDown() || old_selected_range == null ? new_click_range : (old_selected_range.getStrand() == new_click_range.getStrand() ? old_selected_range.combineRanges(new_click_range, true) : old_selected_range);
            this.getSelection().setMarkerRange(new_selection_range);
            this.click_range = new_selection_range;
        } else {
            if (this.getSelection().getMarkerRange() != null && event.isShiftDown()) {
                return;
            }
            this.click_range = null;
            this.getSelection().setMarkerRange(null);
            Feature clicked_feature = this.getFeatureOf(clicked_thing);
            this.raiseFeature(clicked_feature);
            if (clicked_thing instanceof Feature) {
                if (this.getSelection().contains(clicked_feature)) {
                    if (!this.isMenuTrigger(event)) {
                        if (event.isShiftDown()) {
                            this.getSelection().remove(clicked_feature);
                        } else {
                            this.getSelection().set(clicked_feature);
                        }
                    }
                } else if (event.isShiftDown()) {
                    this.getSelection().add(clicked_feature);
                } else {
                    this.getSelection().set(clicked_feature);
                }
            } else {
                FeatureSegment clicked_segment = (FeatureSegment)clicked_thing;
                FeatureSegmentVector selected_feature_segments = this.getSelection().getSelectedSegments();
                if (selected_feature_segments.contains(clicked_segment)) {
                    if (!this.isMenuTrigger(event)) {
                        if (event.isShiftDown()) {
                            this.getSelection().remove(clicked_segment);
                        } else {
                            this.getSelection().set(clicked_segment);
                        }
                    }
                } else if (event.isShiftDown()) {
                    FeatureVector selected_features = this.getSelection().getSelectedFeatures();
                    if (selected_features.contains(clicked_feature)) {
                        this.getSelection().remove(clicked_feature);
                    } else {
                        this.getSelection().add(clicked_segment);
                    }
                } else {
                    this.getSelection().set(clicked_segment);
                }
            }
            if (Options.getOptions().canDirectEdit() && !clicked_feature.isReadOnly()) {
                MarkerRange new_click_range = this.getMarkerRangeFromPosition(event.getPoint(), false);
                FeatureSegmentVector segments = clicked_feature.getSegments();
                int i = 0;
                while (i < segments.size()) {
                    FeatureSegment this_segment = segments.elementAt(i);
                    if (new_click_range.getStart().equals(this_segment.getStart()) && this_segment.canDirectEdit()) {
                        this.click_segment_marker = this_segment.getStart();
                        this.click_segment_marker_is_start_marker = true;
                        this.other_end_of_segment_marker = this_segment.getEnd();
                        this.getEntryGroup().getActionController().startAction();
                        break;
                    }
                    if (new_click_range.getEnd().equals(this_segment.getEnd()) && this_segment.canDirectEdit()) {
                        this.click_segment_marker = this_segment.getEnd();
                        this.click_segment_marker_is_start_marker = false;
                        this.other_end_of_segment_marker = this_segment.getStart();
                        this.getEntryGroup().getActionController().startAction();
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private Feature getFeatureOf(Object object) {
        if (object instanceof Feature) {
            return (Feature)object;
        }
        return ((FeatureSegment)object).getFeature();
    }

    private void handleMarkerDrag(MouseEvent event) {
        int new_position;
        MarkerRange drag_range = this.getMarkerRangeFromPosition(event.getPoint(), false);
        if (drag_range == null) {
            return;
        }
        if (this.click_segment_marker_is_start_marker ? (new_position = drag_range.getStart().getPosition()) > this.other_end_of_segment_marker.getPosition() : (new_position = drag_range.getEnd().getPosition()) < this.other_end_of_segment_marker.getPosition()) {
            return;
        }
        try {
            this.click_segment_marker.setPosition(new_position);
            if (!this.baseVisible(this.click_segment_marker)) {
                this.makeBaseVisible(this.click_segment_marker);
            }
        }
        catch (OutOfRangeException outOfRangeException) {
            throw new Error("internal error - unexpected OutOfRangeException");
        }
    }

    private void handleCanvasMouseDrag(MouseEvent event) {
        if (event.isShiftDown() && this.getSelection().getAllFeatures().size() > 0) {
            return;
        }
        if (this.click_segment_marker != null) {
            this.handleMarkerDrag(event);
            return;
        }
        MarkerRange drag_range = this.getMarkerRangeFromPosition(event.getPoint());
        if (drag_range == null) {
            return;
        }
        MarkerRange selected_range = this.getSelection().getMarkerRange();
        if (selected_range != null && drag_range.getStrand() != selected_range.getStrand()) {
            return;
        }
        try {
            if (drag_range.getStart().getPosition() < 1) {
                drag_range = new MarkerRange(drag_range.getStrand(), 1, 1);
            }
            if (drag_range.getEnd().getPosition() > this.getSequenceLength()) {
                drag_range = new MarkerRange(drag_range.getStrand(), this.getSequenceLength(), this.getSequenceLength());
            }
        }
        catch (OutOfRangeException outOfRangeException) {
            throw new Error("internal error - unexpected OutOfRangeException");
        }
        boolean start_base_is_visible = this.baseVisible(drag_range.getStart());
        boolean end_base_is_visible = this.baseVisible(drag_range.getEnd());
        if (!start_base_is_visible) {
            this.makeBaseVisible(drag_range.getStart());
        }
        if (!end_base_is_visible) {
            this.makeBaseVisible(drag_range.getEnd());
        }
        if (!start_base_is_visible || !end_base_is_visible) {
            this.needVisibleFeatureVectorUpdate();
        }
        MarkerRange new_marker_range = this.click_range == null ? drag_range : selected_range.combineRanges(drag_range, true);
        this.getSelection().setMarkerRange(new_marker_range);
        this.getCanvas().repaint();
    }

    private Selectable getThingAtPoint(Point p) {
        int line_of_point = this.getLineFromPoint(p);
        if (line_of_point == -1) {
            return null;
        }
        int i = this.getVisibleFeatures().size() - 1;
        while (i >= 0) {
            Feature current_feature = this.getVisibleFeatures().elementAt(i);
            FeatureSegmentVector segments = current_feature.getSegments();
            int segment_index = 0;
            while (segment_index < segments.size()) {
                FeatureSegment current_segment = segments.elementAt(segment_index);
                int line_of_segment = this.getSegmentDisplayLine(current_segment);
                if ((line_of_segment == line_of_point || this.show_labels && line_of_segment + 1 == line_of_point) && (p.x >= this.getSegmentStartCoord(current_segment) && p.x <= this.getSegmentEndCoord(current_segment) || p.x <= this.getSegmentStartCoord(current_segment) && p.x >= this.getSegmentEndCoord(current_segment))) {
                    Feature segment_feature = current_segment.getFeature();
                    if (segment_feature.getSegments().size() == 1) {
                        return segment_feature;
                    }
                    return current_segment;
                }
                ++segment_index;
            }
            --i;
        }
        return null;
    }

    private void createScrollbar(boolean scrollbar_at_top) {
        this.scrollbar = new JScrollBar(0);
        this.scrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (FeatureDisplay.this.left_edge_base != e.getValue()) {
                    if (e.getValue() < FeatureDisplay.this.getSequenceLength()) {
                        FeatureDisplay.this.left_edge_base = e.getValue();
                    } else {
                        if (FeatureDisplay.this.left_edge_base == FeatureDisplay.this.getSequenceLength()) {
                            return;
                        }
                        FeatureDisplay.this.left_edge_base = FeatureDisplay.this.getSequenceLength();
                    }
                    FeatureDisplay.this.fireAdjustmentEvent(1);
                    FeatureDisplay.this.needVisibleFeatureVectorUpdate();
                    FeatureDisplay.this.getCanvas().repaint();
                }
            }
        });
        if (scrollbar_at_top) {
            this.getMidPanel().add((Component)this.scrollbar, "North");
        } else {
            this.getMidPanel().add((Component)this.scrollbar, "South");
        }
        this.fixScrollbar();
        this.fireAdjustmentEvent(3);
    }

    void fireAdjustmentEvent(int type) {
        if (this.disable_display_events) {
            return;
        }
        DisplayAdjustmentEvent event = new DisplayAdjustmentEvent(this, this.getForwardBaseAtLeftEdge(), this.getLastVisibleForwardBase(), this.getMaxVisibleBases(), this.getScaleValue(), this.getScaleFactor(), this.isRevCompDisplay(), type);
        this.fireAction(this.adjustment_listener_list, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(Vector listeners, ChangeEvent event) {
        Vector targets;
        FeatureDisplay featureDisplay = this;
        synchronized (featureDisplay) {
            targets = (Vector)listeners.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            ChangeListener change_listener = (ChangeListener)targets.elementAt(i);
            DisplayAdjustmentListener target = (DisplayAdjustmentListener)change_listener;
            target.displayAdjustmentValueChanged((DisplayAdjustmentEvent)event);
            ++i;
        }
    }

    private void createScaleScrollbar() {
        this.scale_changer = new JScrollBar(1);
        int MAX_FACTOR = (int)Math.round(Math.log(this.getSequenceLength() / 20) / Math.log(3.0));
        this.scale_changer.setValues(this.getScaleFactor(), 1, 0, MAX_FACTOR);
        this.scale_changer.setBlockIncrement(1);
        this.scale_changer.setUnitIncrement(1);
        this.scale_changer.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                FeatureDisplay.this.setScaleFactor(e.getValue());
            }
        });
        this.add((Component)this.scale_changer, "East");
        if (this.scale_factor >= MAX_FACTOR) {
            this.setScaleFactor(MAX_FACTOR - 1);
        }
    }

    private void fixScrollbar() {
        if (this.scrollbar == null) {
            return;
        }
        int sequence_length = this.getSequenceLength();
        int max_visible_bases = this.getMaxVisibleBases() > 0 ? this.getMaxVisibleBases() : 1;
        this.scrollbar.setValues(this.getForwardBaseAtLeftEdge(), max_visible_bases, this.hard_left_edge ? 1 : -max_visible_bases / 2, sequence_length + max_visible_bases / 2);
        this.scrollbar.setBlockIncrement(max_visible_bases);
        if (max_visible_bases >= 10 && this.getScaleFactor() > 0) {
            this.scrollbar.setUnitIncrement(max_visible_bases / 10);
        } else {
            this.scrollbar.setUnitIncrement(1);
        }
    }

    private void fixCanvasSize() {
        int new_width = this.getCanvas().getSize().width;
        int new_height = this.getLineHeight() * this.getLineCount();
        if (new_height != this.getCanvas().getSize().width || new_width != this.getCanvas().getSize().height) {
            Dimension preferred_size = new Dimension(this.getCanvas().getSize().width, new_height);
            this.getCanvas().setPreferredSize(preferred_size);
            Dimension minimum_size = new Dimension(1, new_height);
            this.getCanvas().setMinimumSize(minimum_size);
            this.getCanvas().revalidate();
            this.getCanvas().repaint();
        }
    }

    public int getSequenceLength() {
        return this.getEntryGroup().getSequenceLength();
    }

    private void setFirstVisibleForwardBase(int new_position) {
        if (this.left_edge_base != new_position) {
            this.left_edge_base = new_position;
            if (this.scrollbar != null) {
                this.scrollbar.setValue(new_position);
            }
            this.needVisibleFeatureVectorUpdate();
            this.getCanvas().repaint();
        }
    }

    private int getLineHeight() {
        return this.getFontHeight();
    }

    public int getScaleFactor() {
        return this.scale_factor;
    }

    private int getFirstLineID() {
        if (this.show_forward_lines) {
            return 0;
        }
        return 3;
    }

    private int getLastLineID() {
        if (this.show_reverse_lines) {
            return 7;
        }
        return 4;
    }

    private int getLineFromPoint(Point point) {
        if (point.y >= this.getCanvasHeight()) {
            return -1;
        }
        int return_value = point.y / this.getLineHeight();
        if (return_value < 0) {
            return -1;
        }
        return return_value;
    }

    private int getFrameFromPoint(Point point) {
        if (this.getOneLinePerEntryFlag()) {
            int line_point = this.getLineFromPoint(point);
            if (line_point == this.getFrameDisplayLine(3) ^ this.isRevCompDisplay()) {
                return 3;
            }
            if (line_point == this.getFrameDisplayLine(4) ^ this.isRevCompDisplay()) {
                return 4;
            }
        } else {
            int start_frame = this.getFirstLineID();
            int end_frame = this.getLastLineID();
            int i = start_frame;
            while (i <= end_frame) {
                int top_of_line = this.getLineOffset(this.getFrameDisplayLine(i));
                int line_height = this.show_labels ? this.getLineHeight() * 2 : this.getLineHeight();
                if (point.y >= top_of_line && point.y < top_of_line + line_height) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getFirstVisibleForwardBase() {
        if (this.left_edge_base < 1) {
            return 1;
        }
        return this.left_edge_base;
    }

    public int getForwardBaseAtLeftEdge() {
        return this.left_edge_base;
    }

    private Marker getFirstVisibleForwardBaseMarker() {
        try {
            Strand strand = this.isRevCompDisplay() ? this.getBases().getReverseStrand() : this.getBases().getForwardStrand();
            return strand.makeMarker(this.getFirstVisibleForwardBase());
        }
        catch (OutOfRangeException outOfRangeException) {
            throw new Error("internal error - unexpected OutOfRangeException");
        }
    }

    public int getLastVisibleForwardBase() {
        int possible_last_base = this.getForwardBaseAtLeftEdge() + this.getMaxVisibleBases();
        if (possible_last_base > this.getSequenceLength()) {
            return this.getSequenceLength();
        }
        if (possible_last_base > 0) {
            return possible_last_base;
        }
        return 1;
    }

    private int getFirstVisibleReverseBase() {
        int last_forward_base = this.getLastVisibleForwardBase();
        return this.getBases().getComplementPosition(last_forward_base);
    }

    private int getLastVisibleReverseBase() {
        int first_forward_base = this.getFirstVisibleForwardBase();
        return this.getBases().getComplementPosition(first_forward_base);
    }

    private int getCentreForwardBase() {
        int possible_return_position = this.getForwardBaseAtLeftEdge() + this.getMaxVisibleBases() / 2;
        int return_position = possible_return_position < this.getSequenceLength() ? possible_return_position : this.getSequenceLength();
        return return_position;
    }

    float getScaleValue() {
        return this.scale_value;
    }

    private int getFeatureHeight() {
        return this.getFontAscent() + 2;
    }

    public int getMaxVisibleBases() {
        return (int)((float)this.getCanvasWidth() / this.getScaleValue());
    }

    public Bases getBases() {
        return this.getEntryGroup().getBases();
    }

    private void setScaleValue() {
        int scale_factor = this.getScaleFactor();
        this.scale_value = scale_factor > 0 ? (float)(1.0 / Math.pow(3.0, scale_factor - 1)) : (float)this.getFontWidth();
    }

    public void setFirstAndLastBase(int first, int last) {
        this.left_edge_base = first;
        this.setScaleValue(1.0f * (float)this.getCanvasWidth() / (float)(last - first + 1));
    }

    public void setFirstBase(int base_position) {
        if (base_position > this.getSequenceLength()) {
            base_position = this.getSequenceLength();
        }
        if (base_position < 1 && this.hard_left_edge) {
            base_position = 1;
        }
        this.setFirstVisibleForwardBase(base_position);
        this.fireAdjustmentEvent(1);
    }

    private void setScaleValue(float scale_value) {
        if (scale_value <= 0.0f) {
            throw new Error("internal error in FeatureDisplay.setScaleValue() - scale value must be positive");
        }
        this.scale_value = scale_value;
        this.scale_factor = scale_value > 1.0f ? 1 : (int)Math.round(Math.log(1.0f / scale_value) / Math.log(3.0)) + 1;
        this.scale_changer.setValue(this.scale_factor);
        this.fixScrollbar();
        this.needVisibleFeatureVectorUpdate();
        this.getCanvas().repaint();
        this.fireAdjustmentEvent(0);
    }

    private Range newRange(int start, int end) {
        try {
            return new Range(start, end);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    private void needVisibleFeatureVectorUpdate() {
        this.update_visible_features = true;
    }
}

