/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import uk.ac.sanger.artemis.Options;

public class FileViewer
extends JFrame {
    private JButton close_button;
    private JPanel button_panel;
    private JTextArea text_area = null;
    private static Dimension saved_size = null;
    private static Point saved_position = null;

    public FileViewer(String label) {
        this(label, true);
    }

    public FileViewer(String label, boolean visible) {
        super(label);
        this.getContentPane().setLayout(new BorderLayout());
        Font font = Options.getOptions().getFont();
        this.setFont(font);
        this.text_area = new JTextArea(18, 90);
        this.text_area.setEditable(false);
        this.text_area.setFont(font);
        this.text_area.setBackground(Color.white);
        this.getContentPane().add((Component)new JScrollPane(this.text_area), "Center");
        this.button_panel = new JPanel();
        this.getContentPane().add((Component)this.button_panel, "South");
        this.close_button = new JButton("Close");
        this.close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileViewer.this.dispose();
            }
        });
        this.button_panel.add(this.close_button);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                FileViewer.this.dispose();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                saved_size = FileViewer.this.getSize();
                saved_position = FileViewer.this.getLocation();
            }

            public void componentMoved(ComponentEvent e) {
                saved_size = FileViewer.this.getSize();
                saved_position = FileViewer.this.getLocation();
            }
        });
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (saved_position == null) {
            int screen_height = screen.height;
            int screen_width = screen.width;
            if (screen_width <= 800 || screen_height <= 700) {
                this.setSize(screen_width * 9 / 10, screen_height * 9 / 10);
            } else {
                this.setSize(800, 700);
            }
            this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        } else {
            if (FileViewer.saved_position.x < 0 || FileViewer.saved_position.x + 20 > screen.width) {
                FileViewer.saved_position.x = 20;
            }
            if (FileViewer.saved_position.y < 0 || FileViewer.saved_position.y + 20 > screen.height) {
                FileViewer.saved_position.y = 20;
            }
            if (FileViewer.saved_size.width < 50) {
                FileViewer.saved_size.width = 50;
            }
            if (FileViewer.saved_size.height < 50) {
                FileViewer.saved_size.height = 50;
            }
            this.setLocation(saved_position);
            this.setSize(saved_size);
        }
        this.setVisible(visible);
    }

    public void clear() {
        this.text_area.setText("");
    }

    public void appendFile(Reader read_stream) throws IOException {
        String line;
        BufferedReader buffered_reader = new BufferedReader(read_stream);
        while ((line = buffered_reader.readLine()) != null) {
            this.appendString(String.valueOf(line) + "\n");
            Thread.yield();
        }
        buffered_reader.close();
    }

    public void readFile(Reader read_stream) throws IOException {
        String line;
        BufferedReader buffered_reader = new BufferedReader(read_stream);
        StringBuffer line_buffer = new StringBuffer();
        while ((line = buffered_reader.readLine()) != null) {
            line_buffer.append(line).append('\n');
        }
        buffered_reader.close();
        String new_text = line_buffer.toString();
        this.text_area.setText(new_text);
        this.text_area.setCaretPosition(0);
    }

    public void setText(String read_string) {
        if (!read_string.equals(this.text_area.getText())) {
            this.text_area.setText(read_string);
            this.text_area.setCaretPosition(0);
        }
    }

    public void appendString(String read_string) {
        this.text_area.append(read_string);
        this.text_area.getCaret().setDot(0);
    }

    public String getText() {
        return this.getTextArea().getText();
    }

    public void dispose() {
        this.setVisible(false);
        saved_size = this.getSize();
        saved_position = this.getLocation();
        super.dispose();
    }

    public JTextArea getTextArea() {
        return this.text_area;
    }

    protected JPanel getButtonPanel() {
        return this.button_panel;
    }
}

