/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.AddMenu;
import uk.ac.sanger.artemis.components.BasePlot;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.StickyFileChooser;
import uk.ac.sanger.artemis.components.Utilities;
import uk.ac.sanger.artemis.components.ViewMenu;
import uk.ac.sanger.artemis.plot.Algorithm;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageWeight;
import uk.ac.sanger.artemis.plot.UserDataAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.FileDocument;

public class GraphMenu
extends JMenu {
    private JFrame frame;
    private BasePlotGroup base_plot_group;
    private EntryGroup entry_group = null;
    private ViewMenu view_menu;
    private AddMenu add_menu;
    private FeatureDisplay feature_display;
    private Vector algorithm_menu_items = new Vector();

    public GraphMenu(final JFrame frame, EntryGroup entry_group, final BasePlotGroup base_plot_group, FeatureDisplay feature_display, String menu_name) {
        super(menu_name);
        this.frame = frame;
        this.entry_group = entry_group;
        this.base_plot_group = base_plot_group;
        this.feature_display = feature_display;
        BaseAlgorithm[] orig_algorithms = base_plot_group.getPlotAlgorithms();
        JMenuItem hide_all_graphs_item = new JMenuItem("Hide All Graphs");
        hide_all_graphs_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BaseAlgorithm[] current_algorithms = base_plot_group.getPlotAlgorithms();
                int i = 0;
                while (i < current_algorithms.length) {
                    BaseAlgorithm this_algorithm = current_algorithms[i];
                    base_plot_group.setVisibleByAlgorithm(this_algorithm, false);
                    JCheckBoxMenuItem this_menu_item = (JCheckBoxMenuItem)GraphMenu.this.algorithm_menu_items.elementAt(i);
                    this_menu_item.setState(false);
                    ++i;
                }
                if (GraphMenu.this.getParent() != null) {
                    frame.validate();
                }
            }
        });
        this.add(hide_all_graphs_item);
        this.addSeparator();
        if (Options.readWritePossible()) {
            JMenuItem usage_plot_item = new JMenuItem("Add Usage Plots ...");
            usage_plot_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    GraphMenu.this.addUsagePlot();
                }
            });
            this.add(usage_plot_item);
            JMenuItem user_plot_item = new JMenuItem("Add User Plot ...");
            user_plot_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    GraphMenu.this.addUserPlot();
                }
            });
            this.add(user_plot_item);
            this.addSeparator();
        }
        int i = 0;
        while (i < orig_algorithms.length) {
            BaseAlgorithm this_algorithm = orig_algorithms[i];
            this.addAlgorithm(this_algorithm, false);
            ++i;
        }
        if (Options.getOptions().getProperty("codon_usage_file") != null) {
            String codon_usage_file_name = Options.getOptions().getProperty("codon_usage_file");
            try {
                this.addUsagePlot(new File(codon_usage_file_name), true, false);
                this.addUsagePlot(new File(codon_usage_file_name), false, false);
                if (this.getParent() != null) {
                    frame.validate();
                }
            }
            catch (IOException e) {
                new MessageDialog(frame, "error while reading usage data: " + e);
            }
        }
    }

    public GraphMenu(JFrame frame, EntryGroup entry_group, BasePlotGroup base_plot_group, FeatureDisplay feature_display) {
        this(frame, entry_group, base_plot_group, feature_display, "Graph");
    }

    public JCheckBoxMenuItem addAlgorithm(final BaseAlgorithm algorithm, boolean is_visible) {
        final JCheckBoxMenuItem new_item = new JCheckBoxMenuItem(algorithm.getAlgorithmName());
        new_item.setState(is_visible);
        new_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                GraphMenu.this.base_plot_group.setVisibleByAlgorithm(algorithm, new_item.getState());
            }
        });
        this.add(new_item);
        this.algorithm_menu_items.addElement(new_item);
        return new_item;
    }

    public void addUsagePlot() {
        JFrame frame = Utilities.getComponentFrame(this.base_plot_group);
        StickyFileChooser dialog = new StickyFileChooser();
        dialog.setDialogTitle("Select a codon usage data file name ...");
        dialog.setDialogType(0);
        int status = dialog.showOpenDialog(frame);
        if (status != 0 || dialog.getSelectedFile() == null) {
            return;
        }
        File file = new File(dialog.getCurrentDirectory(), dialog.getSelectedFile().getName());
        if (file.length() != 0L) {
            try {
                BasePlot new_forward_plot = this.addUsagePlot(file, true, true);
                BasePlot new_reverse_plot = this.addUsagePlot(file, false, true);
                Algorithm forward_algorithm = new_forward_plot.getAlgorithm();
                Algorithm reverse_algorithm = new_reverse_plot.getAlgorithm();
                this.base_plot_group.setVisibleByAlgorithm(forward_algorithm, true);
                this.base_plot_group.setVisibleByAlgorithm(reverse_algorithm, true);
            }
            catch (IOException e) {
                new MessageDialog(Utilities.getComponentFrame(this.base_plot_group), "error while reading usage data: " + e);
            }
        }
    }

    private BasePlot addUsagePlot(File codon_usage_file, boolean use_forward_strand, boolean is_visible) throws IOException {
        CodonUsageAlgorithm codon_usage_algorithm;
        CodonUsageWeight usage_weights;
        if (use_forward_strand) {
            Strand forward_strand = this.entry_group.getBases().getForwardStrand();
            usage_weights = new CodonUsageWeight(codon_usage_file, forward_strand);
            codon_usage_algorithm = new CodonUsageAlgorithm(forward_strand, usage_weights);
        } else {
            Strand backward_strand = this.entry_group.getBases().getReverseStrand();
            usage_weights = new CodonUsageWeight(codon_usage_file, backward_strand);
            codon_usage_algorithm = new CodonUsageAlgorithm(backward_strand, usage_weights);
        }
        this.addAlgorithm(codon_usage_algorithm, is_visible);
        BasePlot new_plot = this.base_plot_group.addAlgorithm(codon_usage_algorithm);
        this.base_plot_group.setVisibleByAlgorithm(codon_usage_algorithm, is_visible);
        DisplayAdjustmentEvent event = new DisplayAdjustmentEvent(this, this.feature_display.getFirstVisibleForwardBase(), this.feature_display.getLastVisibleForwardBase(), this.feature_display.getMaxVisibleBases(), this.feature_display.getScaleValue(), this.feature_display.getScaleFactor(), this.feature_display.isRevCompDisplay(), 3);
        this.base_plot_group.displayAdjustmentValueChanged(event);
        return new_plot;
    }

    private void addUserPlot() {
        JFrame frame = Utilities.getComponentFrame(this.base_plot_group);
        StickyFileChooser dialog = new StickyFileChooser();
        dialog.setDialogTitle("Select a data file name ...");
        dialog.setDialogType(0);
        int status = dialog.showOpenDialog(frame);
        if (status != 0 || dialog.getSelectedFile() == null) {
            return;
        }
        File file = new File(dialog.getCurrentDirectory(), dialog.getSelectedFile().getName());
        if (file.length() != 0L) {
            FileDocument document = new FileDocument(file);
            Strand forward_strand = this.getEntryGroup().getBases().getForwardStrand();
            try {
                UserDataAlgorithm new_algorithm = new UserDataAlgorithm(forward_strand, document);
                this.base_plot_group.addAlgorithm(new_algorithm);
                this.base_plot_group.setVisibleByAlgorithm(new_algorithm, true);
                this.addAlgorithm(new_algorithm, true);
                DisplayAdjustmentEvent event = new DisplayAdjustmentEvent(this, this.feature_display.getFirstVisibleForwardBase(), this.feature_display.getLastVisibleForwardBase(), this.feature_display.getMaxVisibleBases(), this.feature_display.getScaleValue(), this.feature_display.getScaleFactor(), this.feature_display.isRevCompDisplay(), 3);
                this.base_plot_group.displayAdjustmentValueChanged(event);
                if (this.getParent() != null) {
                    frame.validate();
                }
            }
            catch (IOException e) {
                new MessageDialog(Utilities.getComponentFrame(this.base_plot_group), "error while reading user data: " + e);
            }
        }
    }

    public JFrame getParentFrame() {
        return this.frame;
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }
}

