/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import uk.ac.sanger.artemis.editor.FastaListener;
import uk.ac.sanger.artemis.editor.FastaTextPane;
import uk.ac.sanger.artemis.editor.HitInfo;
import uk.ac.sanger.artemis.editor.ScrollPanel;

public class DBViewer
extends ScrollPanel
implements FastaListener {
    private Vector hitInfoCollection = null;
    private int qlen;
    private int bound = 10;
    private int ydisp = 5;
    private float max_score = 0.0f;
    private boolean colourByScore = false;
    private JPopupMenu popup;
    private int hgtNumber;
    private JScrollPane jsp;
    private float scale = 1.0f;
    private FastaTextPane fastaTextPane;

    public DBViewer(FastaTextPane fastaTextPane, JScrollPane jsp) {
        this.jsp = jsp;
        this.fastaTextPane = fastaTextPane;
        this.hitInfoCollection = fastaTextPane.getHitCollection();
        this.qlen = fastaTextPane.getQueryLength();
        Dimension d = new Dimension(500, this.hitInfoCollection.size() * this.ydisp + 6 * this.bound);
        this.setPreferredSize(d);
        this.setToolTipText("");
        Enumeration enumHits = this.hitInfoCollection.elements();
        while (enumHits.hasMoreElements()) {
            HitInfo hit = (HitInfo)enumHits.nextElement();
            float score = Float.parseFloat(hit.getScore());
            if (!(score > this.max_score)) continue;
            this.max_score = score;
        }
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        this.getOptionsMenu(this.popup);
    }

    public void update() {
        this.hitInfoCollection = this.fastaTextPane.getHitCollection();
        this.qlen = this.fastaTextPane.getQueryLength();
        Dimension d = new Dimension(500, this.hitInfoCollection.size() * this.ydisp + 6 * this.bound);
        this.setPreferredSize(d);
        Enumeration enumHits = this.hitInfoCollection.elements();
        while (enumHits.hasMoreElements()) {
            HitInfo hit = (HitInfo)enumHits.nextElement();
            float score = Float.parseFloat(hit.getScore());
            if (!(score > this.max_score)) continue;
            this.max_score = score;
        }
        this.jsp.setViewportView(this);
    }

    protected JMenu getFileMenu(final JInternalFrame jif) {
        JMenu fileMenu = new JMenu("File");
        JMenuItem exitMenu = new JMenuItem("Close");
        exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jif.dispose();
            }
        });
        fileMenu.add(exitMenu);
        return fileMenu;
    }

    protected void getOptionsMenu(JComponent menuOptions) {
        JMenuItem zoomInMenu = new JMenuItem("Zoom In");
        zoomInMenu.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        zoomInMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBViewer.this.setZoom(1.1f);
            }
        });
        menuOptions.add(zoomInMenu);
        JMenuItem zoomOutMenu = new JMenuItem("Zoom Out");
        zoomOutMenu.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        zoomOutMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBViewer.this.setZoom(0.9f);
            }
        });
        menuOptions.add(zoomOutMenu);
        menuOptions.add(new JSeparator());
        JRadioButtonMenuItem colourScore = new JRadioButtonMenuItem("Colour by Score");
        colourScore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBViewer.this.setColourByScore(true);
            }
        });
        menuOptions.add(colourScore);
        JRadioButtonMenuItem colourEval = new JRadioButtonMenuItem("Colour by E-value");
        colourEval.setSelected(true);
        colourEval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBViewer.this.setColourByScore(false);
            }
        });
        menuOptions.add(colourEval);
        ButtonGroup butt = new ButtonGroup();
        butt.add(colourScore);
        butt.add(colourEval);
    }

    protected void setZoom(float new_scale) {
        this.scale *= new_scale;
        Dimension d = this.getPreferredSize();
        double width = d.getWidth() * (double)new_scale;
        d = new Dimension((int)width, (int)d.getHeight());
        this.setPreferredSize(d);
        this.jsp.setViewportView(this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Font font = new Font("monospaced", 0, 10);
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics();
        this.hgtNumber = metrics.getAscent();
        Graphics2D g2 = (Graphics2D)g;
        int resultwidth = (int)this.getPreferredSize().getWidth() - 2 * this.bound;
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawLine(this.bound, this.bound + this.hgtNumber, this.bound + resultwidth, this.bound + this.hgtNumber);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawLine(this.bound, this.bound + this.hgtNumber, this.bound, this.bound + this.hgtNumber - 6);
        g2.drawString("0", this.bound, this.hgtNumber + 3);
        this.jsp.getViewport().getViewPosition();
        this.jsp.getViewport().getExtentSize();
        int npoints = (int)(this.scale * 10.0f);
        int unit = resultwidth / npoints;
        int blastUnit = this.qlen / npoints;
        int i = 1;
        while (i < npoints) {
            String strPos = Integer.toString(i * blastUnit);
            int strwid = metrics.stringWidth(strPos);
            g2.drawLine(this.bound + unit * i, this.bound + this.hgtNumber, this.bound + unit * i, this.bound + this.hgtNumber - 6);
            g2.drawString(strPos, this.bound + unit * i - strwid, this.hgtNumber + 3);
            ++i;
        }
        String strQlen = Integer.toString(this.qlen);
        int strwid = metrics.stringWidth(strQlen);
        g2.drawLine(this.bound + resultwidth, this.bound + this.hgtNumber, this.bound + resultwidth, this.bound + this.hgtNumber - 6);
        g2.drawString(strQlen, this.bound + resultwidth - strwid, this.hgtNumber + 3);
        int ypos = this.bound + this.ydisp + this.hgtNumber;
        Enumeration enumHits = this.hitInfoCollection.elements();
        while (enumHits.hasMoreElements()) {
            ypos += this.ydisp;
            HitInfo hit = (HitInfo)enumHits.nextElement();
            if (this.colourByScore) {
                float score = Float.parseFloat(hit.getScore());
                if (score > this.max_score / 2.0f) {
                    g2.setColor(Color.red);
                } else if (score > this.max_score / 4.0f) {
                    g2.setColor(Color.blue);
                } else {
                    g2.setColor(Color.cyan);
                }
            } else {
                Double evalue = new Double(hit.getEValue());
                if (evalue.compareTo(new Double("0.005")) < 0) {
                    g2.setColor(Color.red);
                } else if (evalue.compareTo(new Double("0.0")) < 0) {
                    g2.setColor(Color.blue);
                } else {
                    g2.setColor(Color.cyan);
                }
            }
            g2.setStroke(new BasicStroke(1.0f));
            float hit_unit = (float)resultwidth / (float)this.qlen;
            int start = (int)((float)this.bound + hit_unit * (float)hit.getQueryStart());
            int end = (int)((float)this.bound + hit_unit * (float)hit.getQueryEnd());
            g2.drawLine(start, this.bound + ypos, end, this.bound + ypos);
        }
    }

    protected void setColourByScore(boolean colourByScore) {
        this.colourByScore = colourByScore;
        this.repaint();
    }

    public String getToolTipText(MouseEvent e) {
        Point loc = e.getPoint();
        int seqPos = (loc.y - this.bound - this.ydisp - this.bound - this.ydisp - this.hgtNumber) / this.ydisp;
        if (seqPos >= 0 && seqPos < this.hitInfoCollection.size()) {
            HitInfo hit = (HitInfo)this.hitInfoCollection.get(seqPos);
            return String.valueOf(hit.getID()) + "\n" + hit.getOrganism() + "\nE-value:" + hit.getEValue() + " Score:" + hit.getScore();
        }
        return null;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            } else if (e.getClickCount() == 2) {
                int seqPos = (e.getY() - DBViewer.this.bound - DBViewer.this.ydisp - DBViewer.this.bound - DBViewer.this.ydisp - DBViewer.this.hgtNumber) / DBViewer.this.ydisp;
                HitInfo hit = (HitInfo)DBViewer.this.hitInfoCollection.get(seqPos);
                DBViewer.this.fastaTextPane.show(hit);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DBViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

