/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class HitInfo {
    private String db = null;
    private String id = null;
    private String acc = null;
    private String org = null;
    private String geneName = null;
    private String desc = null;
    private String length = null;
    private String opt = null;
    private String zscore = null;
    private String evalue = null;
    private String header = null;
    private String emblID = null;
    private String score = null;
    private String identity = null;
    private String ungapped = null;
    private String aaOverlap = null;
    private String queryRange = null;
    private String subjectRange = null;
    private int startPosition = 0;
    private int endPosition = 0;
    private Vector go;
    private int startQuery;
    private int endQuery;

    public HitInfo(String header, String format) {
        this.header = header = header.trim();
        if (format.equals("fasta")) {
            this.setFastaHitInfo(header);
        } else if (format.equals("blastp")) {
            this.setBLASTPInfo(header);
        }
    }

    protected void setBLASTPInfo(String header) {
        int ind2;
        int ind1 = header.indexOf(" ");
        if (ind1 <= -1) {
            return;
        }
        this.id = header.substring(0, ind1);
        int ind1a = this.id.indexOf(":");
        if (ind1a > -1) {
            this.db = this.id.substring(0, ind1a);
            this.id = this.id.substring(ind1a + 1);
        }
        if ((ind2 = header.indexOf(" ", ind1 + 1)) <= -1) {
            return;
        }
        this.acc = header.substring(ind1 + 1, ind2);
        ind1 = header.lastIndexOf(" ");
        this.evalue = header.substring(ind1).trim();
        ind2 = header.substring(0, ind1).trim().lastIndexOf(" ");
        if (ind2 > -1) {
            this.score = header.substring(ind2, ind1).trim();
        }
    }

    protected void setFastaHitInfo(String header) {
        int ind1 = header.indexOf(" ");
        if (ind1 <= -1) {
            return;
        }
        this.id = header.substring(0, ind1);
        int ind2 = header.indexOf(" ", ind1 + 1);
        if (ind2 <= -1) {
            return;
        }
        this.acc = header.substring(ind1 + 1, ind2);
        ind1 = ind2;
        ind2 = header.indexOf("(", ind1);
        if (ind2 <= -1) {
            return;
        }
        this.desc = header.substring(ind1, ind2).trim();
        ind1 = ind2 + 1;
        ind2 = header.indexOf(")", ind1);
        if (ind2 <= -1) {
            return;
        }
        this.length = header.substring(ind1, ind2).trim();
        StringTokenizer tok = new StringTokenizer(header.substring(ind2 + 1));
        try {
            this.opt = tok.nextToken();
            this.zscore = tok.nextToken();
            this.evalue = tok.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    protected int getQueryStart() {
        return this.startQuery;
    }

    protected int getQueryEnd() {
        return this.endQuery;
    }

    protected void setQueryStart(int startQuery) {
        this.startQuery = startQuery;
    }

    protected void setQueryEnd(int endQuery) {
        this.endQuery = endQuery;
    }

    protected void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    protected void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    protected void setLength(String length) {
        this.length = length;
    }

    protected String getLength() {
        return this.length;
    }

    protected String getHeader() {
        return this.header;
    }

    protected int getStartPosition() {
        return this.startPosition;
    }

    protected int getEndPosition() {
        return this.endPosition;
    }

    protected String getDB() {
        return this.db;
    }

    protected String getID() {
        return this.id;
    }

    protected String getAcc() {
        return this.acc;
    }

    protected String getOrganism() {
        return this.org;
    }

    protected void setOrganism(String org) {
        this.org = org;
    }

    protected void setDescription(String desc) {
        this.desc = desc;
    }

    protected void appendDescription(String s) {
        this.desc = this.desc == null ? new String(s) : String.valueOf(this.desc) + " " + s;
        this.desc = this.desc.trim();
    }

    protected String getDescription() {
        return this.desc;
    }

    protected void setEMBL(String emblID) {
        this.emblID = emblID;
    }

    protected String getEMBL() {
        return this.emblID;
    }

    protected void setScore(String score) {
        this.score = score;
    }

    protected String getScore() {
        return this.score;
    }

    protected void setIdentity(String identity) {
        this.identity = identity;
    }

    protected String getIdentity() {
        return this.identity;
    }

    protected void setUngapped(String ungapped) {
        this.ungapped = ungapped;
    }

    protected String getUngapped() {
        return this.ungapped;
    }

    protected void setEValue(String evalue) {
        this.evalue = evalue;
    }

    protected String getEValue() {
        return this.evalue;
    }

    protected void setOverlap(String aaOverlap) {
        this.aaOverlap = aaOverlap;
    }

    protected String getOverlap() {
        return this.aaOverlap;
    }

    protected void setQueryRange(String queryRange) {
        this.queryRange = queryRange;
    }

    protected String getQueryRange() {
        return this.queryRange;
    }

    protected void setSubjectRange(String subjectRange) {
        this.subjectRange = subjectRange;
    }

    protected String getSubjectRange() {
        return this.subjectRange;
    }

    protected void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    protected String getGeneName() {
        return this.geneName;
    }

    protected void setGO(String go_terms) {
        go_terms = go_terms.trim();
        StringTokenizer tok = new StringTokenizer(go_terms);
        while (tok.hasMoreElements()) {
            if (this.go == null) {
                this.go = new Vector();
            }
            this.go.add(tok.nextToken());
        }
    }

    protected Vector getGO() {
        return this.go;
    }
}

