/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.File;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Date;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;

public class DocumentEntryAutosaveThread
extends Thread {
    private static final int SLEEP_TIME = 120000;
    private DocumentEntry document_entry;

    public DocumentEntryAutosaveThread(DocumentEntry document_entry) {
        this.document_entry = document_entry;
        this.setPriority(1);
    }

    public void run() {
        Date last_save_time = null;
        boolean have_saved = false;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {}
        while (true) {
            String entry_name;
            if ((entry_name = this.document_entry.getName()) == null) {
                continue;
            }
            File save_file = new File("#" + entry_name + "#");
            Date last_change_time = this.document_entry.getLastChangeTime();
            if (this.document_entry.hasUnsavedChanges() && (last_save_time == null || last_change_time != null && last_change_time.after(last_save_time))) {
                FileDocument save_document = new FileDocument(save_file);
                try {
                    this.document_entry.save(save_document);
                    have_saved = true;
                }
                catch (IOException iOException) {
                    System.err.println("warning: could not auto save to: " + ((Document)save_document).getName() + " (will try again later)");
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
            } else if (have_saved) {
                File new_name = new File(String.valueOf(entry_name) + "~");
                save_file.renameTo(new_name);
            }
            last_save_time = last_change_time;
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

